/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.spec.javaee.rest;

import java.util.Arrays;
import java.util.List;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.forge.env.Configuration;
import org.jboss.forge.project.dependencies.Dependency;
import org.jboss.forge.project.dependencies.DependencyBuilder;
import org.jboss.forge.project.dependencies.DependencyInstaller;
import org.jboss.forge.project.facets.events.InstallFacets;
import org.jboss.forge.shell.PromptType;
import org.jboss.forge.shell.ShellPrompt;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.RequiresFacet;
import org.jboss.forge.spec.javaee.BaseJavaEEFacet;
import org.jboss.forge.spec.javaee.RestActivatorType;
import org.jboss.forge.spec.javaee.RestApplicationFacet;
import org.jboss.forge.spec.javaee.RestFacet;
import org.jboss.forge.spec.javaee.RestWebXmlFacet;
import org.jboss.forge.spec.javaee.ServletFacet;
import org.jboss.forge.spec.javaee.rest.RestWebXmlFacetImpl;

@Alias(value="forge.spec.jaxrs")
@RequiresFacet(value={ServletFacet.class})
public class RestFacetImpl
extends BaseJavaEEFacet
implements RestFacet {
    @Inject
    private Configuration configuration;
    @Inject
    private ShellPrompt prompt;
    @Inject
    private Event<InstallFacets> request;

    @Inject
    public RestFacetImpl(DependencyInstaller installer) {
        super(installer);
    }

    @Override
    public boolean install() {
        RestActivatorType activatorType = null;
        String activatorChoice = this.configuration.getString("activatorChoice");
        activatorType = activatorChoice == null || activatorChoice.equals("") ? (RestActivatorType)this.prompt.promptEnum("How do you want to activate REST resources in your application ?", RestActivatorType.class, (Enum)RestActivatorType.WEB_XML) : RestActivatorType.valueOf((String)activatorChoice);
        String rootpath = this.prompt.prompt("What root path do you want to use for your resources?", "/rest");
        this.configuration.addProperty("rootpath", (Object)rootpath);
        if (activatorType == null || activatorType == RestActivatorType.WEB_XML && !this.project.hasFacet(RestWebXmlFacetImpl.class)) {
            this.request.fire((Object)new InstallFacets(RestWebXmlFacetImpl.class));
        } else if (activatorType == RestActivatorType.APP_CLASS && !this.project.hasFacet(RestApplicationFacet.class)) {
            String pkg = this.prompt.promptCommon("In what package do you want to store the Application class?", PromptType.JAVA_PACKAGE);
            String restApplication = this.prompt.prompt("How do you want to name the Application class?", "RestApplication");
            this.configuration.addProperty("rest.applicationclass.package", (Object)pkg);
            this.configuration.addProperty("rest.applicationclass.name", (Object)restApplication);
            this.request.fire((Object)new InstallFacets(RestApplicationFacet.class));
        }
        return super.install();
    }

    @Override
    public boolean isInstalled() {
        if (!this.project.hasFacet(RestWebXmlFacet.class) && !this.project.hasFacet(RestApplicationFacet.class)) {
            return false;
        }
        return super.isInstalled();
    }

    @Override
    protected List<Dependency> getRequiredDependencies() {
        return Arrays.asList(DependencyBuilder.create((String)"org.jboss.spec.javax.ws.rs:jboss-jaxrs-api_1.1_spec"));
    }

    public String getApplicationPath() {
        return this.configuration.getString("rootpath");
    }
}

