/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.spec.javaee.rest;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.xml.bind.annotation.XmlRootElement;
import org.jboss.forge.parser.JavaParser;
import org.jboss.forge.parser.java.Annotation;
import org.jboss.forge.parser.java.Field;
import org.jboss.forge.parser.java.JavaClass;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.parser.java.Member;
import org.jboss.forge.parser.java.Method;
import org.jboss.forge.parser.java.Parameter;
import org.jboss.forge.parser.java.util.Strings;
import org.jboss.forge.parser.java.util.Types;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.facets.JavaSourceFacet;
import org.jboss.forge.project.facets.events.InstallFacets;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.resources.java.JavaResource;
import org.jboss.forge.shell.ShellMessages;
import org.jboss.forge.shell.ShellPrintWriter;
import org.jboss.forge.shell.ShellPrompt;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.Command;
import org.jboss.forge.shell.plugins.Current;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.PipeOut;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.RequiresProject;
import org.jboss.forge.shell.plugins.SetupCommand;
import org.jboss.forge.shell.project.ProjectScoped;
import org.jboss.forge.spec.javaee.EJBFacet;
import org.jboss.forge.spec.javaee.JTAFacet;
import org.jboss.forge.spec.javaee.PersistenceFacet;
import org.jboss.forge.spec.javaee.RestActivatorType;
import org.jboss.forge.spec.javaee.RestFacet;
import org.jboss.forge.spec.javaee.events.RestGeneratedResources;
import org.jboss.forge.spec.javaee.rest.ContentTypeCompleter;
import org.jboss.shrinkwrap.descriptor.api.spec.jpa.persistence.PersistenceDescriptor;
import org.jboss.shrinkwrap.descriptor.api.spec.jpa.persistence.PersistenceUnitDef;

@Alias(value="rest")
@RequiresProject
public class RestPlugin
implements Plugin {
    @Inject
    private Project project;
    @Inject
    private Event<InstallFacets> request;
    @Inject
    private Event<RestGeneratedResources> generatedEvent;
    @Inject
    @Current
    private Resource<?> currentResource;
    @Inject
    private ShellPrompt prompt;
    @Inject
    @ProjectScoped
    org.jboss.forge.env.Configuration configuration;

    @SetupCommand
    public void setup(@Option(name="activatorType", defaultValue="WEB_XML") RestActivatorType activatorType, PipeOut out) {
        if (!this.project.hasFacet(RestFacet.class)) {
            this.configuration.setProperty("activatorChoice", (Object)activatorType.toString());
            this.request.fire((Object)new InstallFacets(RestFacet.class));
        }
        if (this.project.hasFacet(RestFacet.class)) {
            ShellMessages.success((ShellPrintWriter)out, (String)"Rest Web Services (JAX-RS) is installed.");
        }
    }

    @Command(value="endpoint-from-entity", help="Creates a REST endpoint from an existing domain @Entity object")
    public void endpointFromEntity(PipeOut out, @Option(name="contentType", defaultValue="application/xml", completer=ContentTypeCompleter.class) String contentType, @Option(required=false) JavaResource[] targets) throws FileNotFoundException {
        List<JavaResource> javaTargets;
        if (!this.project.hasAllFacets(Arrays.asList(EJBFacet.class, PersistenceFacet.class))) {
            this.request.fire((Object)new InstallFacets(true, new Class[]{JTAFacet.class, EJBFacet.class, PersistenceFacet.class}));
        }
        if ((targets == null || targets.length < 1) && this.currentResource instanceof JavaResource) {
            targets = new JavaResource[]{(JavaResource)this.currentResource};
        }
        if ((javaTargets = this.selectTargets(out, (Resource<?>[])targets)).isEmpty()) {
            throw new IllegalArgumentException("Must specify a domain @Entity on which to operate.");
        }
        JavaSourceFacet java = (JavaSourceFacet)this.project.getFacet(JavaSourceFacet.class);
        ArrayList<JavaResource> endpoints = new ArrayList<JavaResource>();
        ArrayList<JavaResource> entities = new ArrayList<JavaResource>();
        for (JavaResource jr : javaTargets) {
            String idType;
            JavaClass entity = (JavaClass)jr.getJavaSource();
            if (!entity.hasAnnotation(XmlRootElement.class)) {
                entity.addAnnotation(XmlRootElement.class);
            }
            if (!Types.isBasicType((String)(idType = this.resolveIdType(entity)))) {
                ShellMessages.error((ShellPrintWriter)out, (String)("Skipped class [" + entity.getQualifiedName() + "] because @Id type [" + idType + "] is not supported by endpoint generation."));
                continue;
            }
            String idSetterName = this.resolveIdSetterName(entity);
            String idGetterName = this.resolveIdGetterName(entity);
            Configuration freemarkerConfig = new Configuration();
            freemarkerConfig.setClassForTemplateLoading(this.getClass(), "/");
            freemarkerConfig.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("entity", entity);
            map.put("idType", idType);
            map.put("setIdStatement", idSetterName);
            map.put("getIdStatement", idGetterName);
            map.put("contentType", contentType);
            String persistenceUnitName = this.getPersistenceUnitName();
            String entityTable = this.getEntityTable(entity);
            String selectExpression = this.getSelectExpression(entity, entityTable);
            String idClause = this.getIdClause(entity, entityTable);
            map.put("persistenceUnitName", persistenceUnitName);
            map.put("entityTable", entityTable);
            map.put("selectExpression", selectExpression);
            map.put("idClause", idClause);
            map.put("resourcePath", entityTable.toLowerCase() + "s");
            StringWriter output = new StringWriter();
            try {
                Template templateFile = freemarkerConfig.getTemplate("org/jboss/forge/rest/Endpoint.jv");
                templateFile.process(map, (Writer)output);
                ((Writer)output).flush();
            }
            catch (IOException ioEx) {
                throw new RuntimeException(ioEx);
            }
            catch (TemplateException templateEx) {
                throw new RuntimeException(templateEx);
            }
            JavaClass resource = (JavaClass)JavaParser.parse(JavaClass.class, (String)((Object)output).toString());
            resource.addImport(entity.getQualifiedName());
            resource.setPackage(java.getBasePackage() + ".rest");
            entities.add(java.saveJavaSource((JavaSource)entity));
            if (!java.getJavaResource((JavaSource)resource).exists() || this.prompt.promptBoolean("Endpoint [" + resource.getQualifiedName() + "] already, exists. Overwrite?")) {
                endpoints.add(java.saveJavaSource((JavaSource)resource));
                ShellMessages.success((ShellPrintWriter)out, (String)("Generated REST endpoint for [" + entity.getQualifiedName() + "]"));
                continue;
            }
            ShellMessages.info((ShellPrintWriter)out, (String)("Aborted REST endpoint generation for [" + entity.getQualifiedName() + "]"));
        }
        if (!entities.isEmpty()) {
            this.generatedEvent.fire((Object)new RestGeneratedResources(entities, endpoints));
        }
    }

    private String resolveIdType(JavaClass entity) {
        for (Member member : entity.getMembers()) {
            if (!member.hasAnnotation(Id.class)) continue;
            if (member instanceof Method) {
                return ((Method)member).getReturnType();
            }
            if (!(member instanceof Field)) continue;
            return ((Field)member).getType();
        }
        return "Object";
    }

    private String resolveIdSetterName(JavaClass entity) {
        String result = null;
        for (Member member : entity.getMembers()) {
            if (!member.hasAnnotation(Id.class)) continue;
            String name = member.getName();
            String type = null;
            if (member instanceof Method) {
                type = ((Method)member).getReturnType();
                if (name.startsWith("get")) {
                    name = name.substring(2);
                }
            } else if (member instanceof Field) {
                type = ((Field)member).getType();
            }
            if (type != null) {
                for (Method method : entity.getMethods()) {
                    Parameter param;
                    if (method.getParameters().size() != 1 || method.getReturnType() != null || !type.equals((param = (Parameter)method.getParameters().get(0)).getType()) || !method.getName().toLowerCase().contains(name.toLowerCase())) continue;
                    result = method.getName() + "(id)";
                    break;
                }
            }
            if (result != null) break;
            if (type == null || !member.isPublic()) continue;
            String memberName = member.getName();
            if (member instanceof Method && memberName.startsWith("get")) {
                memberName = memberName.substring(3);
                memberName = Strings.uncapitalize((String)memberName);
            }
            result = memberName + " = id";
        }
        if (result == null) {
            throw new RuntimeException("Could not determine @Id field and setter method for @Entity [" + entity.getQualifiedName() + "]. Aborting.");
        }
        return result;
    }

    private String resolveIdGetterName(JavaClass entity) {
        String result = null;
        for (Member member : entity.getMembers()) {
            if (!member.hasAnnotation(Id.class)) continue;
            String name = member.getName();
            String type = null;
            if (member instanceof Method) {
                type = ((Method)member).getReturnType();
                if (name.startsWith("get")) {
                    name = name.substring(2);
                }
            } else if (member instanceof Field) {
                type = ((Field)member).getType();
            }
            if (type != null) {
                for (Method method : entity.getMethods()) {
                    if (method.getParameters().size() != 0 || !type.equals(method.getReturnType()) || !method.getName().toLowerCase().contains(name.toLowerCase())) continue;
                    result = method.getName() + "()";
                    break;
                }
            }
            if (result != null) break;
            if (type == null || !member.isPublic()) continue;
            String memberName = member.getName();
            if (member instanceof Method && memberName.startsWith("get")) {
                memberName = memberName.substring(3);
                memberName = Strings.uncapitalize((String)memberName);
            }
            result = memberName;
        }
        if (result == null) {
            throw new RuntimeException("Could not determine @Id field and getter method for @Entity [" + entity.getQualifiedName() + "]. Aborting.");
        }
        return result;
    }

    private String getEntityTable(JavaClass entity) {
        String table = entity.getName();
        if (entity.hasAnnotation(Entity.class)) {
            Annotation a = entity.getAnnotation(Entity.class);
            if (!Strings.isNullOrEmpty((String)a.getStringValue("name"))) {
                table = a.getStringValue("name");
            } else if (!Strings.isNullOrEmpty((String)a.getStringValue())) {
                table = a.getStringValue();
            }
        }
        return table;
    }

    private String getSelectExpression(JavaClass entity, String entityTable) {
        char entityVariable = entityTable.toLowerCase().charAt(0);
        StringBuilder expressionBuilder = new StringBuilder();
        expressionBuilder.append("SELECT ");
        expressionBuilder.append(entityVariable);
        expressionBuilder.append(" FROM ");
        expressionBuilder.append(entityTable);
        expressionBuilder.append(" ");
        expressionBuilder.append(entityVariable);
        for (Member member : entity.getMembers()) {
            if (!member.hasAnnotation(OneToOne.class) && !member.hasAnnotation(OneToMany.class) && !member.hasAnnotation(ManyToMany.class) && !member.hasAnnotation(ManyToOne.class)) continue;
            String name = member.getName();
            String associationField = null;
            if (member instanceof Method) {
                if (name.startsWith("get")) {
                    associationField = Strings.uncapitalize((String)name.substring(2));
                }
            } else if (member instanceof Field) {
                associationField = name;
            }
            if (associationField == null) {
                throw new RuntimeException("Could not compute the association field for member:" + member.getName() + " in entity" + entity.getName());
            }
            expressionBuilder.append(" LEFT JOIN FETCH ");
            expressionBuilder.append(entityVariable);
            expressionBuilder.append('.');
            expressionBuilder.append(associationField);
        }
        return expressionBuilder.toString();
    }

    private String getIdClause(JavaClass entity, String entityTable) {
        for (Member member : entity.getMembers()) {
            if (!member.hasAnnotation(Id.class)) continue;
            String memberName = member.getName();
            String id = null;
            if (member instanceof Method) {
                id = Strings.uncapitalize((String)memberName.substring(2));
            }
            if (member instanceof Field) {
                id = memberName;
            }
            char entityVariable = entityTable.toLowerCase().charAt(0);
            return "WHERE " + entityVariable + "." + id + " = " + ":entityId";
        }
        return null;
    }

    private List<JavaResource> selectTargets(PipeOut out, Resource<?>[] targets) throws FileNotFoundException {
        ArrayList<JavaResource> results = new ArrayList<JavaResource>();
        if (targets == null) {
            targets = new Resource[]{};
        }
        for (Resource<?> r : targets) {
            if (!(r instanceof JavaResource)) continue;
            JavaSource entity = ((JavaResource)r).getJavaSource();
            if (entity instanceof JavaClass) {
                if (entity.hasAnnotation(Entity.class)) {
                    results.add((JavaResource)r);
                    continue;
                }
                this.displaySkippingResourceMsg(out, entity);
                continue;
            }
            this.displaySkippingResourceMsg(out, entity);
        }
        return results;
    }

    private void displaySkippingResourceMsg(PipeOut out, JavaSource<?> entity) {
        if (!out.isPiped()) {
            ShellMessages.info((ShellPrintWriter)out, (String)("Skipped non-@Entity Java resource [" + entity.getQualifiedName() + "]"));
        }
    }

    private String getPersistenceUnitName() {
        PersistenceFacet persistence = (PersistenceFacet)this.project.getFacet(PersistenceFacet.class);
        PersistenceDescriptor persistenceDescriptor = persistence.getConfig();
        List units = persistenceDescriptor.listUnits();
        if (units.size() == 1) {
            return ((PersistenceUnitDef)units.get(0)).getName();
        }
        ArrayList<String> unitNames = new ArrayList<String>();
        for (PersistenceUnitDef unitDef : units) {
            unitNames.add(unitDef.getName());
        }
        String chosenUnit = (String)this.prompt.promptChoiceTyped("Multiple persistence units were detected. Which persistence unit do you want to inject in the REST resources?", unitNames, unitNames.get(0));
        return chosenUnit;
    }
}

