/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.spec.javaee.jpa;

import java.io.Serializable;
import javax.inject.Inject;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Version;
import org.jboss.forge.parser.JavaParser;
import org.jboss.forge.parser.java.Field;
import org.jboss.forge.parser.java.JavaClass;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.parser.java.util.Refactory;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.facets.JavaSourceFacet;
import org.jboss.forge.resources.DirectoryResource;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.resources.java.JavaResource;
import org.jboss.forge.shell.PromptType;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.DefaultCommand;
import org.jboss.forge.shell.plugins.Help;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.RequiresFacet;
import org.jboss.forge.shell.plugins.RequiresProject;
import org.jboss.forge.shell.util.ResourceUtil;
import org.jboss.forge.spec.javaee.PersistenceFacet;

@Alias(value="entity")
@RequiresProject
@RequiresFacet(value={PersistenceFacet.class})
@Help(value="A plugin to manage simple @Entity and View creation; a basic MVC framework plugin.")
public class EntityPlugin
implements Plugin {
    private final Project project;
    private final Shell shell;

    @Inject
    public EntityPlugin(Project project, Shell shell) {
        this.project = project;
        this.shell = shell;
    }

    @DefaultCommand(help="Create a JPA @Entity")
    public void newEntity(@Option(required=true, name="named", description="The @Entity name") String entityName, @Option(required=false, name="package", type=PromptType.JAVA_PACKAGE, description="The package name") String packageName, @Option(name="idStrategy", defaultValue="AUTO", description="The GenerationType name for the ID") GenerationType idStrategy) throws Throwable {
        PersistenceFacet jpa = (PersistenceFacet)this.project.getFacet(PersistenceFacet.class);
        JavaSourceFacet java = (JavaSourceFacet)this.project.getFacet(JavaSourceFacet.class);
        String entityPackage = packageName != null && !"".equals(packageName) ? packageName : (this.getPackagePortionOfCurrentDirectory() != null ? this.getPackagePortionOfCurrentDirectory() : this.shell.promptCommon("In which package you'd like to create this @Entity, or enter for default", PromptType.JAVA_PACKAGE, jpa.getEntityPackage()));
        JavaClass javaClass = (JavaClass)((JavaClass)((JavaClass)((JavaClass)((JavaClass)((JavaClass)JavaParser.create(JavaClass.class)).setPackage(entityPackage)).setName(entityName)).setPublic()).addAnnotation(Entity.class).getOrigin()).addInterface(Serializable.class);
        Field id = javaClass.addField("private Long id = null;");
        id.addAnnotation(Id.class);
        id.addAnnotation(GeneratedValue.class).setEnumValue("strategy", (Enum)idStrategy);
        id.addAnnotation(Column.class).setStringValue("name", "id").setLiteralValue("updatable", "false").setLiteralValue("nullable", "false");
        Field version = javaClass.addField("private int version = 0;");
        version.addAnnotation(Version.class);
        version.addAnnotation(Column.class).setStringValue("name", "version");
        Refactory.createGetterAndSetter((JavaClass)javaClass, (Field)id);
        Refactory.createGetterAndSetter((JavaClass)javaClass, (Field)version);
        Refactory.createToStringFromFields((JavaClass)javaClass, (Field[])new Field[]{id});
        Refactory.createHashCodeAndEquals((JavaClass)javaClass);
        JavaResource javaFileLocation = java.saveJavaSource((JavaSource)javaClass);
        this.shell.println("Created @Entity [" + javaClass.getQualifiedName() + "]");
        this.shell.execute("pick-up " + javaFileLocation.getFullyQualifiedName().replace(" ", "\\ "));
    }

    private String getPackagePortionOfCurrentDirectory() {
        for (DirectoryResource r : ((JavaSourceFacet)this.project.getFacet(JavaSourceFacet.class)).getSourceFolders()) {
            DirectoryResource currentDirectory;
            if (!ResourceUtil.isChildOf((Resource)r, (Resource)(currentDirectory = this.shell.getCurrentDirectory()))) continue;
            return currentDirectory.getFullyQualifiedName().replace(r.getFullyQualifiedName() + "/", "").replaceAll("/", ".");
        }
        return null;
    }
}

