/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.spec.javaee.jpa.container;

import javax.inject.Inject;
import org.jboss.forge.shell.ShellMessages;
import org.jboss.forge.shell.ShellPrintWriter;
import org.jboss.forge.spec.javaee.jpa.api.JPADataSource;
import org.jboss.forge.spec.javaee.jpa.api.PersistenceContainer;
import org.jboss.shrinkwrap.descriptor.api.spec.jpa.persistence.PersistenceUnitDef;
import org.jboss.shrinkwrap.descriptor.api.spec.jpa.persistence.TransactionType;

public class CustomJTAContainer
implements PersistenceContainer {
    @Inject
    private ShellPrintWriter writer;

    @Override
    public PersistenceUnitDef setupConnection(PersistenceUnitDef unit, JPADataSource dataSource) {
        unit.transactionType(TransactionType.JTA);
        if (dataSource.getJndiDataSource() == null || dataSource.getJndiDataSource().trim().isEmpty()) {
            throw new RuntimeException("Must specify a JTA data-source.");
        }
        if (dataSource.hasJdbcConnectionInfo()) {
            ShellMessages.info((ShellPrintWriter)this.writer, (String)("Ignoring jdbc connection info [" + dataSource.getJdbcConnectionInfo() + "]"));
        }
        unit.jtaDataSource(dataSource.getJndiDataSource());
        unit.nonJtaDataSource(null);
        return unit;
    }

    @Override
    public TransactionType getTransactionType() {
        return TransactionType.JTA;
    }
}

