/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.spec.javaee.rest;

import java.util.HashMap;
import javax.inject.Inject;
import org.jboss.forge.parser.JavaParser;
import org.jboss.forge.parser.java.JavaClass;
import org.jboss.forge.spec.javaee.events.RestGeneratedResources;
import org.jboss.forge.spec.javaee.rest.DTOCollection;
import org.jboss.forge.spec.javaee.rest.ResourceGeneratorUtil;
import org.jboss.forge.spec.javaee.rest.RootAndNestedDtoGenerator;
import org.jboss.forge.spec.javaee.util.FreemarkerTemplateProcessor;

public class RootAndNestedDTOBasedResourceGenerator {
    @Inject
    FreemarkerTemplateProcessor processor;
    @Inject
    private RootAndNestedDtoGenerator dtoCreator;
    @Inject
    ResourceGeneratorUtil utility;

    public JavaClass generateFrom(JavaClass entity, String idType, String contentType, RestGeneratedResources generatedResourcesEvent) {
        DTOCollection createdDtos = this.dtoCreator.from(entity, this.utility.getPackageName() + ".dto");
        generatedResourcesEvent.addToOthers(createdDtos.allResources());
        JavaClass rootDto = createdDtos.getDTOFor(entity, true);
        String idGetterName = ResourceGeneratorUtil.resolveIdGetterName(entity);
        String persistenceUnitName = this.utility.getPersistenceUnitName();
        String entityTable = ResourceGeneratorUtil.getEntityTable(entity);
        String selectExpression = ResourceGeneratorUtil.getSelectExpression(entity, entityTable);
        String idClause = ResourceGeneratorUtil.getIdClause(entity, entityTable);
        String orderClause = ResourceGeneratorUtil.getOrderClause(entity, ResourceGeneratorUtil.getJpqlEntityVariable(entityTable));
        String resourcePath = this.utility.getResourcePath(entityTable);
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put("entity", entity);
        map.put("dto", rootDto);
        map.put("idType", idType);
        map.put("getIdStatement", idGetterName);
        map.put("contentType", contentType);
        map.put("persistenceUnitName", persistenceUnitName);
        map.put("entityTable", entityTable);
        map.put("selectExpression", selectExpression);
        map.put("idClause", idClause);
        map.put("orderClause", orderClause);
        map.put("resourcePath", resourcePath);
        String output = this.processor.processTemplate(map, "org/jboss/forge/rest/EndpointWithDTO.jv");
        JavaClass resource = (JavaClass)JavaParser.parse(JavaClass.class, (String)output);
        resource.addImport(entity.getQualifiedName());
        resource.addImport(rootDto.getQualifiedName());
        resource.setPackage(this.utility.getPackageName());
        return resource;
    }
}

