/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.spec.javaee;

import java.util.List;
import javax.inject.Inject;
import org.jboss.forge.project.dependencies.Dependency;
import org.jboss.forge.project.dependencies.DependencyBuilder;
import org.jboss.forge.project.dependencies.DependencyInstaller;
import org.jboss.forge.project.dependencies.ScopeType;
import org.jboss.forge.project.facets.BaseFacet;
import org.jboss.forge.project.facets.DependencyFacet;
import org.jboss.forge.project.packaging.PackagingType;
import org.jboss.forge.shell.plugins.RequiresFacet;

@RequiresFacet(value={DependencyFacet.class})
public abstract class BaseJavaEEFacet
extends BaseFacet {
    public static final Dependency JAVAEE6 = DependencyBuilder.create((String)"org.jboss.spec:jboss-javaee-6.0").setScopeType(ScopeType.IMPORT).setPackagingType(PackagingType.BASIC);
    private final DependencyInstaller installer;

    @Inject
    public BaseJavaEEFacet(DependencyInstaller installer) {
        this.installer = installer;
    }

    public boolean install() {
        for (Dependency requirement : this.getRequiredDependencies()) {
            if (this.getInstaller().isInstalled(this.project, requirement)) continue;
            DependencyFacet deps = (DependencyFacet)this.project.getFacet(DependencyFacet.class);
            if (!deps.hasEffectiveManagedDependency(requirement) && !deps.hasDirectManagedDependency(JAVAEE6)) {
                this.getInstaller().installManaged(this.project, JAVAEE6);
            }
            this.getInstaller().install(this.project, requirement, ScopeType.PROVIDED);
        }
        return true;
    }

    public boolean isInstalled() {
        DependencyFacet deps = (DependencyFacet)this.project.getFacet(DependencyFacet.class);
        for (Dependency requirement : this.getRequiredDependencies()) {
            if (deps.hasEffectiveDependency(requirement)) continue;
            return false;
        }
        return true;
    }

    protected abstract List<Dependency> getRequiredDependencies();

    public DependencyInstaller getInstaller() {
        return this.installer;
    }
}

