/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.spec.javaee.ejb;

import java.io.FileNotFoundException;
import java.io.Serializable;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.jboss.forge.parser.JavaParser;
import org.jboss.forge.parser.java.Annotation;
import org.jboss.forge.parser.java.JavaClass;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.parser.java.Method;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.facets.JavaSourceFacet;
import org.jboss.forge.project.facets.events.InstallFacets;
import org.jboss.forge.resources.DirectoryResource;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.resources.java.JavaMethodResource;
import org.jboss.forge.resources.java.JavaResource;
import org.jboss.forge.shell.PromptType;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.ShellMessages;
import org.jboss.forge.shell.ShellPrintWriter;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.Command;
import org.jboss.forge.shell.plugins.Current;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.PipeOut;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.RequiresFacet;
import org.jboss.forge.shell.plugins.RequiresProject;
import org.jboss.forge.shell.plugins.RequiresResource;
import org.jboss.forge.shell.plugins.SetupCommand;
import org.jboss.forge.shell.util.ResourceUtil;
import org.jboss.forge.spec.javaee.EJBFacet;
import org.jboss.forge.spec.javaee.ejb.api.EJBType;
import org.jboss.forge.spec.javaee.ejb.api.JMSDestinationType;

@Alias(value="ejb")
@RequiresProject
@RequiresFacet(value={EJBFacet.class})
public class EJBPlugin
implements Plugin {
    @Inject
    private Project project;
    @Inject
    @Current
    private Resource<?> resource;
    @Inject
    private Shell shell;
    @Inject
    private Event<InstallFacets> request;

    @SetupCommand
    public void setup(PipeOut out) {
        if (!this.project.hasFacet(EJBFacet.class)) {
            this.request.fire((Object)new InstallFacets(EJBFacet.class));
        }
        if (this.project.hasFacet(EJBFacet.class)) {
            ShellMessages.success((ShellPrintWriter)out, (String)"Enterprise Java Beans (EJB) is installed.");
        }
    }

    @Command(value="new-ejb")
    public void newEjb(@Option(required=false, help="the package in which to build this class", description="source package", type=PromptType.JAVA_PACKAGE, name="package") String packageName, @Option(required=true, name="named", help="the class name of EJB") String name, @Option(required=false, name="type", defaultValue="STATELESS") EJBType type, @Option(required=false, name="serializable", defaultValue="false") boolean serializable) throws FileNotFoundException {
        JavaClass ejb;
        JavaResource resource;
        JavaSourceFacet javaSourceFacet = (JavaSourceFacet)this.project.getFacet(JavaSourceFacet.class);
        String ejbPackage = packageName != null && !"".equals(packageName) ? packageName : (this.getPackagePortionOfCurrentDirectory() != null ? this.getPackagePortionOfCurrentDirectory() : this.shell.promptCommon("In which package you'd like to create this EJB class, or enter for default", PromptType.JAVA_PACKAGE, javaSourceFacet.getBasePackage()));
        JavaClass javaClass = (JavaClass)((JavaClass)((JavaClass)JavaParser.create(JavaClass.class)).setName(name)).setPackage(ejbPackage);
        if (serializable) {
            javaClass.addInterface(Serializable.class);
        }
        if (!(resource = javaSourceFacet.getJavaResource((JavaSource)javaClass)).exists()) {
            resource.createNewFile();
            ejb = javaClass;
        } else if (this.shell.promptBoolean("The EJB class already exists, do you want to overwrite it?")) {
            ejb = this.getJavaClassFrom((Resource<?>)resource);
        } else {
            throw new RuntimeException("The EJB class already exists [" + resource.getFullyQualifiedName() + "] ");
        }
        if (type == null) {
            type = EJBType.STATELESS;
        }
        if (EJBType.MESSAGEDRIVEN != type) {
            ejb.addAnnotation(type.getAnnotation());
            ejb.addAnnotation("javax.ejb.LocalBean");
        } else {
            String destinationType = this.shell.promptCommon("Destination type: javax.jms.Queue or javax.jms.Topic:", PromptType.JAVA_CLASS, JMSDestinationType.QUEUE.getDestinationType());
            String destinationName = this.shell.promptCommon("Destination Name:", PromptType.ANY, "queue/test");
            ejb.addImport(ActivationConfigProperty.class);
            ejb.addImport(Message.class);
            ejb.addInterface(MessageListener.class);
            ejb.addMethod("public void onMessage(Message message) {}");
            ejb.addAnnotation(EJBType.MESSAGEDRIVEN.getAnnotation()).setLiteralValue("name", "\"" + name + "\"").setLiteralValue("activationConfig", "{@ActivationConfigProperty(propertyName = \"destinationType\", propertyValue = \"" + destinationType + "\"), " + "@ActivationConfigProperty(propertyName = \"destination\", propertyValue = \"" + destinationName + "\")" + "}");
        }
        javaSourceFacet.saveJavaSource((JavaSource)ejb);
        this.shell.setCurrentResource((Resource)resource);
    }

    @Command(value="add-transaction-attribute")
    @RequiresResource(value={JavaResource.class, JavaMethodResource.class})
    public void addTransactionAttribute(@Option(required=true, name="type") TransactionAttributeType transactionAttributeType, PipeOut out) throws FileNotFoundException {
        JavaClass ejb;
        if (this.resource instanceof JavaResource) {
            ejb = this.getJavaClassFrom(this.resource);
            Annotation annotation = ejb.hasAnnotation(TransactionAttribute.class) ? ejb.getAnnotation(TransactionAttribute.class) : ejb.addAnnotation(TransactionAttribute.class);
            annotation.setEnumValue(new Enum[]{transactionAttributeType});
        } else if (this.resource instanceof JavaMethodResource) {
            Method m = ((JavaMethodResource)this.resource).getUnderlyingResourceObject();
            Annotation annotation = m.hasAnnotation(TransactionAttribute.class) ? m.getAnnotation(TransactionAttribute.class) : m.addAnnotation(TransactionAttribute.class);
            annotation.setEnumValue(new Enum[]{transactionAttributeType});
            ejb = (JavaSource)m.getOrigin();
        } else {
            throw new RuntimeException("Impossibile to add transactionAttribute to " + this.resource.getName());
        }
        JavaSourceFacet javaSourceFacet = (JavaSourceFacet)this.project.getFacet(JavaSourceFacet.class);
        javaSourceFacet.saveJavaSource((JavaSource)ejb);
    }

    private JavaClass getJavaClassFrom(Resource<?> resource) throws FileNotFoundException {
        JavaSource source = ((JavaResource)resource).getJavaSource();
        if (!source.isClass()) {
            throw new IllegalStateException("Current resource is not a JavaClass!");
        }
        return (JavaClass)source;
    }

    private String getPackagePortionOfCurrentDirectory() {
        for (DirectoryResource r : ((JavaSourceFacet)this.project.getFacet(JavaSourceFacet.class)).getSourceFolders()) {
            DirectoryResource currentDirectory;
            if (!ResourceUtil.isChildOf((Resource)r, (Resource)(currentDirectory = this.shell.getCurrentDirectory()))) continue;
            return currentDirectory.getFullyQualifiedName().replace(r.getFullyQualifiedName() + "/", "").replaceAll("/", ".");
        }
        return null;
    }
}

