/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.spec.javaee.jpa;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.jboss.forge.parser.java.Field;
import org.jboss.forge.parser.java.JavaClass;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.parser.java.Type;
import org.jboss.forge.parser.java.util.Refactory;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.facets.JavaSourceFacet;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.resources.java.JavaResource;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.ShellMessages;
import org.jboss.forge.shell.ShellPrintWriter;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.Command;
import org.jboss.forge.shell.plugins.Current;
import org.jboss.forge.shell.plugins.Help;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.RequiresFacet;
import org.jboss.forge.shell.plugins.RequiresProject;
import org.jboss.forge.spec.javaee.PersistenceFacet;

@Alias(value="update-entity")
@RequiresProject
@RequiresFacet(value={PersistenceFacet.class})
@Help(value="A plugin to aid in refactoring of JPA @Entity classes.")
public class UpdateEntityPlugin
implements Plugin {
    @Inject
    @Current
    private Resource<?> currentResource;
    @Inject
    private Project project;
    @Inject
    private ShellPrintWriter writer;
    @Inject
    private Shell shell;

    @Command(value="hashcode-and-equals", help="Create or updates the hashCode() and equals() methods for JPA @Entities")
    public void createOrUpdateHashCodeAndEquals(@Option(required=false, description="The JPA @Entity classes") JavaResource[] resources) throws Throwable {
        List<JavaResource> entities;
        if ((resources == null || resources.length < 1) && this.currentResource instanceof JavaResource) {
            resources = new JavaResource[]{(JavaResource)this.currentResource};
        }
        if ((entities = this.selectEntities((Resource<?>[])resources)).isEmpty()) {
            ShellMessages.error((ShellPrintWriter)this.writer, (String)"Must specify atleast one @Entity class on which to operate.");
            return;
        }
        JavaSourceFacet java = (JavaSourceFacet)this.project.getFacet(JavaSourceFacet.class);
        for (JavaResource resource : resources) {
            JavaClass entity = (JavaClass)resource.getJavaSource();
            HashSet<Field<?>> selectedFields = new HashSet();
            Map<String, Field<?>> candidateFields = this.getCandidateFields(entity);
            selectedFields = this.shell.promptMultiSelectWithWildcard("*", "Choose the fields to use in the equals and hashCode methods. Use * to select all.", candidateFields);
            this.warnIncorrectFields(entity, selectedFields);
            this.overwriteMethods(entity);
            Refactory.createHashCodeAndEquals((JavaClass)entity, (Field[])selectedFields.toArray(new Field[selectedFields.size()]));
            java.saveJavaSource((JavaSource)entity);
            this.shell.println("Added equals() and hashCode() in [" + entity.getQualifiedName() + "].");
        }
    }

    private void overwriteMethods(JavaClass entity) {
        if (entity.hasMethodSignature("equals", new Class[]{Object.class})) {
            entity.removeMethod(entity.getMethod("equals", new Class[]{Object.class}));
        }
        if (entity.hasMethodSignature("hashCode")) {
            entity.removeMethod(entity.getMethod("hashCode"));
        }
    }

    private Map<String, Field<?>> getCandidateFields(JavaClass entity) {
        HashMap candidateFields = new HashMap();
        for (Field field : entity.getFields()) {
            if (field.isStatic()) continue;
            candidateFields.put(field.getName(), field);
        }
        return candidateFields;
    }

    private List<JavaResource> selectEntities(Resource<?>[] targets) throws FileNotFoundException {
        ArrayList<JavaResource> results = new ArrayList<JavaResource>();
        for (Resource<?> r : targets) {
            if (!(r instanceof JavaResource)) continue;
            JavaSource entity = ((JavaResource)r).getJavaSource();
            if (entity instanceof JavaClass) {
                if (entity.hasAnnotation(Entity.class)) {
                    results.add((JavaResource)r);
                    continue;
                }
                this.displaySkippingResourceMsg(entity);
                continue;
            }
            this.displaySkippingResourceMsg(entity);
        }
        return results;
    }

    private void warnIncorrectFields(JavaClass entity, Set<Field<?>> selectedFields) {
        for (Field<?> field : selectedFields) {
            Type typeInspector = field.getTypeInspector();
            String fieldType = typeInspector.getQualifiedName();
            if (field.isTransient() || field.hasAnnotation(Transient.class)) {
                this.displayTransientFieldWarningMsg(entity, field);
            }
            if (fieldType.equals("java.util.Collection") || fieldType.equals("java.util.List") || fieldType.equals("java.util.Set") || fieldType.equals("java.util.Map")) {
                this.displayCollectionFieldWarningMsg(entity, field);
            }
            if (field.hasAnnotation(GeneratedValue.class)) {
                this.displayGeneratedValueFieldWarningMsg(entity, field);
            }
            if (!field.hasAnnotation(Version.class)) continue;
            this.displayVersionFieldWarningMsg(entity, field);
        }
    }

    private void displayGeneratedValueFieldWarningMsg(JavaClass klass, Field<?> field) {
        ShellMessages.warn((ShellPrintWriter)this.writer, (String)("A field [" + field.getName() + "] having the @GeneratedValue annotation was chosen. The generated equals() and hashCode() methods for the class [" + klass.getName() + "] may be incorrect."));
    }

    private void displayVersionFieldWarningMsg(JavaClass klass, Field<?> field) {
        ShellMessages.warn((ShellPrintWriter)this.writer, (String)("A field [" + field.getName() + "] having the @Version annotation was chosen. The generated equals() and hashCode() methods for the class [" + klass.getName() + "] may be incorrect."));
    }

    private void displayCollectionFieldWarningMsg(JavaClass klass, Field<?> field) {
        ShellMessages.warn((ShellPrintWriter)this.writer, (String)("A collection field [" + field.getName() + "] was chosen. The generated equals() and hashCode() methods for the class [" + klass.getName() + "] may be incorrect."));
    }

    private void displayTransientFieldWarningMsg(JavaClass klass, Field<?> field) {
        ShellMessages.warn((ShellPrintWriter)this.writer, (String)("A transient field [" + field.getName() + "] was chosen. The generated equals() and hashCode() methods for the class [" + klass.getName() + "] may be incorrect."));
    }

    private void displaySkippingResourceMsg(JavaSource<?> entity) {
        ShellMessages.info((ShellPrintWriter)this.writer, (String)("Skipped non-@Entity Java resource [" + entity.getQualifiedName() + "]"));
    }
}

