/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.spec.javaee.rest;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import org.jboss.forge.env.Configuration;
import org.jboss.forge.parser.java.Annotation;
import org.jboss.forge.parser.java.Field;
import org.jboss.forge.parser.java.JavaClass;
import org.jboss.forge.parser.java.Member;
import org.jboss.forge.parser.java.Method;
import org.jboss.forge.parser.java.util.Strings;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.facets.JavaSourceFacet;
import org.jboss.forge.resources.java.JavaResourceVisitor;
import org.jboss.forge.shell.ShellMessages;
import org.jboss.forge.shell.ShellPrintWriter;
import org.jboss.forge.shell.ShellPrompt;
import org.jboss.forge.spec.javaee.PersistenceFacet;
import org.jboss.forge.spec.javaee.RestApplicationFacet;
import org.jboss.forge.spec.javaee.rest.RestResourceTypeVisitor;
import org.jboss.shrinkwrap.descriptor.api.spec.jpa.persistence.PersistenceDescriptor;
import org.jboss.shrinkwrap.descriptor.api.spec.jpa.persistence.PersistenceUnitDef;

public class ResourceGeneratorUtil {
    @Inject
    private Project project;
    @Inject
    private Configuration configuration;
    @Inject
    private JavaSourceFacet java;
    @Inject
    private RestResourceTypeVisitor resourceTypeVisitor;
    @Inject
    private ShellPrompt prompt;
    @Inject
    private ShellPrintWriter writer;

    public String getPackageName() {
        if (this.project.hasFacet(RestApplicationFacet.class)) {
            return this.configuration.getString("rest.applicationclass.package");
        }
        return this.java.getBasePackage() + ".rest";
    }

    public String getResourcePath(String entityTable) {
        String proposedQualifiedClassName = this.getPackageName() + "." + entityTable + "Endpoint";
        String proposedResourcePath = "/" + entityTable.toLowerCase() + "s";
        this.resourceTypeVisitor.setFound(false);
        this.resourceTypeVisitor.setProposedPath(proposedResourcePath);
        while (true) {
            this.java.visitJavaSources((JavaResourceVisitor)this.resourceTypeVisitor);
            if (!this.resourceTypeVisitor.isFound() || proposedQualifiedClassName.equals(this.resourceTypeVisitor.getQualifiedClassNameForMatch())) break;
            ShellMessages.warn((ShellPrintWriter)this.writer, (String)("The @Path " + proposedResourcePath + " conflicts with an existing @Path."));
            String computedPath = proposedResourcePath.startsWith("/") ? "forge" + proposedResourcePath : "forge/" + proposedResourcePath;
            proposedResourcePath = this.prompt.prompt("Provide a different URI path value for the generated resource.", computedPath);
            this.resourceTypeVisitor.setProposedPath(proposedResourcePath);
            this.resourceTypeVisitor.setFound(false);
        }
        return proposedResourcePath;
    }

    public String getPersistenceUnitName() {
        PersistenceFacet persistence = (PersistenceFacet)this.project.getFacet(PersistenceFacet.class);
        PersistenceDescriptor persistenceDescriptor = persistence.getConfig();
        List units = persistenceDescriptor.listUnits();
        if (units.size() == 1) {
            return ((PersistenceUnitDef)units.get(0)).getName();
        }
        ArrayList<String> unitNames = new ArrayList<String>();
        for (PersistenceUnitDef unitDef : units) {
            unitNames.add(unitDef.getName());
        }
        String chosenUnit = (String)this.prompt.promptChoiceTyped("Multiple persistence units were detected. Which persistence unit do you want to inject in the REST resources?", unitNames, unitNames.get(0));
        return chosenUnit;
    }

    public static String resolveIdGetterName(JavaClass entity) {
        String result = null;
        for (Member member : entity.getMembers()) {
            if (!member.hasAnnotation(Id.class)) continue;
            String name = member.getName();
            String type = null;
            if (member instanceof Method) {
                type = ((Method)member).getReturnType();
                if (name.startsWith("get")) {
                    name = name.substring(2);
                }
            } else if (member instanceof Field) {
                type = ((Field)member).getType();
            }
            if (type != null) {
                for (Method method : entity.getMethods()) {
                    if (method.getParameters().size() != 0 || !type.equals(method.getReturnType()) || !method.getName().toLowerCase().contains(name.toLowerCase())) continue;
                    result = method.getName() + "()";
                    break;
                }
            }
            if (result != null) break;
            if (type == null || !member.isPublic()) continue;
            String memberName = member.getName();
            if (member instanceof Method && memberName.startsWith("get")) {
                memberName = memberName.substring(3);
                memberName = Strings.uncapitalize((String)memberName);
            }
            result = memberName;
        }
        if (result == null) {
            throw new RuntimeException("Could not determine @Id field and getter method for @Entity [" + entity.getQualifiedName() + "]. Aborting.");
        }
        return result;
    }

    public static String getEntityTable(JavaClass entity) {
        String table = entity.getName();
        if (entity.hasAnnotation(Entity.class)) {
            Annotation a = entity.getAnnotation(Entity.class);
            if (!Strings.isNullOrEmpty((String)a.getStringValue("name"))) {
                table = a.getStringValue("name");
            } else if (!Strings.isNullOrEmpty((String)a.getStringValue())) {
                table = a.getStringValue();
            }
        }
        return table;
    }

    public static String getSelectExpression(JavaClass entity, String entityTable) {
        char entityVariable = ResourceGeneratorUtil.getJpqlEntityVariable(entityTable);
        StringBuilder expressionBuilder = new StringBuilder();
        expressionBuilder.append("SELECT DISTINCT ");
        expressionBuilder.append(entityVariable);
        expressionBuilder.append(" FROM ");
        expressionBuilder.append(entityTable);
        expressionBuilder.append(" ");
        expressionBuilder.append(entityVariable);
        for (Member member : entity.getMembers()) {
            if (!member.hasAnnotation(OneToOne.class) && !member.hasAnnotation(OneToMany.class) && !member.hasAnnotation(ManyToMany.class) && !member.hasAnnotation(ManyToOne.class)) continue;
            String name = member.getName();
            String associationField = null;
            if (member instanceof Method) {
                if (name.startsWith("get")) {
                    associationField = Strings.uncapitalize((String)name.substring(2));
                }
            } else if (member instanceof Field) {
                associationField = name;
            }
            if (associationField == null) {
                throw new RuntimeException("Could not compute the association field for member:" + member.getName() + " in entity" + entity.getName());
            }
            expressionBuilder.append(" LEFT JOIN FETCH ");
            expressionBuilder.append(entityVariable);
            expressionBuilder.append('.');
            expressionBuilder.append(associationField);
        }
        return expressionBuilder.toString();
    }

    public static String getIdClause(JavaClass entity, String entityTable) {
        for (Member member : entity.getMembers()) {
            if (!member.hasAnnotation(Id.class)) continue;
            String memberName = member.getName();
            String id = null;
            if (member instanceof Method) {
                id = Strings.uncapitalize((String)memberName.substring(2));
            }
            if (member instanceof Field) {
                id = memberName;
            }
            char entityVariable = ResourceGeneratorUtil.getJpqlEntityVariable(entityTable);
            return "WHERE " + entityVariable + "." + id + " = " + ":entityId";
        }
        return null;
    }

    public static String getOrderClause(JavaClass entity, char entityVariable) {
        StringBuilder expressionBuilder = new StringBuilder();
        for (Member member : entity.getMembers()) {
            if (!member.hasAnnotation(Id.class)) continue;
            String memberName = member.getName();
            String id = null;
            if (member instanceof Method) {
                id = Strings.uncapitalize((String)memberName.substring(2));
            }
            if (member instanceof Field) {
                id = memberName;
            }
            expressionBuilder.append("ORDER BY ");
            expressionBuilder.append(entityVariable);
            expressionBuilder.append('.');
            expressionBuilder.append(id);
        }
        return expressionBuilder.toString();
    }

    public static char getJpqlEntityVariable(String entityTable) {
        return entityTable.toLowerCase().charAt(0);
    }
}

