/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.spec.javaee.servlet;

import java.util.List;
import javax.inject.Inject;
import org.jboss.forge.project.Project;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.DefaultCommand;
import org.jboss.forge.shell.plugins.Help;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.RequiresFacet;
import org.jboss.forge.shell.plugins.RequiresProject;
import org.jboss.forge.shell.plugins.Topic;
import org.jboss.forge.spec.javaee.ServletFacet;

@Alias(value="list-web-resources")
@Topic(value="File & Resources")
@RequiresProject
@RequiresFacet(value={ServletFacet.class})
@Help(value="Lists all project Web Resources")
public class ListWebResourcesPlugin
implements Plugin {
    private final Project project;
    private final Shell shell;

    @Inject
    public ListWebResourcesPlugin(Project project, Shell shell) {
        this.project = project;
        this.shell = shell;
    }

    @DefaultCommand
    public void list(@Option(required=false) String filter) {
        ServletFacet web = (ServletFacet)this.project.getFacet(ServletFacet.class);
        List resources = web.getResources();
        for (Resource file : resources) {
            this.shell.println(file.getFullyQualifiedName());
        }
    }
}

