/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.spec.javaee.servlet;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.jboss.forge.project.dependencies.Dependency;
import org.jboss.forge.project.dependencies.DependencyBuilder;
import org.jboss.forge.project.dependencies.DependencyInstaller;
import org.jboss.forge.project.dependencies.ScopeType;
import org.jboss.forge.project.facets.DependencyFacet;
import org.jboss.forge.project.facets.MetadataFacet;
import org.jboss.forge.project.facets.WebResourceFacet;
import org.jboss.forge.project.packaging.PackagingType;
import org.jboss.forge.resources.DirectoryResource;
import org.jboss.forge.resources.FileResource;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.resources.ResourceFilter;
import org.jboss.forge.resources.UnknownFileResource;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.RequiresFacet;
import org.jboss.forge.shell.plugins.RequiresPackagingType;
import org.jboss.forge.shell.util.Streams;
import org.jboss.forge.spec.javaee.BaseJavaEEFacet;
import org.jboss.forge.spec.javaee.ServletFacet;
import org.jboss.shrinkwrap.descriptor.api.DescriptorImporter;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.spec.servlet.web.WebAppDescriptor;

@Alias(value="forge.spec.servlet")
@RequiresFacet(value={MetadataFacet.class, WebResourceFacet.class, DependencyFacet.class})
@RequiresPackagingType(value={PackagingType.WAR, PackagingType.BUNDLE})
public class ServletFacetImpl
extends BaseJavaEEFacet
implements ServletFacet {
    @Inject
    public ServletFacetImpl(DependencyInstaller installer) {
        super(installer);
    }

    @Override
    protected List<Dependency> getRequiredDependencies() {
        return Arrays.asList(DependencyBuilder.create((String)"org.jboss.spec.javax.servlet:jboss-servlet-api_3.0_spec").setScopeType(ScopeType.PROVIDED));
    }

    @Override
    public boolean isInstalled() {
        DirectoryResource webRoot = ((WebResourceFacet)this.project.getFacet(WebResourceFacet.class)).getWebRootDirectory();
        return super.isInstalled() && webRoot.exists();
    }

    @Override
    public boolean install() {
        DirectoryResource webRoot;
        if (!this.isInstalled() && !(webRoot = ((WebResourceFacet)this.project.getFacet(WebResourceFacet.class)).getWebRootDirectory()).exists()) {
            webRoot.mkdirs();
        }
        return super.install();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebAppDescriptor getConfig() {
        DescriptorImporter importer = Descriptors.importAs(WebAppDescriptor.class);
        FileResource<?> configFile = this.getConfigFile();
        InputStream inputStream = configFile.getResourceInputStream();
        try {
            WebAppDescriptor descriptor;
            WebAppDescriptor webAppDescriptor = descriptor = (WebAppDescriptor)importer.from(inputStream);
            return webAppDescriptor;
        }
        finally {
            Streams.closeQuietly((Closeable)inputStream);
        }
    }

    public void saveConfig(WebAppDescriptor descriptor) {
        String output = descriptor.exportAsString();
        FileResource<?> configFile = this.getConfigFile();
        configFile.setContents(output);
    }

    public FileResource<?> getConfigFile() {
        DirectoryResource webRoot = ((WebResourceFacet)this.project.getFacet(WebResourceFacet.class)).getWebRootDirectory();
        FileResource child = (FileResource)webRoot.getChild("WEB-INF" + File.separator + "web.xml");
        if (!child.exists()) {
            return new UnknownFileResource(child.getResourceFactory(), child.getUnderlyingResourceObject()){

                public InputStream getResourceInputStream() {
                    if (!this.exists()) {
                        String projectName = ((MetadataFacet)ServletFacetImpl.this.project.getFacet(MetadataFacet.class)).getProjectName();
                        WebAppDescriptor unit = ((WebAppDescriptor)Descriptors.create(WebAppDescriptor.class)).displayName(projectName).sessionTimeout(30);
                        return Streams.fromString((String)unit.exportAsString());
                    }
                    return super.getResourceInputStream();
                }

                public UnknownFileResource setContents(InputStream data) {
                    if (!this.exists()) {
                        this.createNewFile();
                    }
                    return (UnknownFileResource)super.setContents(data);
                }

                public UnknownFileResource setContents(char[] data) {
                    if (!this.exists()) {
                        this.createNewFile();
                    }
                    return (UnknownFileResource)super.setContents(data);
                }

                public UnknownFileResource setContents(String data) {
                    if (!this.exists()) {
                        this.createNewFile();
                    }
                    return (UnknownFileResource)super.setContents(data);
                }
            };
        }
        return child;
    }

    public List<Resource<?>> getResources() {
        DirectoryResource webRoot = ((WebResourceFacet)this.project.getFacet(WebResourceFacet.class)).getWebRootDirectory();
        return this.listChildrenRecursively(webRoot);
    }

    private List<Resource<?>> listChildrenRecursively(DirectoryResource webRoot) {
        return this.listChildrenRecursively(webRoot, new ResourceFilter(){

            public boolean accept(Resource<?> resource) {
                return true;
            }
        });
    }

    public List<Resource<?>> getResources(ResourceFilter filter) {
        DirectoryResource webRoot = ((WebResourceFacet)this.project.getFacet(WebResourceFacet.class)).getWebRootDirectory();
        return this.listChildrenRecursively(webRoot, filter);
    }

    private List<Resource<?>> listChildrenRecursively(DirectoryResource current, ResourceFilter filter) {
        ArrayList result = new ArrayList();
        List list = current.listResources();
        if (list != null) {
            for (Resource file : list) {
                if (file instanceof DirectoryResource) {
                    result.addAll(this.listChildrenRecursively((DirectoryResource)file, filter));
                }
                if (!filter.accept(file)) continue;
                result.add(file);
            }
        }
        return result;
    }
}

