/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.spec.javaee.util;

import java.beans.Introspector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.forge.parser.java.Field;
import org.jboss.forge.parser.java.JavaClass;
import org.jboss.forge.parser.java.Member;
import org.jboss.forge.parser.java.Method;
import org.jboss.forge.spec.javaee.util.JPAProperty;

public class JPABean {
    private static final String GET_PREFIX = "get";
    private static final String SET_PREFIX = "set";
    private static final String IS_PREFIX = "is";
    private JavaClass entity;
    private List<Member<JavaClass, ?>> members;
    private Map<String, JPAProperty> propertyCache = new HashMap<String, JPAProperty>();

    public JPABean(JavaClass entity) {
        this.entity = entity;
        this.members = this.entity.getMembers();
        this.locateProperties();
    }

    public List<JPAProperty> getProperties() {
        return new ArrayList<JPAProperty>(this.propertyCache.values());
    }

    private void locateProperties() {
        for (Member<JavaClass, ?> member : this.getEligibleMembers()) {
            String propertyName;
            String memberName = member.getName();
            if (member instanceof Field) {
                Field field = (Field)member;
                this.createOrUpdateProperty(memberName, field, null, null);
                continue;
            }
            if (!(member instanceof Method)) continue;
            Method method = (Method)member;
            if (this.isAccessor((Method<JavaClass>)method)) {
                propertyName = this.propertyNameFromMethod((Method<JavaClass>)method);
                this.createOrUpdateProperty(propertyName, null, (Method<JavaClass>)method, null);
                continue;
            }
            if (!this.isMutator((Method<JavaClass>)method)) continue;
            propertyName = this.propertyNameFromMethod((Method<JavaClass>)method);
            this.createOrUpdateProperty(propertyName, null, null, (Method<JavaClass>)method);
        }
    }

    private List<Member<JavaClass, ?>> getEligibleMembers() {
        ArrayList result = new ArrayList();
        for (Member<JavaClass, ?> member : this.members) {
            if (member.isStatic()) continue;
            result.add(member);
        }
        return result;
    }

    private String propertyNameFromMethod(Method<JavaClass> method) {
        String methodName = method.getName();
        String qualifiedReturnType = method.getQualifiedReturnType();
        if (methodName.startsWith(GET_PREFIX)) {
            return Introspector.decapitalize(methodName.substring(3));
        }
        if (methodName.startsWith(IS_PREFIX) && (qualifiedReturnType.equals("boolean") || qualifiedReturnType.equals("java.lang.Boolean"))) {
            return Introspector.decapitalize(methodName.substring(2));
        }
        if (methodName.startsWith(SET_PREFIX)) {
            return Introspector.decapitalize(methodName.substring(3));
        }
        return null;
    }

    private JPAProperty createOrUpdateProperty(String name, Field<?> field, Method<JavaClass> accessor, Method<JavaClass> mutator) {
        JPAProperty property = this.propertyCache.get(name);
        if (property == null) {
            property = new JPAProperty(name);
            this.propertyCache.put(name, property);
        }
        if (field != null) {
            property.setActualField(field);
        }
        if (accessor != null) {
            property.setAccessor(accessor);
        }
        if (mutator != null) {
            property.setMutator(mutator);
        }
        return property;
    }

    private boolean isAccessor(Method<JavaClass> method) {
        String methodName = method.getName();
        String qualifiedReturnType = method.getQualifiedReturnType();
        List parameters = method.getParameters();
        if (!method.isStatic() && methodName.startsWith(GET_PREFIX) && qualifiedReturnType != null && parameters.size() == 0) {
            return true;
        }
        return methodName.startsWith(IS_PREFIX) && (qualifiedReturnType.equals("boolean") || qualifiedReturnType.equals("java.lang.Boolean")) && parameters.size() == 0;
    }

    private boolean isMutator(Method<JavaClass> method) {
        String methodName = method.getName();
        String qualifiedReturnType = method.getQualifiedReturnType();
        List parameters = method.getParameters();
        return !method.isStatic() && methodName.startsWith(SET_PREFIX) && qualifiedReturnType == null && parameters.size() == 1;
    }
}

