/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.spec.javaee.util;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import org.jboss.forge.parser.java.Field;
import org.jboss.forge.parser.java.JavaClass;
import org.jboss.forge.parser.java.Method;
import org.jboss.forge.parser.java.Type;

public class JPAProperty {
    private final String name;
    private Field<?> actualField;
    private Method<JavaClass> accessor;
    private Method<JavaClass> mutator;

    public JPAProperty(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Field<?> getActualField() {
        return this.actualField;
    }

    void setActualField(Field<?> actualField) {
        this.actualField = actualField;
    }

    public Method<JavaClass> getAccessor() {
        return this.accessor;
    }

    void setAccessor(Method<JavaClass> accessor) {
        this.accessor = accessor;
    }

    public Method<JavaClass> getMutator() {
        return this.mutator;
    }

    void setMutator(Method<JavaClass> mutator) {
        this.mutator = mutator;
    }

    public boolean isReadable() {
        return this.accessor != null;
    }

    public boolean isWritable() {
        return this.mutator != null;
    }

    public boolean isReadOnly() {
        if (this.isReadable()) {
            return !this.isWritable();
        }
        return false;
    }

    public boolean hasAnnotation(Class<? extends Annotation> klass) {
        return this.actualField != null && this.actualField.hasAnnotation(klass) || this.accessor != null && this.accessor.hasAnnotation(klass);
    }

    public boolean hasAnnotation(Class<? extends Annotation> klass, ElementType type) {
        if (ElementType.FIELD.equals((Object)type)) {
            return this.actualField != null && this.actualField.hasAnnotation(klass);
        }
        if (ElementType.METHOD.equals((Object)type)) {
            return this.accessor != null && this.accessor.hasAnnotation(klass);
        }
        throw new IllegalArgumentException("Invalid ElementType enum value was provided.");
    }

    public boolean isTransient() {
        return this.actualField != null && this.actualField.isTransient();
    }

    public Type<?> getType() {
        if (this.actualField != null) {
            return this.actualField.getTypeInspector();
        }
        if (this.accessor != null) {
            return this.accessor.getReturnTypeInspector();
        }
        throw new IllegalStateException("The property " + this.name + " is not associated with a field or an accessor");
    }

    public String getSimpleType() {
        if (this.actualField != null) {
            return this.actualField.getType();
        }
        if (this.accessor != null) {
            return this.accessor.getReturnType();
        }
        throw new IllegalStateException("The property " + this.name + " is not associated with a field or an accessor");
    }

    public String getQualifiedType() {
        if (this.actualField != null) {
            return this.actualField.getQualifiedType();
        }
        if (this.accessor != null) {
            return this.accessor.getQualifiedReturnType();
        }
        throw new IllegalStateException("The property " + this.name + " is not associated with a field or an accessor");
    }

    public boolean isPrimitive() {
        return this.actualField != null && this.actualField.isPrimitive() || this.accessor != null && this.accessor.getReturnTypeInspector().isPrimitive();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JPAProperty)) {
            return false;
        }
        JPAProperty other = (JPAProperty)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

