/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.parser.xml.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.forge.parser.xml.Node;
import org.jboss.forge.parser.xml.query.Pattern;
import org.jboss.forge.parser.xml.query.Query;
import org.jboss.forge.parser.xml.util.QueryUtil;

public enum GetQuery implements Query<List<Node>>
{
    INSTANCE;


    @Override
    public List<Node> execute(Node node, Pattern ... patterns) {
        QueryUtil.validateNodeAndPatterns(node, patterns);
        List<Pattern> patternList = Arrays.asList(patterns);
        return this.findMatch(node, patternList);
    }

    private List<Node> findMatch(Node start, List<Pattern> patterns) {
        ArrayList<Node> matchedNodes = new ArrayList<Node>();
        Pattern pattern = patterns.get(0);
        if (pattern == null) {
            return matchedNodes;
        }
        boolean foundMatch = false;
        if (pattern.matches(start)) {
            foundMatch = true;
            if (patterns.size() == 1) {
                matchedNodes.add(start);
                return matchedNodes;
            }
        }
        for (Node child : start.getChildren()) {
            List<Pattern> sub = patterns.subList(foundMatch ? 1 : 0, patterns.size());
            matchedNodes.addAll(this.findMatch(child, sub));
        }
        return matchedNodes;
    }
}

