/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.parser.xml.query;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.forge.parser.xml.Node;

public final class Pattern {
    private final Map<String, String> attributes = new HashMap<String, String>();
    private final String name;
    private String text;

    public Pattern(String name) throws IllegalArgumentException {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("name must be specified");
        }
        this.name = name;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [attributes=" + this.attributes + ", name=" + this.name + ", text=" + this.text + "]";
    }

    public String getName() {
        return this.name;
    }

    public Pattern attribute(String name, Object value) {
        return this.attribute(name, String.valueOf(value));
    }

    public Pattern attribute(String name, String value) {
        this.attributes.put(name, value);
        return this;
    }

    public Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public String getAttribute(String name) throws IllegalArgumentException {
        return this.attributes.get(name);
    }

    public boolean matches(Node node) throws IllegalArgumentException {
        if (node == null) {
            throw new IllegalArgumentException("node must be specified");
        }
        if (!this.name.equals(node.getName())) {
            return false;
        }
        if (this.text != null && node.getText() == null || this.text != null && !this.text.trim().equals(node.getText().trim())) {
            return false;
        }
        if (this.attributes != null) {
            for (Map.Entry<String, String> attribute : this.attributes.entrySet()) {
                if (attribute.getValue().equals(node.getAttribute(attribute.getKey()))) continue;
                return false;
            }
        }
        return true;
    }

    public Pattern text(String text) {
        this.text = text;
        return this;
    }

    public String getText() {
        return this.text;
    }
}

