/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.maven.facets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Repository;
import org.jboss.forge.bus.EventBus;
import org.jboss.forge.maven.MavenCoreFacet;
import org.jboss.forge.maven.dependencies.MavenDependencyAdapter;
import org.jboss.forge.project.Facet;
import org.jboss.forge.project.dependencies.Dependency;
import org.jboss.forge.project.dependencies.DependencyBuilder;
import org.jboss.forge.project.dependencies.DependencyFilter;
import org.jboss.forge.project.dependencies.DependencyQuery;
import org.jboss.forge.project.dependencies.DependencyQueryBuilder;
import org.jboss.forge.project.dependencies.DependencyRepository;
import org.jboss.forge.project.dependencies.DependencyRepositoryImpl;
import org.jboss.forge.project.dependencies.DependencyResolver;
import org.jboss.forge.project.dependencies.NonSnapshotDependencyFilter;
import org.jboss.forge.project.dependencies.ScopeType;
import org.jboss.forge.project.dependencies.events.AddedDependencies;
import org.jboss.forge.project.dependencies.events.RemovedDependencies;
import org.jboss.forge.project.facets.BaseFacet;
import org.jboss.forge.project.facets.DependencyFacet;
import org.jboss.forge.project.facets.FacetNotFoundException;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.RequiresFacet;
import org.sonatype.aether.repository.RemoteRepository;

@Dependent
@Alias(value="forge.maven.MavenDependencyFacet")
@RequiresFacet(value={MavenCoreFacet.class})
public class MavenDependencyFacet
extends BaseFacet
implements DependencyFacet,
Facet {
    private final DependencyResolver resolver;
    private final EventBus bus;

    @Inject
    public MavenDependencyFacet(DependencyResolver resolver, EventBus bus) {
        this.resolver = resolver;
        this.bus = bus;
    }

    public boolean isInstalled() {
        try {
            this.project.getFacet(MavenCoreFacet.class);
            return true;
        }
        catch (FacetNotFoundException e) {
            return false;
        }
    }

    public boolean install() {
        return true;
    }

    public void addDirectDependency(Dependency dep) {
        this.removeDependency(dep);
        MavenCoreFacet maven = (MavenCoreFacet)this.project.getFacet(MavenCoreFacet.class);
        Model pom = maven.getPOM();
        List dependencies = MavenDependencyAdapter.fromMavenList((List)pom.getDependencies());
        dependencies.add(dep);
        pom.setDependencies(MavenDependencyAdapter.toMavenList((List)dependencies));
        maven.setPOM(pom);
        this.bus.enqueue((Object)new AddedDependencies(this.project, new Dependency[]{dep}));
    }

    public boolean hasDirectDependency(Dependency dependency) {
        MavenCoreFacet maven = (MavenCoreFacet)this.project.getFacet(MavenCoreFacet.class);
        Model pom = maven.getPOM();
        List dependencies = MavenDependencyAdapter.fromMavenList((List)pom.getDependencies());
        for (Dependency dep : dependencies) {
            if (!DependencyBuilder.areEquivalent((Dependency)this.resolveProperties(dependency), (Dependency)dep)) continue;
            return true;
        }
        return false;
    }

    public void removeDependency(Dependency dep) {
        MavenCoreFacet maven = (MavenCoreFacet)this.project.getFacet(MavenCoreFacet.class);
        Model pom = maven.getPOM();
        List dependencies = MavenDependencyAdapter.fromMavenList((List)pom.getDependencies());
        ArrayList<Dependency> toBeRemoved = new ArrayList<Dependency>();
        for (Dependency dependency : dependencies) {
            if (!DependencyBuilder.areEquivalent((Dependency)dependency, (Dependency)this.resolveProperties(dep))) continue;
            toBeRemoved.add(dependency);
        }
        dependencies.removeAll(toBeRemoved);
        pom.setDependencies(MavenDependencyAdapter.toMavenList((List)dependencies));
        maven.setPOM(pom);
        this.bus.enqueue((Object)new RemovedDependencies(this.project, toBeRemoved));
    }

    public List<Dependency> getDependencies() {
        MavenCoreFacet maven = (MavenCoreFacet)this.project.getFacet(MavenCoreFacet.class);
        Model pom = maven.getPOM();
        List dependencies = MavenDependencyAdapter.fromMavenList((List)pom.getDependencies());
        ArrayList<Dependency> result = new ArrayList<Dependency>();
        for (Dependency dependency : dependencies) {
            result.add(this.resolveProperties(dependency));
        }
        return result;
    }

    public Dependency getDirectDependency(Dependency dependency) {
        MavenCoreFacet maven = (MavenCoreFacet)this.project.getFacet(MavenCoreFacet.class);
        Model pom = maven.getPOM();
        List dependencies = MavenDependencyAdapter.fromMavenList((List)pom.getDependencies());
        for (Dependency dep : dependencies) {
            if (!DependencyBuilder.areEquivalent((Dependency)this.resolveProperties(dependency), (Dependency)dep)) continue;
            return this.resolveProperties(dep);
        }
        return null;
    }

    public boolean hasEffectiveDependency(Dependency dependency) {
        return this.getEffectiveDependency(this.resolveProperties(dependency)) != null;
    }

    public Dependency getEffectiveDependency(Dependency manDep) {
        for (Dependency dependency : this.getEffectiveDependencies()) {
            if (!DependencyBuilder.areEquivalent((Dependency)dependency, (Dependency)this.resolveProperties(manDep))) continue;
            return this.resolveProperties(dependency);
        }
        return null;
    }

    public List<Dependency> getEffectiveDependencies() {
        MavenCoreFacet maven = (MavenCoreFacet)this.project.getFacet(MavenCoreFacet.class);
        List deps = MavenDependencyAdapter.fromAetherList((List)maven.getFullProjectBuildingResult().getDependencyResolutionResult().getDependencies());
        ArrayList<Dependency> result = new ArrayList<Dependency>();
        for (Dependency dependency : deps) {
            result.add(this.resolveProperties(dependency));
        }
        return result;
    }

    public void addManagedDependency(Dependency manDep) {
        if (!this.hasEffectiveManagedDependency(this.resolveProperties(manDep))) {
            MavenCoreFacet maven = (MavenCoreFacet)this.project.getFacet(MavenCoreFacet.class);
            Model pom = maven.getPOM();
            DependencyManagement depMan = pom.getDependencyManagement();
            depMan = depMan != null ? depMan : new DependencyManagement();
            List managedDependencies = MavenDependencyAdapter.fromMavenList((List)depMan.getDependencies());
            managedDependencies.add(manDep);
            depMan.setDependencies(MavenDependencyAdapter.toMavenList((List)managedDependencies));
            pom.setDependencyManagement(depMan);
            maven.setPOM(pom);
        }
    }

    public void addDirectManagedDependency(Dependency dep) {
        this.removeManagedDependency(dep);
        MavenCoreFacet maven = (MavenCoreFacet)this.project.getFacet(MavenCoreFacet.class);
        Model pom = maven.getPOM();
        DependencyManagement depMan = pom.getDependencyManagement();
        depMan = depMan != null ? depMan : new DependencyManagement();
        List managedDependencies = MavenDependencyAdapter.fromMavenList((List)depMan.getDependencies());
        managedDependencies.add(dep);
        depMan.setDependencies(MavenDependencyAdapter.toMavenList((List)managedDependencies));
        pom.setDependencyManagement(depMan);
        maven.setPOM(pom);
    }

    public boolean hasEffectiveManagedDependency(Dependency manDep) {
        return this.getEffectiveManagedDependency(this.resolveProperties(manDep)) != null;
    }

    public Dependency getEffectiveManagedDependency(Dependency manDep) {
        MavenCoreFacet maven = (MavenCoreFacet)this.project.getFacet(MavenCoreFacet.class);
        DependencyManagement depMan = maven.getFullProjectBuildingResult().getProject().getDependencyManagement();
        List managedDependencies = depMan != null ? MavenDependencyAdapter.fromMavenList((List)depMan.getDependencies()) : new ArrayList();
        for (Dependency managedDependency : managedDependencies) {
            if (!DependencyBuilder.areEquivalent((Dependency)managedDependency, (Dependency)this.resolveProperties(manDep))) continue;
            return this.resolveProperties(managedDependency);
        }
        return null;
    }

    public boolean hasDirectManagedDependency(Dependency managedDependency) {
        MavenCoreFacet maven = (MavenCoreFacet)this.project.getFacet(MavenCoreFacet.class);
        Model pom = maven.getPOM();
        DependencyManagement depMan = pom.getDependencyManagement();
        List managedDependencies = depMan != null ? MavenDependencyAdapter.fromMavenList((List)depMan.getDependencies()) : new ArrayList();
        for (Dependency manDep : managedDependencies) {
            if (!DependencyBuilder.areEquivalent((Dependency)this.resolveProperties(managedDependency), (Dependency)manDep)) continue;
            return true;
        }
        return false;
    }

    public void removeManagedDependency(Dependency manDep) {
        MavenCoreFacet maven = (MavenCoreFacet)this.project.getFacet(MavenCoreFacet.class);
        Model pom = maven.getPOM();
        DependencyManagement depMan = pom.getDependencyManagement();
        depMan = depMan != null ? depMan : new DependencyManagement();
        List managedDependencies = MavenDependencyAdapter.fromMavenList((List)depMan.getDependencies());
        ArrayList<Dependency> toBeRemoved = new ArrayList<Dependency>();
        for (Dependency managedDependency : managedDependencies) {
            if (!DependencyBuilder.areEquivalent((Dependency)managedDependency, (Dependency)manDep)) continue;
            toBeRemoved.add(managedDependency);
        }
        managedDependencies.removeAll(toBeRemoved);
        depMan.setDependencies(MavenDependencyAdapter.toMavenList((List)managedDependencies));
        pom.setDependencyManagement(depMan);
        maven.setPOM(pom);
    }

    public List<Dependency> getManagedDependencies() {
        MavenCoreFacet maven = (MavenCoreFacet)this.project.getFacet(MavenCoreFacet.class);
        Model pom = maven.getPOM();
        DependencyManagement depMan = pom.getDependencyManagement();
        ArrayList managedDependencies = null;
        managedDependencies = depMan != null ? MavenDependencyAdapter.fromMavenList((List)depMan.getDependencies()) : new ArrayList();
        ArrayList<Dependency> result = new ArrayList<Dependency>();
        for (Dependency dependency : managedDependencies) {
            result.add(this.resolveProperties(dependency));
        }
        return result;
    }

    public Dependency getManagedDependency(Dependency manDep) {
        MavenCoreFacet maven = (MavenCoreFacet)this.project.getFacet(MavenCoreFacet.class);
        Model pom = maven.getPOM();
        DependencyManagement depMan = pom.getDependencyManagement();
        List managedDependencies = depMan != null ? MavenDependencyAdapter.fromMavenList((List)depMan.getDependencies()) : new ArrayList();
        for (Dependency managedDependency : managedDependencies) {
            if (!DependencyBuilder.areEquivalent((Dependency)managedDependency, (Dependency)this.resolveProperties(manDep))) continue;
            return this.resolveProperties(managedDependency);
        }
        return null;
    }

    public Map<String, String> getProperties() {
        MavenCoreFacet maven = (MavenCoreFacet)this.project.getFacet(MavenCoreFacet.class);
        Model pom = maven.getPOM();
        Properties properties = pom.getProperties();
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<Object, Object> o : properties.entrySet()) {
            result.put((String)o.getKey(), (String)o.getValue());
        }
        return result;
    }

    public void setProperty(String name, String value) {
        MavenCoreFacet maven = (MavenCoreFacet)this.project.getFacet(MavenCoreFacet.class);
        Model pom = maven.getPOM();
        Properties properties = pom.getProperties();
        properties.put(name, value);
        maven.setPOM(pom);
    }

    public String getProperty(String name) {
        MavenCoreFacet maven = (MavenCoreFacet)this.project.getFacet(MavenCoreFacet.class);
        Model pom = maven.getPOM();
        Properties properties = pom.getProperties();
        maven.setPOM(pom);
        return (String)properties.get(name);
    }

    public Dependency resolveProperties(Dependency dependency) {
        MavenCoreFacet mvn = (MavenCoreFacet)this.project.getFacet(MavenCoreFacet.class);
        DependencyBuilder builder = DependencyBuilder.create((Dependency)dependency);
        builder.setGroupId(mvn.resolveProperties(dependency.getGroupId()));
        builder.setArtifactId(mvn.resolveProperties(dependency.getArtifactId()));
        builder.setVersion(mvn.resolveProperties(dependency.getVersion()));
        builder.setClassifier(mvn.resolveProperties(dependency.getClassifier()));
        builder.setPackagingType(mvn.resolveProperties(dependency.getPackagingType()));
        builder.setScopeType(mvn.resolveProperties(dependency.getScopeType()));
        return builder;
    }

    public String removeProperty(String name) {
        MavenCoreFacet maven = (MavenCoreFacet)this.project.getFacet(MavenCoreFacet.class);
        Model pom = maven.getPOM();
        Properties properties = pom.getProperties();
        String result = (String)properties.remove(name);
        maven.setPOM(pom);
        return result;
    }

    public List<Dependency> resolveAvailableVersions(String gavs) {
        return this.resolveAvailableVersions((Dependency)DependencyBuilder.create((String)gavs));
    }

    public List<Dependency> resolveAvailableVersions(Dependency dep) {
        DependencyQueryBuilder query = DependencyQueryBuilder.create((Dependency)dep).setRepositories(this.getRepositories());
        if (dep.getVersion() != null && !dep.getVersion().contains("SNAPSHOT")) {
            query.setFilter((DependencyFilter)new NonSnapshotDependencyFilter());
        }
        List versions = this.resolver.resolveVersions((DependencyQuery)query);
        return versions;
    }

    public List<Dependency> resolveAvailableVersions(DependencyQuery query) {
        List versions = this.resolver.resolveVersions(query);
        return versions;
    }

    public void addRepository(String name, String url) {
        if (!this.hasRepository(url)) {
            MavenCoreFacet maven = (MavenCoreFacet)this.project.getFacet(MavenCoreFacet.class);
            Model pom = maven.getPOM();
            Repository repo = new Repository();
            repo.setId(name);
            repo.setUrl(url);
            pom.getRepositories().add(repo);
            maven.setPOM(pom);
        }
    }

    public void addRepository(DependencyFacet.KnownRepository repository) {
        this.addRepository(repository.name(), repository.getUrl());
    }

    public List<DependencyRepository> getRepositories() {
        ArrayList<DependencyRepositoryImpl> results = new ArrayList<DependencyRepositoryImpl>();
        MavenCoreFacet maven = (MavenCoreFacet)this.project.getFacet(MavenCoreFacet.class);
        List remoteProjectRepositories = maven.getMavenProject().getRemoteProjectRepositories();
        for (RemoteRepository remoteRepository : remoteProjectRepositories) {
            results.add(new DependencyRepositoryImpl(remoteRepository.getId(), remoteRepository.getUrl()));
        }
        return Collections.unmodifiableList(results);
    }

    public boolean hasRepository(String url) {
        if (url != null) {
            MavenCoreFacet maven = (MavenCoreFacet)this.project.getFacet(MavenCoreFacet.class);
            Model pom = maven.getPOM();
            List repositories = pom.getRepositories();
            for (Repository repo : repositories) {
                if (!repo.getUrl().trim().equals(url.trim())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasRepository(DependencyFacet.KnownRepository repository) {
        return this.hasRepository(repository.getUrl());
    }

    public DependencyRepository removeRepository(String url) {
        if (url != null) {
            MavenCoreFacet maven = (MavenCoreFacet)this.project.getFacet(MavenCoreFacet.class);
            Model pom = maven.getPOM();
            List repos = pom.getRepositories();
            for (Repository repo : repos) {
                if (!repo.getUrl().equals(url.trim())) continue;
                repos.remove(repo);
                maven.setPOM(pom);
                return new DependencyRepositoryImpl(repo.getId(), repo.getUrl());
            }
        }
        return null;
    }

    public List<Dependency> getDependenciesInScopes(ScopeType ... scopes) {
        ArrayList<Dependency> result = new ArrayList<Dependency>();
        List<Dependency> dependencies = this.getDependencies();
        block0: for (Dependency dependency : dependencies) {
            for (ScopeType scope : scopes) {
                if (dependency.getScopeTypeEnum() != null && !dependency.getScopeTypeEnum().equals((Object)scope)) continue;
                dependency = this.resolveProperties(dependency);
                result.add(dependency);
                continue block0;
            }
        }
        return result;
    }

    public List<Dependency> getEffectiveDependenciesInScopes(ScopeType ... scopes) {
        ArrayList<Dependency> result = new ArrayList<Dependency>();
        List<Dependency> dependencies = this.getEffectiveDependencies();
        block0: for (Dependency dependency : dependencies) {
            for (ScopeType scope : scopes) {
                if (dependency.getScopeTypeEnum() != null && !dependency.getScopeTypeEnum().equals((Object)scope)) continue;
                dependency = this.resolveProperties(dependency);
                result.add(dependency);
                continue block0;
            }
        }
        return result;
    }
}

