/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.maven.facets;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.apache.maven.cli.MavenCli;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.ModelProblemUtils;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.jboss.forge.maven.MavenCoreFacet;
import org.jboss.forge.maven.facets.MavenContainer;
import org.jboss.forge.parser.java.util.Strings;
import org.jboss.forge.project.Facet;
import org.jboss.forge.project.ProjectModelException;
import org.jboss.forge.project.facets.BaseFacet;
import org.jboss.forge.project.services.ResourceFactory;
import org.jboss.forge.resources.DirectoryResource;
import org.jboss.forge.resources.FileResource;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.resources.events.ResourceModified;
import org.jboss.forge.shell.ShellMessages;
import org.jboss.forge.shell.ShellPrintWriter;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.util.NativeSystemCall;
import org.jboss.forge.shell.util.OSUtils;
import org.sonatype.aether.graph.Dependency;

@Dependent
@Alias(value="forge.maven.MavenCoreFacet")
public class MavenCoreFacetImpl
extends BaseFacet
implements MavenCoreFacet,
Facet {
    private ProjectBuildingResult buildingResult;
    private ProjectBuildingResult fullBuildingResult;
    @Inject
    private MavenContainer container;
    @Inject
    private ShellPrintWriter writer;
    @Inject
    private BeanManager manager;
    @Inject
    private ResourceFactory factory;

    public ProjectBuildingResult getPartialProjectBuildingResult() {
        if (this.buildingResult == null) {
            ProjectBuildingRequest request = null;
            File pomFile = this.getPOMFile().getUnderlyingResourceObject();
            try {
                request = this.container.getRequest();
                this.buildingResult = this.container.getBuilder().build(pomFile, request);
            }
            catch (ProjectBuildingException partial) {
                if (request != null) {
                    try {
                        request.setResolveDependencies(true);
                        this.fullBuildingResult = this.buildingResult = this.container.getBuilder().build(pomFile, request);
                        this.warnOnProblemsAndErrors();
                    }
                    catch (Exception full) {
                        throw new ProjectModelException((Throwable)full);
                    }
                }
                throw new ProjectModelException((Throwable)partial);
            }
        }
        return this.buildingResult;
    }

    public ProjectBuildingResult getFullProjectBuildingResult() {
        if (this.fullBuildingResult == null) {
            ProjectBuildingRequest request = null;
            request = this.container.getRequest();
            File pomFile = this.getPOMFile().getUnderlyingResourceObject();
            if (request != null) {
                try {
                    request.setResolveDependencies(true);
                    this.fullBuildingResult = this.buildingResult = this.container.getBuilder().build(pomFile, request);
                    this.warnOnProblemsAndErrors();
                }
                catch (Exception full) {
                    throw new ProjectModelException((Throwable)full);
                }
            } else {
                throw new ProjectModelException("Project building request was null");
            }
        }
        return this.fullBuildingResult;
    }

    private void warnOnProblemsAndErrors() {
        for (ModelProblem problem : this.buildingResult.getProblems()) {
            ShellMessages.warn((ShellPrintWriter)this.writer, (String)("[ " + problem.getSeverity() + " ] " + problem.getMessage() + " @ " + ModelProblemUtils.formatLocation((ModelProblem)problem, (String)problem.getModelId())));
        }
        DependencyResolutionResult resolutionResult = this.buildingResult.getDependencyResolutionResult();
        for (Exception collectionError : resolutionResult.getCollectionErrors()) {
            StringBuilder message = new StringBuilder();
            message.append(collectionError.getMessage());
            message.append('\n');
            if (collectionError.getCause() != null) {
                message.append("Cause : ");
                message.append(collectionError.getCause().getMessage());
            }
            ShellMessages.warn((ShellPrintWriter)this.writer, (String)message.toString());
        }
        for (Dependency unresolvedDep : resolutionResult.getUnresolvedDependencies()) {
            ShellMessages.warn((ShellPrintWriter)this.writer, (String)("Failed to resolve dependency [ " + unresolvedDep + " ] , due to error(s) : " + resolutionResult.getResolutionErrors(unresolvedDep)));
        }
    }

    private void invalidateBuildingResults() {
        this.buildingResult = null;
        this.fullBuildingResult = null;
    }

    public Model getPOM() {
        try {
            Model result = new Model();
            MavenXpp3Reader reader = new MavenXpp3Reader();
            FileInputStream stream = new FileInputStream(this.getPOMFile().getUnderlyingResourceObject());
            if (stream.available() > 0) {
                result = reader.read((InputStream)stream);
            }
            stream.close();
            result.setPomFile(this.getPOMFile().getUnderlyingResourceObject());
            return result;
        }
        catch (IOException e) {
            throw new ProjectModelException("Could not open POM file: " + this.getPOMFile(), (Throwable)e);
        }
        catch (XmlPullParserException e) {
            throw new ProjectModelException("Could not parse POM file: " + this.getPOMFile(), (Throwable)e);
        }
    }

    public void setPOM(Model pom) {
        try {
            MavenXpp3Writer writer = new MavenXpp3Writer();
            FileWriter fw = new FileWriter(this.getPOMFile().getUnderlyingResourceObject());
            writer.write((Writer)fw, pom);
            fw.close();
            this.manager.fireEvent((Object)new ResourceModified(this.getPOMFile()), new Annotation[0]);
        }
        catch (IOException e) {
            throw new ProjectModelException("Could not write POM file: " + this.getPOMFile(), (Throwable)e);
        }
        this.invalidateBuildingResults();
    }

    private Model createPOM() {
        FileResource<?> pomFile = this.getPOMFile();
        if (!pomFile.exists()) {
            pomFile.createNewFile();
        }
        Model pom = this.getPOM();
        pom.setGroupId("org.jboss.forge.generated");
        pom.setArtifactId("generated-pom");
        pom.setVersion("1.0.0-SNAPSHOT");
        pom.setPomFile(this.getPOMFile().getUnderlyingResourceObject());
        pom.setModelVersion("4.0.0");
        this.setPOM(pom);
        return pom;
    }

    public FileResource<?> getPOMFile() {
        Resource file = this.project.getProjectRoot().getChild("pom.xml");
        return (FileResource)file;
    }

    public boolean isInstalled() {
        return this.getPOMFile().exists();
    }

    public boolean install() {
        this.createPOM();
        return true;
    }

    public MavenProject getMavenProject() {
        return this.getPartialProjectBuildingResult().getProject();
    }

    public boolean executeMavenEmbedded(String[] parms) {
        return this.executeMavenEmbedded(System.out, System.err, parms);
    }

    public boolean executeMavenEmbedded(PrintStream out, PrintStream err, String[] parms) {
        MavenCli cli;
        int i;
        if (parms == null || parms.length == 0) {
            parms = new String[]{""};
        }
        return (i = (cli = new MavenCli()).doMain(parms, this.project.getProjectRoot().getFullyQualifiedName(), out, err)) == 0;
    }

    public boolean executeMaven(List<String> parameters) {
        return this.executeMaven(parameters.toArray(new String[0]));
    }

    public boolean executeMaven(String[] selected) {
        return this.executeMaven(this.writer, selected);
    }

    public boolean executeMaven(ShellPrintWriter out, String[] parms) {
        try {
            return 0 == NativeSystemCall.execFromPath((String)this.getMvnCommand(), (String[])parms, (ShellPrintWriter)out, (DirectoryResource)this.project.getProjectRoot());
        }
        catch (IOException e) {
            return this.executeMavenEmbedded(parms);
        }
    }

    private String getMvnCommand() {
        return OSUtils.isWindows() ? "mvn.bat" : "mvn";
    }

    public DirectoryResource getLocalRepositoryDirectory() {
        return (DirectoryResource)this.factory.getResourceFrom(new File(this.container.getSettings().getLocalRepository())).reify(DirectoryResource.class);
    }

    public String resolveProperties(String input) {
        String result = input;
        if (!Strings.isNullOrEmpty((String)input)) {
            Properties properties = this.getPartialProjectBuildingResult().getProject().getProperties();
            for (Map.Entry<Object, Object> e : properties.entrySet()) {
                String key = "\\$\\{" + e.getKey().toString() + "\\}";
                Object value = e.getValue();
                result = result.replaceAll(key, value.toString());
            }
        }
        return result;
    }
}

