/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.scaffold.faces;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.persistence.CascadeType;
import javax.persistence.Id;
import javax.persistence.OneToOne;
import org.jboss.forge.env.Configuration;
import org.jboss.forge.parser.JavaParser;
import org.jboss.forge.parser.java.Annotation;
import org.jboss.forge.parser.java.Field;
import org.jboss.forge.parser.java.JavaClass;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.parser.java.Member;
import org.jboss.forge.parser.java.Method;
import org.jboss.forge.parser.java.Parameter;
import org.jboss.forge.parser.xml.Node;
import org.jboss.forge.parser.xml.XMLParser;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.dependencies.Dependency;
import org.jboss.forge.project.dependencies.DependencyBuilder;
import org.jboss.forge.project.facets.BaseFacet;
import org.jboss.forge.project.facets.DependencyFacet;
import org.jboss.forge.project.facets.FacetNotFoundException;
import org.jboss.forge.project.facets.JavaSourceFacet;
import org.jboss.forge.project.facets.WebResourceFacet;
import org.jboss.forge.project.facets.events.InstallFacets;
import org.jboss.forge.resources.FileResource;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.resources.ResourceFilter;
import org.jboss.forge.scaffold.AccessStrategy;
import org.jboss.forge.scaffold.ScaffoldProvider;
import org.jboss.forge.scaffold.TemplateStrategy;
import org.jboss.forge.scaffold.faces.FacesAccessStrategy;
import org.jboss.forge.scaffold.faces.FacesTemplateStrategy;
import org.jboss.forge.scaffold.faces.metawidget.config.ForgeConfigReader;
import org.jboss.forge.scaffold.util.ScaffoldUtil;
import org.jboss.forge.shell.ShellPrompt;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.Help;
import org.jboss.forge.shell.plugins.RequiresFacet;
import org.jboss.forge.shell.util.Streams;
import org.jboss.forge.spec.javaee.CDIFacet;
import org.jboss.forge.spec.javaee.EJBFacet;
import org.jboss.forge.spec.javaee.FacesAPIFacet;
import org.jboss.forge.spec.javaee.FacesFacet;
import org.jboss.forge.spec.javaee.PersistenceFacet;
import org.jboss.forge.spec.javaee.ServletFacet;
import org.jboss.seam.render.TemplateCompiler;
import org.jboss.seam.render.spi.TemplateResolver;
import org.jboss.seam.render.template.CompiledTemplateResource;
import org.jboss.seam.render.template.resolver.ClassLoaderTemplateResolver;
import org.jboss.shrinkwrap.descriptor.api.spec.servlet.web.WebAppDescriptor;
import org.metawidget.config.iface.ConfigReader;
import org.metawidget.statically.StaticUtils;
import org.metawidget.statically.StaticWidget;
import org.metawidget.statically.faces.StaticFacesUtils;
import org.metawidget.statically.faces.component.html.StaticHtmlMetawidget;
import org.metawidget.statically.faces.component.html.widgetbuilder.HtmlOutcomeTargetLink;
import org.metawidget.statically.faces.component.html.widgetbuilder.ReadOnlyWidgetBuilder;
import org.metawidget.statically.faces.component.html.widgetbuilder.richfaces.RichFacesWidgetBuilder;
import org.metawidget.statically.html.widgetbuilder.HtmlTag;
import org.metawidget.statically.javacode.StaticJavaMetawidget;
import org.metawidget.util.ArrayUtils;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.XmlUtils;
import org.metawidget.util.simple.StringUtils;
import org.metawidget.widgetbuilder.composite.CompositeWidgetBuilder;
import org.metawidget.widgetbuilder.composite.CompositeWidgetBuilderConfig;
import org.metawidget.widgetbuilder.iface.WidgetBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

@Alias(value="faces")
@Help(value="JavaServer Faces scaffolding")
@RequiresFacet(value={WebResourceFacet.class, DependencyFacet.class, PersistenceFacet.class, EJBFacet.class, CDIFacet.class, FacesAPIFacet.class})
public class FacesScaffold
extends BaseFacet
implements ScaffoldProvider {
    private static final String XMLNS_PREFIX = "xmlns:";
    private static final String BACKING_BEAN_TEMPLATE = "scaffold/faces/BackingBean.jv";
    private static final String VIEW_UTILS_TEMPLATE = "scaffold/faces/ViewUtils.jv";
    private static final String TAGLIB_TEMPLATE = "scaffold/faces/forge.taglib.xml";
    private static final String VIEW_TEMPLATE = "scaffold/faces/view.xhtml";
    private static final String CREATE_TEMPLATE = "scaffold/faces/create.xhtml";
    private static final String SEARCH_TEMPLATE = "scaffold/faces/search.xhtml";
    private static final String NAVIGATION_TEMPLATE = "scaffold/faces/pageTemplate.xhtml";
    private static final String ERROR_TEMPLATE = "scaffold/faces/error.xhtml";
    private static final String INDEX_TEMPLATE = "scaffold/faces/index.xhtml";
    private static final String INDEX_WELCOME_TEMPLATE = "scaffold/faces/index.html";
    private final Dependency richfaces3UI = DependencyBuilder.create((String)"org.richfaces.ui:richfaces-ui");
    private final Dependency richfaces3Impl = DependencyBuilder.create((String)"org.richfaces.framework:richfaces-impl");
    private final Dependency richfaces4UI = DependencyBuilder.create((String)"org.richfaces.ui:richfaces-components-ui");
    private final Dependency richfaces4Impl = DependencyBuilder.create((String)"org.richfaces.core:richfaces-core-impl");
    protected CompiledTemplateResource backingBeanTemplate;
    protected int backingBeanTemplateQbeMetawidgetIndent;
    protected CompiledTemplateResource viewUtilsTemplate;
    protected CompiledTemplateResource taglibTemplate;
    protected CompiledTemplateResource viewTemplate;
    protected Map<String, String> viewTemplateNamespaces;
    protected int viewTemplateEntityMetawidgetIndent;
    protected CompiledTemplateResource createTemplate;
    protected Map<String, String> createTemplateNamespaces;
    protected int createTemplateEntityMetawidgetIndent;
    protected CompiledTemplateResource searchTemplate;
    protected Map<String, String> searchTemplateNamespaces;
    protected int searchTemplateSearchMetawidgetIndent;
    protected int searchTemplateBeanMetawidgetIndent;
    protected CompiledTemplateResource navigationTemplate;
    protected int navigationTemplateIndent;
    protected CompiledTemplateResource errorTemplate;
    protected CompiledTemplateResource indexWelcomeTemplate;
    protected CompiledTemplateResource indexTemplate;
    protected TemplateResolver<ClassLoader> resolver;
    protected final ShellPrompt prompt;
    protected final TemplateCompiler compiler;
    protected final Event<InstallFacets> install;
    protected StaticHtmlMetawidget entityMetawidget;
    protected StaticHtmlMetawidget searchMetawidget;
    protected StaticHtmlMetawidget beanMetawidget;
    protected StaticJavaMetawidget qbeMetawidget;
    private Configuration config;

    @Inject
    public FacesScaffold(Configuration config, ShellPrompt prompt, TemplateCompiler compiler, Event<InstallFacets> install) {
        this.config = config;
        this.prompt = prompt;
        this.compiler = compiler;
        this.install = install;
        this.resolver = new ClassLoaderTemplateResolver(FacesScaffold.class.getClassLoader());
        if (this.compiler != null) {
            this.compiler.getTemplateResolverFactory().addResolver(this.resolver);
        }
    }

    public List<Resource<?>> setup(String targetDir, Resource<?> template, boolean overwrite) {
        List<Resource<?>> resources = this.generateIndex(targetDir, template, overwrite);
        this.setupWebXML();
        return resources;
    }

    public void setProject(Project project) {
        super.setProject(project);
        this.resetMetaWidgets();
    }

    private void resetMetaWidgets() {
        ForgeConfigReader configReader = new ForgeConfigReader(this.config, this.project);
        this.entityMetawidget = new StaticHtmlMetawidget();
        this.entityMetawidget.setConfigReader((ConfigReader)configReader);
        this.entityMetawidget.setConfig("scaffold/faces/metawidget-entity.xml");
        this.searchMetawidget = new StaticHtmlMetawidget();
        this.searchMetawidget.setConfigReader((ConfigReader)configReader);
        this.searchMetawidget.setConfig("scaffold/faces/metawidget-search.xml");
        this.beanMetawidget = new StaticHtmlMetawidget();
        this.beanMetawidget.setConfigReader((ConfigReader)configReader);
        this.beanMetawidget.setConfig("scaffold/faces/metawidget-bean.xml");
        this.qbeMetawidget = new StaticJavaMetawidget();
        this.qbeMetawidget.setConfigReader((ConfigReader)configReader);
        this.qbeMetawidget.setConfig("scaffold/faces/metawidget-qbe.xml");
    }

    public List<Resource<?>> generateFromEntity(String targetDir, Resource<?> template, JavaClass entity, boolean overwrite) {
        this.resetMetaWidgets();
        this.setupRichFaces();
        ArrayList result = new ArrayList();
        try {
            JavaSourceFacet java = (JavaSourceFacet)this.project.getFacet(JavaSourceFacet.class);
            WebResourceFacet web = (WebResourceFacet)this.project.getFacet(WebResourceFacet.class);
            this.loadTemplates();
            HashMap<Object, Object> context = CollectionUtils.newHashMap();
            context.put("entity", entity);
            String ccEntity = StringUtils.decapitalize((String)entity.getName());
            context.put("ccEntity", ccEntity);
            this.setPrimaryKeyMetaData((Map<Object, Object>)context, entity);
            this.qbeMetawidget.setPath(entity.getQualifiedName());
            StringWriter stringWriter = new StringWriter();
            this.qbeMetawidget.write((Writer)stringWriter, this.backingBeanTemplateQbeMetawidgetIndent);
            context.put("qbeMetawidget", stringWriter.toString().trim());
            Set qbeMetawidgetImports = this.qbeMetawidget.getImports();
            qbeMetawidgetImports.remove(entity.getQualifiedName());
            context.put("qbeMetawidgetImports", CollectionUtils.toString((Collection)qbeMetawidgetImports, (String)";\r\nimport ", (boolean)true, (boolean)false));
            JavaClass viewBean = (JavaClass)JavaParser.parse(JavaClass.class, (String)this.backingBeanTemplate.render((Map)context));
            viewBean.setPackage(java.getBasePackage() + ".view");
            result.add(ScaffoldUtil.createOrOverwrite((ShellPrompt)this.prompt, (FileResource)java.getJavaResource((JavaSource)viewBean), (String)viewBean.toString(), (boolean)overwrite));
            context = this.getTemplateContext(targetDir, template);
            String beanName = StringUtils.decapitalize((String)viewBean.getName());
            context.put("beanName", beanName);
            context.put("ccEntity", ccEntity);
            context.put("entityName", StringUtils.uncamelCase((String)entity.getName()));
            this.setPrimaryKeyMetaData(context, entity);
            this.entityMetawidget.setValue(StaticFacesUtils.wrapExpression((String)(beanName + "." + ccEntity)));
            this.entityMetawidget.setPath(entity.getQualifiedName());
            this.entityMetawidget.setReadOnly(false);
            this.entityMetawidget.setStyle(null);
            this.writeEntityMetawidget(context, this.createTemplateEntityMetawidgetIndent, this.createTemplateNamespaces);
            result.add(ScaffoldUtil.createOrOverwrite((ShellPrompt)this.prompt, (FileResource)web.getWebResource(targetDir + "/" + ccEntity + "/create.xhtml"), (String)this.createTemplate.render(context), (boolean)overwrite));
            this.entityMetawidget.setReadOnly(true);
            this.writeEntityMetawidget(context, this.viewTemplateEntityMetawidgetIndent, this.viewTemplateNamespaces);
            result.add(ScaffoldUtil.createOrOverwrite((ShellPrompt)this.prompt, (FileResource)web.getWebResource(targetDir + "/" + ccEntity + "/view.xhtml"), (String)this.viewTemplate.render(context), (boolean)overwrite));
            this.searchMetawidget.setValue(StaticFacesUtils.wrapExpression((String)(beanName + ".example")));
            this.searchMetawidget.setPath(entity.getQualifiedName());
            this.beanMetawidget.setValue(StaticFacesUtils.wrapExpression((String)(beanName + ".pageItems")));
            this.beanMetawidget.setPath(viewBean.getQualifiedName() + "/pageItems");
            this.writeSearchAndBeanMetawidget(context, this.searchTemplateSearchMetawidgetIndent, this.searchTemplateBeanMetawidgetIndent, this.searchTemplateNamespaces);
            result.add(ScaffoldUtil.createOrOverwrite((ShellPrompt)this.prompt, (FileResource)web.getWebResource(targetDir + "/" + ccEntity + "/search.xhtml"), (String)this.searchTemplate.render(context), (boolean)overwrite));
            result.add(this.generateNavigation(targetDir, overwrite));
            JavaClass viewUtils = (JavaClass)JavaParser.parse(JavaClass.class, (String)this.viewUtilsTemplate.render(context));
            viewUtils.setPackage(viewBean.getPackage());
            result.add(ScaffoldUtil.createOrOverwrite((ShellPrompt)this.prompt, (FileResource)java.getJavaResource((JavaSource)viewUtils), (String)viewUtils.toString(), (boolean)true));
            context.put("viewPackage", viewBean.getPackage());
            result.add(ScaffoldUtil.createOrOverwrite((ShellPrompt)this.prompt, (FileResource)web.getWebResource("WEB-INF/classes/META-INF/forge.taglib.xml"), (String)this.taglibTemplate.render(context), (boolean)true));
            this.createInitializers(entity);
        }
        catch (Exception e) {
            throw new RuntimeException("Error generating default scaffolding: " + e.getMessage(), e);
        }
        return result;
    }

    public boolean install() {
        if (!(this.project.hasFacet(WebResourceFacet.class) && this.project.hasFacet(PersistenceFacet.class) && this.project.hasFacet(CDIFacet.class) && this.project.hasFacet(FacesFacet.class))) {
            this.install.fire((Object)new InstallFacets(new Class[]{WebResourceFacet.class, PersistenceFacet.class, CDIFacet.class, FacesFacet.class}));
        }
        return true;
    }

    public boolean isInstalled() {
        return true;
    }

    public List<Resource<?>> generateIndex(String targetDir, Resource<?> template, boolean overwrite) {
        ArrayList result = new ArrayList();
        WebResourceFacet web = (WebResourceFacet)this.project.getFacet(WebResourceFacet.class);
        ((ServletFacet)this.project.getFacet(ServletFacet.class)).getConfig().welcomeFile("/index.html");
        this.loadTemplates();
        this.generateTemplates(targetDir, overwrite);
        HashMap<Object, Object> context = this.getTemplateContext(targetDir, template);
        result.add(ScaffoldUtil.createOrOverwrite((ShellPrompt)this.prompt, (FileResource)web.getWebResource(targetDir + "/index.html"), (String)this.indexWelcomeTemplate.render(context), (boolean)overwrite));
        result.add(ScaffoldUtil.createOrOverwrite((ShellPrompt)this.prompt, (FileResource)web.getWebResource(targetDir + "/index.xhtml"), (String)this.indexTemplate.render(context), (boolean)overwrite));
        result.add(ScaffoldUtil.createOrOverwrite((ShellPrompt)this.prompt, (FileResource)web.getWebResource("error.xhtml"), (String)this.errorTemplate.render(context), (boolean)overwrite));
        result.add(ScaffoldUtil.createOrOverwrite((ShellPrompt)this.prompt, (FileResource)web.getWebResource("/resources/add.png"), (InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/scaffold/faces/add.png"), (boolean)overwrite));
        result.add(ScaffoldUtil.createOrOverwrite((ShellPrompt)this.prompt, (FileResource)web.getWebResource("/resources/bootstrap.css"), (InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/scaffold/faces/bootstrap.css"), (boolean)overwrite));
        result.add(ScaffoldUtil.createOrOverwrite((ShellPrompt)this.prompt, (FileResource)web.getWebResource("/resources/false.png"), (InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/scaffold/faces/false.png"), (boolean)overwrite));
        result.add(ScaffoldUtil.createOrOverwrite((ShellPrompt)this.prompt, (FileResource)web.getWebResource("/resources/favicon.ico"), (InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/scaffold/faces/favicon.ico"), (boolean)overwrite));
        result.add(ScaffoldUtil.createOrOverwrite((ShellPrompt)this.prompt, (FileResource)web.getWebResource("/resources/forge-logo.png"), (InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/scaffold/faces/forge-logo.png"), (boolean)overwrite));
        result.add(ScaffoldUtil.createOrOverwrite((ShellPrompt)this.prompt, (FileResource)web.getWebResource("/resources/forge-style.css"), (InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/scaffold/faces/forge-style.css"), (boolean)overwrite));
        result.add(ScaffoldUtil.createOrOverwrite((ShellPrompt)this.prompt, (FileResource)web.getWebResource("/resources/remove.png"), (InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/scaffold/faces/remove.png"), (boolean)overwrite));
        result.add(ScaffoldUtil.createOrOverwrite((ShellPrompt)this.prompt, (FileResource)web.getWebResource("/resources/search.png"), (InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/scaffold/faces/search.png"), (boolean)overwrite));
        result.add(ScaffoldUtil.createOrOverwrite((ShellPrompt)this.prompt, (FileResource)web.getWebResource("/resources/true.png"), (InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/scaffold/faces/true.png"), (boolean)overwrite));
        result.add(ScaffoldUtil.createOrOverwrite((ShellPrompt)this.prompt, (FileResource)web.getWebResource("/resources/jboss-community.png"), (InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/scaffold/faces/jboss-community.png"), (boolean)overwrite));
        return result;
    }

    public List<Resource<?>> getGeneratedResources(String targetDir) {
        throw new RuntimeException("Not yet implemented!");
    }

    public AccessStrategy getAccessStrategy() {
        return new FacesAccessStrategy(this.project);
    }

    public TemplateStrategy getTemplateStrategy() {
        return new FacesTemplateStrategy(this.project);
    }

    public List<Resource<?>> generateTemplates(String targetDir, boolean overwrite) {
        ArrayList result = new ArrayList();
        try {
            WebResourceFacet web = (WebResourceFacet)this.project.getFacet(WebResourceFacet.class);
            result.add(ScaffoldUtil.createOrOverwrite((ShellPrompt)this.prompt, (FileResource)web.getWebResource("/resources/scaffold/paginator.xhtml"), (InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/scaffold/faces/paginator.xhtml"), (boolean)overwrite));
            result.add(this.generateNavigation(targetDir, overwrite));
        }
        catch (Exception e) {
            throw new RuntimeException("Error generating default templates", e);
        }
        return result;
    }

    protected void loadTemplates() {
        String template;
        if (this.backingBeanTemplate == null) {
            this.backingBeanTemplate = this.compiler.compile(BACKING_BEAN_TEMPLATE);
            template = Streams.toString((InputStream)this.backingBeanTemplate.getSourceTemplateResource().getInputStream());
            this.backingBeanTemplateQbeMetawidgetIndent = this.parseIndent(template, "@{qbeMetawidget}");
        }
        if (this.viewUtilsTemplate == null) {
            this.viewUtilsTemplate = this.compiler.compile(VIEW_UTILS_TEMPLATE);
        }
        if (this.taglibTemplate == null) {
            this.taglibTemplate = this.compiler.compile(TAGLIB_TEMPLATE);
        }
        if (this.viewTemplate == null) {
            this.viewTemplate = this.compiler.compile(VIEW_TEMPLATE);
            template = Streams.toString((InputStream)this.viewTemplate.getSourceTemplateResource().getInputStream());
            this.viewTemplateNamespaces = this.parseNamespaces(template);
            this.viewTemplateEntityMetawidgetIndent = this.parseIndent(template, "@{metawidget}");
        }
        if (this.createTemplate == null) {
            this.createTemplate = this.compiler.compile(CREATE_TEMPLATE);
            template = Streams.toString((InputStream)this.createTemplate.getSourceTemplateResource().getInputStream());
            this.createTemplateNamespaces = this.parseNamespaces(template);
            this.createTemplateEntityMetawidgetIndent = this.parseIndent(template, "@{metawidget}");
        }
        if (this.searchTemplate == null) {
            this.searchTemplate = this.compiler.compile(SEARCH_TEMPLATE);
            template = Streams.toString((InputStream)this.searchTemplate.getSourceTemplateResource().getInputStream());
            this.searchTemplateNamespaces = this.parseNamespaces(template);
            this.searchTemplateSearchMetawidgetIndent = this.parseIndent(template, "@{searchMetawidget}");
            this.searchTemplateBeanMetawidgetIndent = this.parseIndent(template, "@{beanMetawidget}");
        }
        if (this.navigationTemplate == null) {
            this.navigationTemplate = this.compiler.compile(NAVIGATION_TEMPLATE);
            template = Streams.toString((InputStream)this.navigationTemplate.getSourceTemplateResource().getInputStream());
            this.navigationTemplateIndent = this.parseIndent(template, "@{navigation}");
        }
        if (this.errorTemplate == null) {
            this.errorTemplate = this.compiler.compile(ERROR_TEMPLATE);
        }
        if (this.indexTemplate == null) {
            this.indexTemplate = this.compiler.compile(INDEX_TEMPLATE);
        }
        if (this.indexWelcomeTemplate == null) {
            this.indexWelcomeTemplate = this.compiler.compile(INDEX_WELCOME_TEMPLATE);
        }
    }

    protected void setupRichFaces() {
        if (((DependencyFacet)this.project.getFacet(DependencyFacet.class)).hasEffectiveDependency(this.richfaces3UI) && ((DependencyFacet)this.project.getFacet(DependencyFacet.class)).hasEffectiveDependency(this.richfaces3Impl) || ((DependencyFacet)this.project.getFacet(DependencyFacet.class)).hasEffectiveDependency(this.richfaces4UI) && ((DependencyFacet)this.project.getFacet(DependencyFacet.class)).hasEffectiveDependency(this.richfaces4Impl)) {
            this.entityMetawidget.setWidgetBuilder(this.insertRichFacesWidgetBuilder((CompositeWidgetBuilder)this.entityMetawidget.getWidgetBuilder()));
            this.searchMetawidget.setWidgetBuilder(this.insertRichFacesWidgetBuilder((CompositeWidgetBuilder)this.searchMetawidget.getWidgetBuilder()));
            this.beanMetawidget.setWidgetBuilder(this.insertRichFacesWidgetBuilder((CompositeWidgetBuilder)this.beanMetawidget.getWidgetBuilder()));
        }
    }

    protected <W extends StaticWidget, M extends W> CompositeWidgetBuilder<W, M> insertRichFacesWidgetBuilder(CompositeWidgetBuilder<W, M> compositeWidgetBuilder) {
        Object[] existingWidgetBuilders = compositeWidgetBuilder.getWidgetBuilders();
        int addAt = 0;
        for (int loop = 0; loop < existingWidgetBuilders.length; ++loop) {
            WidgetBuilder widgetBuilder = existingWidgetBuilders[loop];
            if (widgetBuilder instanceof RichFacesWidgetBuilder) {
                return compositeWidgetBuilder;
            }
            if (!(widgetBuilder instanceof ReadOnlyWidgetBuilder)) continue;
            addAt = loop + 1;
        }
        WidgetBuilder[] newWidgetBuilders = (WidgetBuilder[])ArrayUtils.addAt((Object[])existingWidgetBuilders, (int)addAt, (Object[])new WidgetBuilder[]{new RichFacesWidgetBuilder()});
        return new CompositeWidgetBuilder(new CompositeWidgetBuilderConfig().setWidgetBuilders(newWidgetBuilders));
    }

    protected void createInitializers(JavaClass entity) throws FacetNotFoundException, FileNotFoundException {
        Annotation oneToOne;
        boolean dirtyBit = false;
        for (Field field : entity.getFields()) {
            String methodName;
            if (!field.hasAnnotation(OneToOne.class)) continue;
            oneToOne = field.getAnnotation(OneToOne.class);
            if (oneToOne.getStringValue("mappedBy") == null && oneToOne.getStringValue("cascade") == null) {
                oneToOne.setEnumValue("cascade", (Enum)CascadeType.ALL);
                dirtyBit = true;
            }
            if (entity.hasMethodSignature(methodName = "new" + StringUtils.capitalize((String)field.getName()))) continue;
            ((Method)entity.addMethod().setName(methodName).setReturnTypeVoid().setPublic()).setBody("this." + field.getName() + " = new " + field.getType() + "();");
            dirtyBit = true;
        }
        for (Method method : entity.getMethods()) {
            if (!method.hasAnnotation(OneToOne.class)) continue;
            oneToOne = method.getAnnotation(OneToOne.class);
            if (oneToOne.getStringValue("mappedBy") == null && oneToOne.getStringValue("cascade") == null) {
                oneToOne.setEnumValue("cascade", (Enum)CascadeType.ALL);
                dirtyBit = true;
            }
            String fieldName = StringUtils.camelCase((String)method.getName().substring(3));
            String methodName = "new" + StringUtils.capitalize((String)fieldName);
            if (entity.hasMethodSignature(methodName)) continue;
            ((Method)entity.addMethod().setName(methodName).setReturnTypeVoid().setPublic()).setBody("this." + fieldName + " = new " + method.getReturnType() + "();");
            dirtyBit = true;
        }
        if (dirtyBit) {
            ((JavaSourceFacet)this.project.getFacet(JavaSourceFacet.class)).saveJavaSource((JavaSource)entity);
        }
    }

    protected HashMap<Object, Object> getTemplateContext(String targetDir, Resource<?> template) {
        HashMap<Object, Object> context = new HashMap<Object, Object>();
        context.put("template", template);
        context.put("templateStrategy", this.getTemplateStrategy());
        context.put("targetDir", targetDir);
        return context;
    }

    protected void setupWebXML() {
        ServletFacet servlet = (ServletFacet)this.project.getFacet(ServletFacet.class);
        Node webXML = this.removeConflictingErrorPages(servlet);
        servlet.getConfigFile().setContents(XMLParser.toXMLInputStream((Node)webXML));
        WebAppDescriptor servletConfig = servlet.getConfig();
        WebResourceFacet web = (WebResourceFacet)this.project.getFacet(WebResourceFacet.class);
        String errorLocation = (String)this.getAccessStrategy().getWebPaths((Resource)web.getWebResource("error.xhtml")).get(1);
        servletConfig.errorPage(404, errorLocation);
        servletConfig.errorPage(500, errorLocation);
        servlet.saveConfig(servletConfig);
    }

    protected Node removeConflictingErrorPages(ServletFacet servlet) {
        Node webXML = XMLParser.parse((InputStream)servlet.getConfigFile().getResourceInputStream());
        Node root = webXML.getRoot();
        List errorPages = root.get("error-page");
        for (String code : Arrays.asList("404", "500")) {
            for (Node errorPage : errorPages) {
                if (!code.equals(errorPage.getSingle("error-code").getText()) || !this.prompt.promptBoolean("Your web.xml already contains an error page for " + code + " status codes, replace it?")) continue;
                root.removeChild(errorPage);
            }
        }
        return webXML;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Resource<?> generateNavigation(String targetDir, boolean overwrite) throws IOException {
        WebResourceFacet web = (WebResourceFacet)this.project.getFacet(WebResourceFacet.class);
        HtmlTag unorderedList = new HtmlTag("ul");
        ResourceFilter filter = new ResourceFilter(){

            public boolean accept(Resource<?> resource) {
                FileResource file = (FileResource)resource;
                return file.isDirectory() && !file.getName().equals("resources") && !file.getName().equals("WEB-INF") && !file.getName().equals("META-INF");
            }
        };
        for (Resource resource : web.getWebResource(targetDir + "/").listResources(filter)) {
            HtmlOutcomeTargetLink outcomeTargetLink = new HtmlOutcomeTargetLink();
            outcomeTargetLink.putAttribute("outcome", targetDir + "/" + resource.getName() + "/search");
            outcomeTargetLink.setValue(StringUtils.uncamelCase((String)resource.getName()));
            HtmlTag listItem = new HtmlTag("li");
            listItem.getChildren().add(outcomeTargetLink);
            unorderedList.getChildren().add(listItem);
        }
        StaticUtils.IndentedWriter writer = new StaticUtils.IndentedWriter((Writer)new StringWriter(), this.navigationTemplateIndent);
        unorderedList.write((Writer)writer);
        HashMap context = CollectionUtils.newHashMap();
        context.put("appName", StringUtils.uncamelCase((String)this.project.getProjectRoot().getName()));
        context.put("navigation", writer.toString().trim());
        context.put("targetDir", targetDir);
        if (this.navigationTemplate == null) {
            this.loadTemplates();
        }
        try {
            Resource resource = ScaffoldUtil.createOrOverwrite((ShellPrompt)this.prompt, (FileResource)((FileResource)this.getTemplateStrategy().getDefaultTemplate()), (String)this.navigationTemplate.render((Map)context), (boolean)overwrite);
            return resource;
        }
        finally {
            writer.close();
        }
    }

    protected Map<String, String> parseNamespaces(String template) {
        HashMap namespaces = CollectionUtils.newHashMap();
        Document document = XmlUtils.documentFromString((String)template);
        Element element = document.getDocumentElement();
        NamedNodeMap attributes = element.getAttributes();
        int length = attributes.getLength();
        for (int loop = 0; loop < length; ++loop) {
            org.w3c.dom.Node node = attributes.item(loop);
            String nodeName = node.getNodeName();
            int indexOf = nodeName.indexOf(XMLNS_PREFIX);
            if (indexOf == -1) continue;
            namespaces.put(nodeName.substring(indexOf + XMLNS_PREFIX.length()), node.getNodeValue());
        }
        return namespaces;
    }

    protected int parseIndent(String template, String indentOf) {
        int indent = 0;
        for (int indexOf = template.indexOf(indentOf); indexOf >= 0 && template.charAt(indexOf) != '\n'; --indexOf) {
            if (template.charAt(indexOf) != '\t') continue;
            ++indent;
        }
        return indent;
    }

    protected void writeEntityMetawidget(Map<Object, Object> context, int entityMetawidgetIndent, Map<String, String> existingNamespaces) {
        StringWriter stringWriter = new StringWriter();
        this.entityMetawidget.write((Writer)stringWriter, entityMetawidgetIndent);
        context.put("metawidget", stringWriter.toString().trim());
        Map namespaces = this.entityMetawidget.getNamespaces();
        namespaces.keySet().removeAll(existingNamespaces.keySet());
        context.put("metawidgetNamespaces", this.namespacesToString(namespaces));
    }

    protected void writeSearchAndBeanMetawidget(Map<Object, Object> context, int searchMetawidgetIndent, int beanMetawidgetIndent, Map<String, String> existingNamespaces) {
        StringWriter stringWriter = new StringWriter();
        this.searchMetawidget.write((Writer)stringWriter, searchMetawidgetIndent);
        context.put("searchMetawidget", stringWriter.toString().trim());
        stringWriter = new StringWriter();
        this.beanMetawidget.write((Writer)stringWriter, beanMetawidgetIndent);
        context.put("beanMetawidget", stringWriter.toString().trim());
        Map namespaces = this.searchMetawidget.getNamespaces();
        namespaces.putAll(this.beanMetawidget.getNamespaces());
        namespaces.keySet().removeAll(existingNamespaces.keySet());
        context.put("metawidgetNamespaces", this.namespacesToString(namespaces));
    }

    protected String namespacesToString(Map<String, String> namespaces) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> entry : namespaces.entrySet()) {
            builder.append("\"\r\n\txmlns:");
            builder.append(entry.getKey());
            builder.append("=\"");
            builder.append(entry.getValue());
        }
        return builder.toString();
    }

    private void setPrimaryKeyMetaData(Map<Object, Object> context, JavaClass entity) {
        String pkName = "id";
        String pkType = "Long";
        String nullablePkType = "Long";
        for (Member m : entity.getMembers()) {
            if (!m.hasAnnotation(Id.class)) continue;
            if (m instanceof Field) {
                Field field = (Field)m;
                pkName = field.getName();
                nullablePkType = pkType = field.getType();
                break;
            }
            Method method = (Method)m;
            pkName = method.getName().substring(3);
            pkType = method.getName().startsWith("get") ? method.getReturnType() : ((Parameter)method.getParameters().get(0)).getType();
            nullablePkType = pkType;
            break;
        }
        if ("int".equals(pkType)) {
            nullablePkType = Integer.class.getSimpleName();
        } else if ("short".equals(pkType)) {
            nullablePkType = Short.class.getSimpleName();
        } else if ("byte".equals(pkType)) {
            nullablePkType = Byte.class.getSimpleName();
        } else if ("long".equals(pkType)) {
            nullablePkType = Long.class.getSimpleName();
        }
        context.put("primaryKey", pkName);
        context.put("primaryKeyCC", StringUtils.capitalize((String)pkName));
        context.put("primaryKeyType", pkType);
        context.put("nullablePrimaryKeyType", nullablePkType);
    }
}

