/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.scaffoldx.facets;

import java.io.File;
import java.io.InputStream;
import javax.enterprise.context.Dependent;
import org.jboss.forge.maven.MavenCoreFacet;
import org.jboss.forge.project.Facet;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.facets.BaseFacet;
import org.jboss.forge.project.facets.FacetNotFoundException;
import org.jboss.forge.resources.DirectoryResource;
import org.jboss.forge.resources.FileResource;
import org.jboss.forge.scaffoldx.facets.ScaffoldTemplateFacet;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.RequiresFacet;

@Dependent
@Alias(value="forge.maven.scaffold.TemplateFacet")
@RequiresFacet(value={MavenCoreFacet.class})
public class MavenScaffoldTemplateFacet
extends BaseFacet
implements ScaffoldTemplateFacet,
Facet {
    private Project project;

    @Override
    public DirectoryResource getRootTemplateDirectory() {
        return this.project.getProjectRoot().getChildDirectory("src" + File.separator + "main" + File.separator + "templates");
    }

    @Override
    public DirectoryResource getTemplateDirectory(String provider) {
        return this.getRootTemplateDirectory().getChildDirectory(provider);
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public boolean isInstalled() {
        try {
            this.project.getFacet(MavenCoreFacet.class);
            return this.getRootTemplateDirectory().exists();
        }
        catch (FacetNotFoundException e) {
            return false;
        }
    }

    public boolean install() {
        if (!this.isInstalled()) {
            this.getRootTemplateDirectory().mkdir();
        }
        return true;
    }

    @Override
    public FileResource<?> getResource(String provider, String relativePath) {
        return (FileResource)this.getTemplateDirectory(provider).getChild(relativePath);
    }

    @Override
    public FileResource<?> createResource(InputStream data, String provider, String relativeFilename) {
        FileResource file = (FileResource)this.getTemplateDirectory(provider).getChild(relativeFilename);
        file.setContents(data);
        return file;
    }

    @Override
    public FileResource<?> createResource(char[] data, String provider, String relativeFilename) {
        FileResource file = (FileResource)this.getTemplateDirectory(provider).getChild(relativeFilename);
        file.setContents(data);
        return file;
    }

    @Override
    public FileResource<?> createResource(String data, String provider, String relativeFilename) {
        FileResource file = (FileResource)this.getTemplateDirectory(provider).getChild(relativeFilename);
        file.setContents(data);
        return file;
    }
}

