/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.scaffoldx.faces;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.persistence.Entity;
import org.jboss.forge.env.Configuration;
import org.jboss.forge.parser.java.JavaClass;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.parser.java.util.Strings;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.facets.BaseFacet;
import org.jboss.forge.project.facets.DependencyFacet;
import org.jboss.forge.project.facets.WebResourceFacet;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.resources.java.JavaResource;
import org.jboss.forge.scaffold.ScaffoldProvider;
import org.jboss.forge.scaffoldx.AccessStrategy;
import org.jboss.forge.scaffoldx.TemplateStrategy;
import org.jboss.forge.shell.ShellMessages;
import org.jboss.forge.shell.ShellPrintWriter;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.Help;
import org.jboss.forge.shell.plugins.RequiresFacet;
import org.jboss.forge.spec.javaee.CDIFacet;
import org.jboss.forge.spec.javaee.EJBFacet;
import org.jboss.forge.spec.javaee.FacesAPIFacet;
import org.jboss.forge.spec.javaee.PersistenceFacet;

@Alias(value="faces")
@Help(value="JavaServer Faces scaffolding")
@RequiresFacet(value={WebResourceFacet.class, DependencyFacet.class, PersistenceFacet.class, EJBFacet.class, CDIFacet.class, FacesAPIFacet.class})
public class FacesScaffold
extends BaseFacet
implements org.jboss.forge.scaffoldx.ScaffoldProvider {
    @Inject
    private ShellPrintWriter writer;
    @Inject
    @Alias(value="faces")
    private org.jboss.forge.scaffold.faces.FacesScaffold delegate;
    @Inject
    private Configuration config;

    public void setProject(Project project) {
        this.delegate.setProject(project);
        super.setProject(project);
    }

    public boolean install() {
        return this.delegate.install();
    }

    public boolean isInstalled() {
        return this.delegate.isInstalled();
    }

    public List<Resource<?>> setup(String targetDir, boolean overwrite, boolean installTemplates) {
        this.synchronizeTargetDir(this, this.delegate);
        return this.delegate.setup(targetDir, null, overwrite);
    }

    public List<Resource<?>> generateFrom(List<Resource<?>> resources, String targetDir, boolean overwrite) {
        this.synchronizeTargetDir(this, this.delegate);
        ArrayList generatedResources = new ArrayList();
        try {
            List<JavaClass> javaClasses = this.selectTargets(resources);
            for (JavaClass javaClass : javaClasses) {
                generatedResources.addAll(this.delegate.generateFromEntity(targetDir, null, javaClass, overwrite));
            }
        }
        catch (FileNotFoundException fileEx) {
            throw new RuntimeException(fileEx);
        }
        return generatedResources;
    }

    public AccessStrategy getAccessStrategy() {
        return null;
    }

    public TemplateStrategy getTemplateStrategy() {
        return null;
    }

    private List<JavaClass> selectTargets(List<Resource<?>> resources) throws FileNotFoundException {
        ArrayList<JavaClass> results = new ArrayList<JavaClass>();
        for (Resource<?> r : resources) {
            if (!(r instanceof JavaResource)) continue;
            JavaSource entity = ((JavaResource)r).getJavaSource();
            if (entity instanceof JavaClass) {
                if (entity.hasAnnotation(Entity.class)) {
                    results.add((JavaClass)entity);
                    continue;
                }
                this.displaySkippingResourceMsg(entity);
                continue;
            }
            this.displaySkippingResourceMsg(entity);
        }
        return results;
    }

    private void displaySkippingResourceMsg(JavaSource<?> entity) {
        ShellMessages.info((ShellPrintWriter)this.writer, (String)("Skipped non-@Entity Java resource [" + entity.getQualifiedName() + "]"));
    }

    private void synchronizeTargetDir(FacesScaffold facesScaffold, org.jboss.forge.scaffold.faces.FacesScaffold delegate) {
        String targetDirKey = this.getTargetDirConfigKey(facesScaffold);
        String target = this.config.getString(targetDirKey);
        if (!Strings.isNullOrEmpty((String)target)) {
            String delegateTargetDirConfigKey = this.getDelegateTargetDirConfigKey((ScaffoldProvider)delegate);
            this.config.setProperty(delegateTargetDirConfigKey, (Object)target);
        }
    }

    private String getTargetDirConfigKey(org.jboss.forge.scaffoldx.ScaffoldProvider provider) {
        return provider.getClass().getName() + "_targetDir";
    }

    private String getDelegateTargetDirConfigKey(ScaffoldProvider provider) {
        return provider.getClass().getName() + "_targetDir";
    }
}

