/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.scaffoldx.plugins;

import java.io.FileNotFoundException;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jboss.forge.bus.util.Annotations;
import org.jboss.forge.scaffoldx.ScaffoldProvider;
import org.jboss.forge.shell.ShellColor;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.DefaultCommand;
import org.jboss.forge.shell.plugins.Help;
import org.jboss.forge.shell.plugins.PipeOut;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.Topic;
import org.jboss.forge.shell.util.ConstraintInspector;

@Alias(value="list-scaffoldx-providers")
@Topic(value="UI Generation & Scaffolding")
@Help(value="Lists all the scaffold providers registered on this forge installation")
public class ListScaffoldXProvidersPlugin
implements Plugin {
    @Inject
    @Any
    private Instance<ScaffoldProvider> providers;

    @DefaultCommand
    public void listProviders(PipeOut out) throws FileNotFoundException {
        for (ScaffoldProvider scaffoldProvider : this.providers) {
            Class<?> scaffoldClass = scaffoldProvider.getClass();
            String alias = ConstraintInspector.getName(scaffoldClass);
            String description = Annotations.isAnnotationPresent(scaffoldClass, Help.class) ? ((Help)Annotations.getAnnotation(scaffoldClass, Help.class)).value() : "<no description found>";
            out.print(ShellColor.BOLD, "* " + alias + " : ");
            out.println(description);
        }
    }
}

