/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.resources;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.inject.Inject;
import org.jboss.forge.project.services.ResourceFactory;
import org.jboss.forge.resources.EntryResource;
import org.jboss.forge.resources.FileResource;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.resources.ResourceFlag;
import org.jboss.forge.resources.ResourceHandles;
import org.jboss.forge.shell.util.Streams;

@ResourceHandles(value={"*.properties"})
public class PropertiesFileResource
extends FileResource<PropertiesFileResource> {
    @Inject
    public PropertiesFileResource(ResourceFactory factory) {
        super(factory, (File)null);
        this.setFlag(ResourceFlag.Leaf);
    }

    public PropertiesFileResource(ResourceFactory factory, File file) {
        super(factory, file);
        this.setFlag(ResourceFlag.Leaf);
    }

    @Override
    public Resource<File> createFrom(File file) {
        return new PropertiesFileResource(this.getResourceFactory(), file);
    }

    @Override
    protected List<Resource<?>> doListResources() {
        Properties p = this.getFileContentAsProperties();
        ArrayList entryResources = new ArrayList(p.size());
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            EntryResource<Object, Object> entryResource = new EntryResource<Object, Object>(this, entry.getKey(), entry.getValue());
            entryResources.add(entryResource);
        }
        return entryResources;
    }

    public String putProperty(String key, String value) {
        Properties props = this.getFileContentAsProperties();
        String oldValue = (String)props.setProperty(key, value);
        this.storeProperties(props);
        return oldValue;
    }

    public void putAllProperties(Map<String, String> newProperties) {
        Properties props = this.getFileContentAsProperties();
        props.putAll(newProperties);
        this.storeProperties(props);
    }

    public void replaceProperties(Map<String, String> newProperties) {
        SortedProperties props = new SortedProperties();
        props.putAll(newProperties);
        this.storeProperties(props);
    }

    public String removeProperty(String key) {
        Properties props = this.getFileContentAsProperties();
        String oldValue = (String)props.remove(key);
        this.storeProperties(props);
        return oldValue;
    }

    public String getProperty(String key) {
        Properties props = this.getFileContentAsProperties();
        return props.getProperty(key);
    }

    public Set<String> getKeys() {
        return this.getFileContentAsProperties().stringPropertyNames();
    }

    private void storeProperties(Properties props) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.getUnderlyingResourceObject());
            props.store(fos, "Generated by Forge i18n Plugin");
        }
        catch (IOException io) {
            try {
                throw new RuntimeException("Error while storing file", io);
            }
            catch (Throwable throwable) {
                Streams.closeQuietly(fos);
                throw throwable;
            }
        }
        Streams.closeQuietly(fos);
    }

    private Properties getFileContentAsProperties() {
        SortedProperties p = new SortedProperties();
        InputStream is = null;
        try {
            is = this.getResourceInputStream();
            p.load(is);
        }
        catch (IOException io) {
            throw new RuntimeException("Error while loading properties");
        }
        finally {
            Streams.closeQuietly(is);
        }
        return p;
    }

    public String toString() {
        return this.file.getName();
    }

    private class SortedProperties
    extends Properties {
        private SortedProperties() {
        }

        @Override
        public synchronized Enumeration<Object> keys() {
            Enumeration<Object> keysEnum = super.keys();
            ArrayList<String> keyList = new ArrayList<String>();
            while (keysEnum.hasMoreElements()) {
                keyList.add((String)keysEnum.nextElement());
            }
            Collections.sort(keyList);
            Enumeration<Object> e = Collections.enumeration(keyList);
            return e;
        }
    }
}

