/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jboss.forge.shell.util.OSUtils;
import org.jboss.forge.shell.util.Streams;

public class Files {
    public static final String HOME_ALIAS = "~";
    public static final String SLASH = File.separator;

    public static String canonicalize(String target) {
        if (target.startsWith(HOME_ALIAS)) {
            String homePath = OSUtils.getUserHomePath();
            target = homePath + target.substring(1, target.length());
        }
        return target;
    }

    public static File getWorkingDirectory() {
        return new File("").getAbsoluteFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(File zipFile, File targetDirectory) throws IOException {
        OutputStream dest = null;
        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(zipFile)));
        try {
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                File file = new File(targetDirectory, entry.getName());
                if (entry.isDirectory()) {
                    file.mkdirs();
                    continue;
                }
                try {
                    dest = new BufferedOutputStream(new FileOutputStream(file));
                    Streams.write(zis, dest);
                }
                finally {
                    if (dest != null) {
                        dest.flush();
                    }
                    Streams.closeQuietly(dest);
                }
            }
        }
        finally {
            Streams.closeQuietly(zis);
        }
    }
}

