/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.util;

public class Packages {
    public static String toFileSyntax(String pkg) {
        return pkg.replace(".", "/");
    }

    public static String fromFileSyntax(String pkg) {
        return pkg.replace("/", ".");
    }

    public static String toValidPackageName(String pkg) {
        if (pkg == null) {
            throw new IllegalArgumentException("Package should not be null");
        }
        StringBuilder sb = new StringBuilder(pkg.length());
        boolean hasIdentifierStarted = false;
        for (int i = 0; i < pkg.length(); ++i) {
            int c = pkg.codePointAt(i);
            if (!hasIdentifierStarted) {
                if (!Character.isJavaIdentifierStart(c)) continue;
                sb.appendCodePoint(c);
                hasIdentifierStarted = true;
                continue;
            }
            if (Character.isJavaIdentifierPart(c)) {
                sb.appendCodePoint(c);
                continue;
            }
            if (c != 46) continue;
            sb.appendCodePoint(c);
            hasIdentifierStarted = false;
        }
        return sb.toString();
    }
}

