/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.project.services;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.forge.project.Facet;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.locator.ProjectLocator;
import org.jboss.forge.project.services.FacetFactory;
import org.jboss.forge.resources.DirectoryResource;
import org.jboss.forge.shell.util.BeanManagerUtils;
import org.jboss.forge.shell.util.ConstraintInspector;
import org.jboss.forge.shell.util.ResourceUtil;

@Singleton
public class ProjectFactory {
    private final FacetFactory facetFactory;
    private List<ProjectLocator> locators;
    private final BeanManager manager;
    private final Instance<ProjectLocator> locatorInstance;

    @Inject
    public ProjectFactory(FacetFactory facetFactory, BeanManager manager, Instance<ProjectLocator> locatorInstance) {
        this.facetFactory = facetFactory;
        this.locatorInstance = locatorInstance;
        this.manager = manager;
    }

    public void init() {
        if (this.locators == null || this.locators.isEmpty()) {
            Iterator iterator = this.locatorInstance.iterator();
            ArrayList<ProjectLocator> result = new ArrayList<ProjectLocator>();
            while (iterator.hasNext()) {
                ProjectLocator element = (ProjectLocator)BeanManagerUtils.getContextualInstance(this.manager, ((ProjectLocator)iterator.next()).getClass());
                result.add(element);
            }
            this.locators = result;
        }
    }

    public DirectoryResource findProjectRootRecusively(DirectoryResource currentDirectory) {
        ProjectLocator locator;
        DirectoryResource root = null;
        List<ProjectLocator> locators = this.getLocators();
        Iterator<ProjectLocator> iterator = locators.iterator();
        while (iterator.hasNext() && (root = this.locateRecursively(currentDirectory, locator = iterator.next())) == null) {
        }
        return root;
    }

    public DirectoryResource locateRecursively(DirectoryResource startingDirectory, ProjectLocator locator) {
        DirectoryResource root = startingDirectory;
        while (!locator.containsProject(root) && root.getParent() instanceof DirectoryResource) {
            root = (DirectoryResource)root.getParent();
        }
        if (!locator.containsProject(root)) {
            root = null;
        }
        return root;
    }

    public Project findProjectRecursively(DirectoryResource startingPath) {
        ProjectLocator locator;
        DirectoryResource root;
        Project project = null;
        List<ProjectLocator> locators = this.getLocators();
        Iterator<ProjectLocator> iterator = locators.iterator();
        while (iterator.hasNext() && ((root = this.locateRecursively(startingPath, locator = iterator.next())) == null || !locator.containsProject(root) || (project = locator.createProject(root)) == null)) {
        }
        if (project != null) {
            this.registerFacets(project);
        }
        return project;
    }

    public Project createProject(DirectoryResource root, Class<? extends Facet> ... facetTypes) {
        Project project = null;
        List<ProjectLocator> locators = this.getLocators();
        for (ProjectLocator locator : locators) {
            if (root == null || (project = locator.createProject(root)) == null) continue;
            break;
        }
        if (project != null) {
            for (Class<? extends Facet> type : facetTypes) {
                this.installSingleFacet(project, type);
            }
            this.registerFacets(project);
        }
        return project;
    }

    public void installSingleFacet(Project project, Class<? extends Facet> type) {
        Facet facet = this.facetFactory.getFacet(type);
        List<Class<? extends Facet>> dependencies = ConstraintInspector.getFacetDependencies(type);
        if (dependencies != null) {
            for (Class<? extends Facet> dep : dependencies) {
                if (project.hasFacet(dep)) continue;
                this.installSingleFacet(project, dep);
            }
        }
        project.installFacet(facet);
    }

    private void registerFacets(Project project) {
        if (project != null) {
            Set<Class<? extends Facet>> facets = this.facetFactory.getFacetTypes();
            for (Class<? extends Facet> facet : facets) {
                this.registerSingleFacet(project, facet);
            }
        }
    }

    public void registerSingleFacet(Project project, Class<? extends Facet> type) {
        Facet facet = this.facetFactory.getFacet(type);
        this.registerSingleFacet(project, facet);
    }

    private void registerSingleFacet(Project project, Facet facet) {
        List<Class<? extends Facet>> dependencies = ConstraintInspector.getFacetDependencies(facet.getClass());
        if (dependencies != null) {
            for (Class<? extends Facet> dep : dependencies) {
                if (project.hasFacet(dep)) continue;
                Facet depFacet = this.facetFactory.getFacet(dep);
                this.registerSingleFacet(project, depFacet);
                if (project.hasFacet(dep)) continue;
                return;
            }
        }
        project.registerFacet(facet);
    }

    public boolean containsProject(DirectoryResource dir) {
        Project project = this.findProject(dir);
        return project != null;
    }

    public Project findProject(DirectoryResource dir) {
        Project project = null;
        if (dir != null) {
            List<ProjectLocator> locators = this.getLocators();
            for (ProjectLocator locator : locators) {
                if (!locator.containsProject(ResourceUtil.getContextDirectory(dir))) continue;
                project = locator.createProject(dir);
                break;
            }
            if (project != null) {
                this.registerFacets(project);
            }
        }
        return project;
    }

    private List<ProjectLocator> getLocators() {
        this.init();
        return this.locators;
    }
}

