/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import org.jboss.modules.ConcurrentClassLoader;

public class CompositeClassLoader
extends ConcurrentClassLoader {
    private final List<ConcurrentClassLoader> classLoaders = Collections.synchronizedList(new ArrayList());

    public void add(ConcurrentClassLoader loader) {
        if (loader != null && !this.classLoaders.contains(loader) && !((Object)((Object)this)).equals(loader)) {
            this.classLoaders.add(0, loader);
        }
    }

    protected List<ConcurrentClassLoader> getClassLoaders() {
        return Collections.unmodifiableList(this.classLoaders);
    }

    protected Class<?> findClass(String className, boolean exportsOnly, boolean resolve) throws ClassNotFoundException {
        for (ConcurrentClassLoader loader : this.classLoaders) {
            try {
                Class found = loader.loadClass(className, resolve);
                return found;
            }
            catch (ClassNotFoundException e) {
            }
        }
        throw new ClassNotFoundException(className);
    }

    protected URL findResource(String name, boolean exportsOnly) {
        for (ConcurrentClassLoader loader : this.classLoaders) {
            URL resource = loader.getResource(name);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    protected Enumeration<URL> findResources(String name, boolean exportsOnly) throws IOException {
        HashSet urls = new HashSet();
        for (ConcurrentClassLoader loader : this.classLoaders) {
            Enumeration resources = loader.getResources(name);
            while (resources.hasMoreElements()) {
                urls.add(resources.nextElement());
            }
        }
        return Collections.enumeration(urls);
    }

    protected InputStream findResourceAsStream(String name, boolean exportsOnly) {
        for (ConcurrentClassLoader loader : this.classLoaders) {
            InputStream stream = loader.getResourceAsStream(name);
            if (stream == null) continue;
            return stream;
        }
        return null;
    }

    public String toString() {
        return "CompositeClassLoader [classLoaders=" + this.classLoaders + "]";
    }
}

