/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.forge.ForgeEnvironment;
import org.jboss.forge.project.services.ResourceFactory;
import org.jboss.forge.resources.DirectoryResource;
import org.jboss.forge.resources.FileResource;
import org.jboss.forge.shell.util.OSUtils;

@ApplicationScoped
public class ForgeEnvironmentImpl
implements ForgeEnvironment {
    private final Map<String, Object> properties = new HashMap<String, Object>();
    @Inject
    private ResourceFactory resourceFactory;

    public String getRuntimeVersion() {
        String version = (String)this.getProperty("FORGE_VERSION");
        if (version == null) {
            version = this.getClass().getPackage().getImplementationVersion();
        }
        return version;
    }

    public DirectoryResource getPluginDirectory() {
        String pluginDir = System.getProperty("org.jboss.forge.pluginDir");
        File pluginDirFile = pluginDir == null ? new File(this.getProperty("FORGE_CONFIG_DIR").toString(), "plugins") : new File(pluginDir);
        FileResource resource = (FileResource)this.resourceFactory.getResourceFrom(pluginDirFile);
        if (!resource.exists()) {
            resource.mkdirs();
        }
        return (DirectoryResource)resource.reify(DirectoryResource.class);
    }

    public boolean isOnline() {
        Object offline = this.getProperty("OFFLINE");
        return offline == null ? true : !Boolean.parseBoolean(offline.toString());
    }

    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void removeProperty(String name) {
        this.properties.remove(name);
    }

    public DirectoryResource getConfigDirectory() {
        FileResource resource;
        String forgeConfigDir = (String)this.getProperty("FORGE_CONFIG_DIR");
        if (forgeConfigDir == null) {
            forgeConfigDir = System.getProperty("FORGE_CONFIG_DIR", OSUtils.getDefaultForgePath());
        }
        if (!(resource = (FileResource)this.resourceFactory.getResourceFrom(new File(forgeConfigDir))).exists() && !resource.mkdirs()) {
            System.err.println("could not create config directory: " + resource.getFullyQualifiedName());
        }
        return (DirectoryResource)resource.reify(DirectoryResource.class);
    }

    public FileResource<?> getUserConfiguration() {
        return (FileResource)this.getConfigDirectory().getChild("config.xml").reify(FileResource.class);
    }

    public DirectoryResource getForgeHome() {
        String forgeHome = System.getProperty("forge.home");
        return (DirectoryResource)this.resourceFactory.getResourceFrom(new File(forgeHome)).reify(DirectoryResource.class);
    }

    public boolean isEmbedded() {
        return Boolean.getBoolean("forge.compatibility.IDE");
    }
}

