/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.forge.parser.java.util.Assert;
import org.jboss.forge.parser.java.util.Strings;
import org.jboss.forge.parser.xml.Node;
import org.jboss.forge.parser.xml.XMLParser;
import org.jboss.forge.parser.xml.XMLParserException;
import org.jboss.forge.shell.PluginEntry;
import org.jboss.forge.shell.util.OSUtils;
import org.jboss.forge.shell.util.Streams;

public class InstalledPluginRegistry {
    private static final String DEFAULT_SLOT = "main";
    private static final String ATTR_SLOT = "slot";
    private static final String ATTR_API_VERSION = "api-version";
    private static final String ATTR_NAME = "name";
    private static final String PLUGIN_DIR_DEFAULT = "/.forge/plugins";
    private static final String REGISTRY_FILE = "/installed.xml";
    private static String PLUGIN_DIR = null;
    private static String REGISTRY = null;
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)(\\.|-)(.*)");

    private static String getPluginDir() {
        if (PLUGIN_DIR == null && (PLUGIN_DIR = System.getProperty("org.jboss.forge.pluginDir")) == null) {
            PLUGIN_DIR = OSUtils.getUserHomePath() + PLUGIN_DIR_DEFAULT;
        }
        return PLUGIN_DIR;
    }

    private static String getRegistry() {
        if (REGISTRY == null) {
            REGISTRY = InstalledPluginRegistry.getPluginDir() + REGISTRY_FILE;
        }
        return REGISTRY;
    }

    public static File getRegistryFile() {
        return new File(InstalledPluginRegistry.getRegistry());
    }

    public static List<PluginEntry> listByAPICompatibleVersion(String version) {
        List<PluginEntry> list;
        List<PluginEntry> result = list = InstalledPluginRegistry.list();
        if (version != null) {
            result = new ArrayList<PluginEntry>();
            for (PluginEntry entry : list) {
                if (!InstalledPluginRegistry.isApiCompatible((CharSequence)version, entry)) continue;
                result.add(entry);
            }
        }
        return result;
    }

    public static List<PluginEntry> list() {
        ArrayList<PluginEntry> result = new ArrayList<PluginEntry>();
        File registryFile = InstalledPluginRegistry.getRegistryFile();
        try {
            Node installed = XMLParser.parse((InputStream)new FileInputStream(registryFile));
            List list = installed.get("plugin");
            for (Node plugin : list) {
                PluginEntry entry = new PluginEntry(plugin.getAttribute(ATTR_NAME), plugin.getAttribute(ATTR_API_VERSION), plugin.getAttribute(ATTR_SLOT));
                result.add(entry);
            }
        }
        catch (XMLParserException e) {
            throw new RuntimeException("Invalid syntax in [" + registryFile.getAbsolutePath() + "] - Please delete this file and restart Forge", e);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PluginEntry install(String name, String apiVersion, String slot) {
        if (Strings.isNullOrEmpty((String)name)) {
            throw new RuntimeException("Plugin must not be null");
        }
        if (Strings.isNullOrEmpty((String)apiVersion)) {
            throw new RuntimeException("API version must not be null");
        }
        if (Strings.isNullOrEmpty((String)slot)) {
            slot = DEFAULT_SLOT;
        }
        List<PluginEntry> installedPlugins = InstalledPluginRegistry.list();
        for (PluginEntry e : installedPlugins) {
            if (!name.equals(e.getName())) continue;
            InstalledPluginRegistry.remove(e);
        }
        Node installed = null;
        File registryFile = InstalledPluginRegistry.getRegistryFile();
        try {
            block10: {
                block9: {
                    if (!registryFile.exists()) break block9;
                    FileInputStream in = null;
                    try {
                        in = new FileInputStream(registryFile);
                        installed = XMLParser.parse((InputStream)new BufferedInputStream(in));
                    }
                    catch (Throwable throwable) {
                        Streams.closeQuietly(in);
                        throw throwable;
                    }
                    Streams.closeQuietly((Closeable)in);
                    break block10;
                }
                registryFile.mkdirs();
                registryFile.delete();
                registryFile.createNewFile();
                installed = XMLParser.parse((String)"<installed></installed>");
            }
            installed.getOrCreate("plugin@name=" + name + "&" + ATTR_API_VERSION + "=" + apiVersion).attribute(ATTR_SLOT, slot);
            Streams.write((InputStream)XMLParser.toXMLInputStream((Node)installed), (OutputStream)new FileOutputStream(registryFile));
            return new PluginEntry(name, apiVersion, slot);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Could not read [" + registryFile.getAbsolutePath() + "] - ", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Error manipulating [" + registryFile.getAbsolutePath() + "] - ", e);
        }
    }

    public static void remove(PluginEntry plugin) {
        if (plugin == null) {
            throw new RuntimeException("Plugin must not be null");
        }
        File registryFile = InstalledPluginRegistry.getRegistryFile();
        if (registryFile.exists()) {
            try {
                Node installed = XMLParser.parse((InputStream)new FileInputStream(registryFile));
                Node child = installed.getSingle("plugin@name=" + plugin.getName() + "&" + ATTR_API_VERSION + "=" + plugin.getApiVersion());
                installed.removeChild(child);
                Streams.write((InputStream)XMLParser.toXMLInputStream((Node)installed), (OutputStream)new FileOutputStream(registryFile));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
    }

    public static PluginEntry get(PluginEntry plugin) {
        if (plugin == null) {
            throw new RuntimeException("Plugin must not be null");
        }
        File registryFile = InstalledPluginRegistry.getRegistryFile();
        if (registryFile.exists()) {
            try {
                Node installed = XMLParser.parse((InputStream)new FileInputStream(registryFile));
                List children = installed.get("plugin@name=" + plugin.getName());
                for (Node child : children) {
                    if (child == null || plugin.getApiVersion() != null && !plugin.getApiVersion().equals(child.getAttribute(ATTR_API_VERSION)) || plugin.getSlot() != null && !plugin.getSlot().equals(child.getAttribute(ATTR_SLOT))) continue;
                    return new PluginEntry(child.getAttribute(ATTR_NAME), child.getAttribute(ATTR_API_VERSION), child.getAttribute(ATTR_SLOT));
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean has(PluginEntry plugin) {
        return InstalledPluginRegistry.get(plugin) != null;
    }

    public static String getRuntimeAPIVersion() {
        return InstalledPluginRegistry.class.getPackage().getImplementationVersion();
    }

    public static boolean isApiCompatible(CharSequence runtimeVersion, PluginEntry entry) {
        Assert.notNull((Object)runtimeVersion, (String)"Runtime API version must not be null.");
        Assert.notNull((Object)entry, (String)"Plugin entry must not be null.");
        String pluginApiVersion = entry.getApiVersion();
        Assert.notNull((Object)pluginApiVersion, (String)"Plugin entry.getApiVersion() must not be null.");
        return InstalledPluginRegistry.isApiCompatible(runtimeVersion, pluginApiVersion);
    }

    public static boolean isApiCompatible(CharSequence runtimeVersion, String pluginApiVersion) {
        Matcher runtimeMatcher = VERSION_PATTERN.matcher(runtimeVersion);
        if (runtimeMatcher.matches()) {
            int runtimeMajorVersion = Integer.parseInt(runtimeMatcher.group(1));
            int runtimeMinorVersion = Integer.parseInt(runtimeMatcher.group(2));
            Matcher pluginApiMatcher = VERSION_PATTERN.matcher(pluginApiVersion);
            if (pluginApiMatcher.matches()) {
                int pluginApiMajorVersion = Integer.parseInt(pluginApiMatcher.group(1));
                int pluginApiMinorVersion = Integer.parseInt(pluginApiMatcher.group(2));
                if (pluginApiMajorVersion == runtimeMajorVersion && pluginApiMinorVersion <= runtimeMinorVersion) {
                    return true;
                }
            }
        }
        return false;
    }
}

