/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.plugins.builtin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jboss.forge.parser.JavaParser;
import org.jboss.forge.parser.java.JavaClass;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.facets.DependencyFacet;
import org.jboss.forge.project.facets.JavaSourceFacet;
import org.jboss.forge.project.facets.MetadataFacet;
import org.jboss.forge.project.facets.PackagingFacet;
import org.jboss.forge.project.facets.ResourceFacet;
import org.jboss.forge.project.facets.WebResourceFacet;
import org.jboss.forge.project.packaging.PackagingType;
import org.jboss.forge.project.services.ProjectAssociationProvider;
import org.jboss.forge.project.services.ProjectFactory;
import org.jboss.forge.project.services.ResourceFactory;
import org.jboss.forge.resources.DirectoryResource;
import org.jboss.forge.resources.FileResource;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.resources.ResourceException;
import org.jboss.forge.shell.PromptType;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.ShellMessages;
import org.jboss.forge.shell.ShellPrintWriter;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.DefaultCommand;
import org.jboss.forge.shell.plugins.Help;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.PipeOut;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.Topic;
import org.jboss.forge.shell.plugins.builtin.NewProjectPackagingTypeCompleter;
import org.jboss.forge.shell.util.Files;
import org.jboss.forge.shell.util.Packages;
import org.jboss.forge.shell.util.ResourceUtil;

@Alias(value="new-project")
@Topic(value="Project")
@Help(value="Create a new project in an empty directory.")
public class NewProjectPlugin
implements Plugin {
    @Inject
    private Shell shell;
    @Inject
    private ProjectFactory projectFactory;
    @Inject
    Instance<ProjectAssociationProvider> providers;
    @Inject
    private ResourceFactory factory;

    @DefaultCommand
    public void create(@Option(name="named", description="The name of the new project", required=true) String name, @Option(name="topLevelPackage", description="The top-level java package for the project [e.g: \"com.example.project\"] ", required=false, type=PromptType.JAVA_PACKAGE) String suggestedJavaPackage, @Option(name="type", description="The project type, defaults to .jar", required=false, completer=NewProjectPackagingTypeCompleter.class, defaultValue="JAR") PackagingType type, @Option(name="projectFolder", description="The folder in which to create this project [e.g: \"~/Desktop/...\"] ", required=false) Resource<?> projectFolder, @Option(name="createMain", description="Toggle creation of a simple Main() script in the root package, valid for jar projects only", required=false, defaultValue="false", flagOnly=true) boolean createMain, @Option(name="finalName", description="The final artifact name of the new project") String finalName, PipeOut out) throws IOException {
        DirectoryResource dir = null;
        String javaPackage = suggestedJavaPackage;
        if (!this.getValidPackagingTypes().contains(type)) {
            throw new RuntimeException("Unsupported packaging type: " + type);
        }
        if (javaPackage == null) {
            javaPackage = "com.example." + Packages.toValidPackageName((String)name);
        }
        boolean skipFolderPrompt = false;
        try {
            if (projectFolder instanceof FileResource) {
                if (!projectFolder.exists()) {
                    ((FileResource)projectFolder).mkdirs();
                    dir = (DirectoryResource)projectFolder.reify(DirectoryResource.class);
                    skipFolderPrompt = true;
                } else if (projectFolder instanceof DirectoryResource) {
                    dir = (DirectoryResource)projectFolder;
                    skipFolderPrompt = true;
                } else {
                    ShellMessages.error((ShellPrintWriter)out, (String)("File exists but is not a directory [" + projectFolder.getFullyQualifiedName() + "]"));
                }
            }
            if (dir == null) {
                dir = this.shell.getCurrentDirectory().getChildDirectory(name);
            }
        }
        catch (ResourceException e) {
            // empty catch block
        }
        if (!(skipFolderPrompt || !this.projectFactory.containsProject(dir) && this.shell.promptBoolean("Use [" + dir.getFullyQualifiedName() + "] as project directory?"))) {
            DirectoryResource newDir;
            if (this.projectFactory.containsProject(dir)) {
                ShellMessages.error((ShellPrintWriter)out, (String)("[" + dir.getFullyQualifiedName() + "] already contains a project; please use a different folder."));
            }
            dir = this.shell.getCurrentResource() == null ? ResourceUtil.getContextDirectory((Resource)this.factory.getResourceFrom(Files.getWorkingDirectory())) : this.shell.getCurrentDirectory();
            do {
                newDir = this.shell.getCurrentDirectory();
                this.shell.println();
                newDir = !this.projectFactory.containsProject((DirectoryResource)newDir.reify(DirectoryResource.class)) ? this.shell.promptFile("Where would you like to create the project? [Press ENTER to use the current directory: " + newDir + "]", (FileResource)dir) : this.shell.promptFile("Where would you like to create the project?");
                if (!newDir.exists()) {
                    newDir.mkdirs();
                    newDir = (FileResource)newDir.reify(DirectoryResource.class);
                    continue;
                }
                if (newDir.isDirectory() && !this.projectFactory.containsProject((DirectoryResource)newDir.reify(DirectoryResource.class))) {
                    newDir = (FileResource)newDir.reify(DirectoryResource.class);
                    continue;
                }
                ShellMessages.error((ShellPrintWriter)out, (String)("That folder already contains a project [" + newDir.getFullyQualifiedName() + "], please select a different location."));
                newDir = null;
            } while (newDir == null || !(newDir instanceof DirectoryResource));
            dir = newDir;
        }
        if (!dir.exists()) {
            dir.mkdirs();
        }
        Project project = null;
        project = type.equals((Object)PackagingType.JAR) || type.equals((Object)PackagingType.BUNDLE) ? this.projectFactory.createProject(dir, new Class[]{DependencyFacet.class, MetadataFacet.class, JavaSourceFacet.class, ResourceFacet.class}) : (type.equals((Object)PackagingType.WAR) ? this.projectFactory.createProject(dir, new Class[]{DependencyFacet.class, MetadataFacet.class, WebResourceFacet.class, JavaSourceFacet.class, ResourceFacet.class}) : this.projectFactory.createProject(dir, new Class[]{DependencyFacet.class, MetadataFacet.class}));
        DirectoryResource parentDir = (DirectoryResource)project.getProjectRoot().getParent().reify(DirectoryResource.class);
        if (parentDir != null) {
            for (ProjectAssociationProvider provider : this.providers) {
                if (!provider.canAssociate(project, parentDir) || !this.shell.promptBoolean("Add new project as a sub-project of [" + parentDir.getFullyQualifiedName() + "]?")) continue;
                provider.associate(project, parentDir);
            }
        }
        MetadataFacet meta = (MetadataFacet)project.getFacet(MetadataFacet.class);
        meta.setProjectName(name);
        meta.setTopLevelPackage(javaPackage);
        PackagingFacet packaging = (PackagingFacet)project.getFacet(PackagingFacet.class);
        packaging.setPackagingType(type);
        DependencyFacet deps = (DependencyFacet)project.getFacet(DependencyFacet.class);
        deps.addRepository(DependencyFacet.KnownRepository.JBOSS_NEXUS);
        if (packaging.getPackagingType().equals((Object)PackagingType.JAR) && createMain) {
            ((JavaSourceFacet)project.getFacet(JavaSourceFacet.class)).saveJavaSource((JavaSource)((JavaClass)((JavaClass)((JavaClass)JavaParser.create(JavaClass.class)).setPackage(javaPackage)).setName("Main")).addMethod("public static void main(String[] args) {}").setBody("System.out.println(\"Hi there! I was forged as part of the project you call " + name + ".\");").getOrigin());
        }
        if (project.hasFacet(JavaSourceFacet.class)) {
            DirectoryResource sourceFolder = ((JavaSourceFacet)project.getFacet(JavaSourceFacet.class)).getSourceFolder();
            this.createTopLevelPackage(sourceFolder, javaPackage);
        }
        if (finalName != null) {
            packaging.setFinalName(finalName);
        } else {
            packaging.setFinalName(name);
        }
        this.shell.setCurrentResource((Resource)project.getProjectRoot());
        ShellMessages.success((ShellPrintWriter)out, (String)("Created project [" + name + "] in new working directory [" + dir.getFullyQualifiedName() + "]"));
    }

    private List<PackagingType> getValidPackagingTypes() {
        ArrayList<PackagingType> validTypes = new ArrayList<PackagingType>();
        validTypes.add(PackagingType.BASIC);
        validTypes.add(PackagingType.JAR);
        validTypes.add(PackagingType.WAR);
        validTypes.add(PackagingType.EAR);
        validTypes.add(PackagingType.BUNDLE);
        return validTypes;
    }

    private DirectoryResource createTopLevelPackage(DirectoryResource sourceFolder, String javaPackage) {
        DirectoryResource directory = sourceFolder.getChildDirectory(Packages.toFileSyntax((String)javaPackage));
        directory.mkdirs();
        return directory;
    }
}

