/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.project;

import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.forge.project.BaseProject;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.facets.MetadataFacet;
import org.jboss.forge.project.services.ProjectFactory;
import org.jboss.forge.resources.DirectoryResource;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.events.InitProject;
import org.jboss.forge.shell.project.CurrentProject;

public class ProjectInitializer {
    private final Shell shell;
    private final CurrentProject cp;
    private final ProjectFactory projectFactory;

    @Inject
    public ProjectInitializer(Shell shell, CurrentProject currentProjectHolder, ProjectFactory projectFactory) {
        this.shell = shell;
        this.cp = currentProjectHolder;
        this.projectFactory = projectFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doInit(@Observes InitProject event) {
        DirectoryResource currentDirectory = this.shell.getCurrentDirectory();
        Project newProject = null;
        try {
            final DirectoryResource newRoot = this.projectFactory.findProjectRootRecusively(currentDirectory);
            if (newRoot != null) {
                DirectoryResource oldProjectRoot;
                Project oldProject = this.cp.getCurrent();
                BaseProject temp = new BaseProject(){

                    public DirectoryResource getProjectRoot() {
                        return newRoot;
                    }

                    public boolean exists() {
                        return false;
                    }
                };
                this.cp.setCurrentProject((Project)temp);
                newProject = oldProject != null ? (!newRoot.equals((Object)(oldProjectRoot = oldProject.getProjectRoot())) ? this.projectFactory.findProjectRecursively(currentDirectory) : oldProject) : this.projectFactory.findProjectRecursively(currentDirectory);
            }
            if (newProject != null) {
                this.shell.getEnvironment().setProperty("PROJECT_NAME", (Object)((MetadataFacet)newProject.getFacet(MetadataFacet.class)).getProjectName());
            }
        }
        finally {
            this.cp.setCurrentProject(newProject);
        }
    }
}

