/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.command.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.forge.shell.command.OptionMetadata;

public class CommandParserContext {
    private boolean completing = false;
    private int paramCount;
    private final Map<OptionMetadata, Object> valueMap = new HashMap<OptionMetadata, Object>();
    private OptionMetadata lastParsed;
    private String lastParsedToken;
    private final List<String> warnings = new ArrayList<String>();
    private final List<String> ignoredTokens = new ArrayList<String>();
    private boolean finalTokenComplete = false;

    public void incrementParmCount() {
        ++this.paramCount;
    }

    public void addWarning(String message) {
        if (!this.warnings.contains(message)) {
            this.warnings.add(message);
        }
    }

    public void addIgnoredToken(String token) {
        this.ignoredTokens.add(token);
    }

    public int getParamCount() {
        return this.paramCount;
    }

    public String toString() {
        return "CommandParserContext [paramCount=" + this.paramCount + "]";
    }

    public Map<OptionMetadata, Object> getValueMap() {
        return Collections.unmodifiableMap(this.valueMap);
    }

    public List<String> getWarnings() {
        return Collections.unmodifiableList(this.warnings);
    }

    public List<String> getIgnoredTokens() {
        return Collections.unmodifiableList(this.ignoredTokens);
    }

    public int getOrderedParamCount() {
        int result = 0;
        for (OptionMetadata option : this.valueMap.keySet()) {
            if (!option.isOrdered()) continue;
            ++result;
        }
        return result;
    }

    public void put(OptionMetadata option, Object value, String rawValue) {
        this.lastParsed = option;
        this.valueMap.put(option, value);
        this.lastParsedToken = rawValue;
    }

    public OptionMetadata getLastParsed() {
        return this.lastParsed;
    }

    public boolean isLastOptionValued() {
        return this.lastParsed != null && this.valueMap.get(this.lastParsed) != null;
    }

    public boolean isEmpty() {
        return this.valueMap.isEmpty();
    }

    public String getLastParsedToken() {
        return this.lastParsedToken;
    }

    public void setCompleting(boolean completing) {
        this.completing = completing;
    }

    public boolean isCompleting() {
        return this.completing;
    }

    public void setFinalTokenComplete(boolean finalTokenComplete) {
        this.finalTokenComplete = finalTokenComplete;
    }

    public boolean isTokenComplete() {
        return this.finalTokenComplete;
    }
}

