/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.completer;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.facets.JavaSourceFacet;
import org.jboss.forge.project.services.ResourceFactory;
import org.jboss.forge.resources.DirectoryResource;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.resources.ResourceFilter;
import org.jboss.forge.resources.ResourceFlag;
import org.jboss.forge.resources.java.JavaResource;
import org.jboss.forge.shell.PromptType;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.command.OptionMetadata;
import org.jboss.forge.shell.command.parser.CommandParserContext;
import org.jboss.forge.shell.completer.CommandCompleter;
import org.jboss.forge.shell.completer.CommandCompleterState;
import org.jboss.forge.shell.completer.EnumCompleter;
import org.jboss.forge.shell.completer.PluginCommandCompleterState;
import org.jboss.forge.shell.util.BeanManagerUtils;
import org.jboss.forge.shell.util.JavaPathspecParser;
import org.jboss.forge.shell.util.OSUtils;
import org.jboss.forge.shell.util.PathspecParser;

public class OptionValueResolverCompleter
implements CommandCompleter {
    @Inject
    private Shell shell;
    @Inject
    private BeanManager manager;
    @Inject
    private ResourceFactory resourceFactory;

    public void complete(CommandCompleterState st) {
        CommandParserContext commandContext;
        Map<OptionMetadata, Object> valueMap;
        PluginCommandCompleterState state = (PluginCommandCompleterState)st;
        OptionMetadata option = state.getOption();
        if (option != null && state.getCommandContext() != null && ((valueMap = (commandContext = state.getCommandContext()).getValueMap()).isEmpty() || valueMap.containsKey(option))) {
            if (option.hasCustomCompleter()) {
                CommandCompleter completer = (CommandCompleter)BeanManagerUtils.getContextualInstance((BeanManager)this.manager, (Class)option.getCompleterType());
                if (completer == null) {
                    throw new RuntimeException("Could not instantiate completer of type: " + option.getCompleterType().getName() + ", completers must be valid CDI beans (public top-level classes.)");
                }
                completer.complete((CommandCompleterState)state);
            } else if (option.isEnum()) {
                EnumCompleter completer = new EnumCompleter(option.getType());
                completer.complete(state);
            } else if (this.isJavaResourceAssignable(option)) {
                this.completeJavaPaths(state, option, valueMap, new ResourceFilter(){

                    public boolean accept(Resource<?> resource) {
                        return resource instanceof DirectoryResource || resource instanceof JavaResource;
                    }
                });
            } else if (this.isJavaPackageAssignable(option)) {
                this.completeJavaPaths(state, option, valueMap, new ResourceFilter(){

                    public boolean accept(Resource<?> resource) {
                        return resource instanceof DirectoryResource;
                    }
                });
            } else if (this.isFileResourceAssignable(option)) {
                this.completeFilenames(state, option, valueMap);
            }
        }
    }

    private void completeJavaPaths(PluginCommandCompleterState state, OptionMetadata option, Map<OptionMetadata, Object> valueMap, ResourceFilter filter) {
        Project project = this.shell.getCurrentProject();
        if (project != null && project.hasFacet(JavaSourceFacet.class)) {
            ArrayList<String> results = new ArrayList<String>();
            String[] values = valueMap.isEmpty() ? new String[]{""} : (valueMap.get(option) instanceof String[] ? (String[])valueMap.get(option) : (valueMap.get(option) == null ? new String[]{""} : new String[]{String.valueOf(valueMap.get(option))}));
            String val = values[values.length - 1];
            for (Resource r : new JavaPathspecParser((JavaSourceFacet)project.getFacet(JavaSourceFacet.class), val + "*").resolve(filter)) {
                String name = ("~".equals(val) ? "~." : "") + r.getName() + (r.isFlagSet(ResourceFlag.Node) && !r.listResources(filter).isEmpty() ? "." : "");
                results.add(name);
            }
            int lastNest = val.lastIndexOf(".");
            state.setIndex(state.getOriginalIndex() - val.length() + (lastNest != -1 ? lastNest + 1 : 0));
            state.getCandidates().addAll(results);
        }
    }

    private boolean isJavaPackageAssignable(OptionMetadata option) {
        return PromptType.JAVA_PACKAGE.equals((Object)option.getPromptType());
    }

    private boolean isJavaResourceAssignable(OptionMetadata option) {
        return JavaResource[].class.isAssignableFrom(option.getBoxedType()) || JavaResource.class.isAssignableFrom(option.getBoxedType()) || PromptType.JAVA_CLASS.equals((Object)option.getPromptType());
    }

    private void completeFilenames(PluginCommandCompleterState state, OptionMetadata option, Map<OptionMetadata, Object> valueMap) {
        ArrayList<String> results = new ArrayList<String>();
        String[] values = valueMap.isEmpty() ? new String[]{""} : (valueMap.get(option) instanceof String[] ? (String[])valueMap.get(option) : (valueMap.get(option) == null ? new String[]{""} : new String[]{String.valueOf(valueMap.get(option))}));
        String val = values[values.length - 1];
        for (Resource r : new PathspecParser(this.resourceFactory, this.shell.getCurrentResource(), val + "*").resolve()) {
            String name = ("~".equals(val) ? "~" + File.separator : "") + r.getName() + (r.isFlagSet(ResourceFlag.Node) ? File.separator : "");
            results.add(name);
        }
        int lastForwardSlash = val.lastIndexOf(47);
        int lastBackslash = OSUtils.isWindows() ? val.lastIndexOf(92) : -1;
        int lastNest = Math.max(lastForwardSlash, lastBackslash);
        state.setIndex(state.getOriginalIndex() - val.length() + (lastNest != -1 ? lastNest + 1 : 0));
        state.getCandidates().addAll(results);
    }

    private boolean isFileResourceAssignable(OptionMetadata option) {
        return Resource[].class.isAssignableFrom(option.getBoxedType()) || Resource.class.isAssignableFrom(option.getBoxedType());
    }
}

