/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.console.jline.console;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import org.fusesource.jansi.AnsiOutputStream;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.console.jline.Terminal;
import org.jboss.forge.shell.console.jline.console.CursorBuffer;
import org.jboss.forge.shell.console.jline.console.Operation;
import org.jboss.forge.shell.console.jline.console.completer.CandidateListCompletionHandler;
import org.jboss.forge.shell.console.jline.console.completer.Completer;
import org.jboss.forge.shell.console.jline.console.completer.CompletionHandler;
import org.jboss.forge.shell.console.jline.console.history.History;
import org.jboss.forge.shell.console.jline.console.history.MemoryHistory;
import org.jboss.forge.shell.console.jline.internal.Configuration;
import org.jboss.forge.shell.console.jline.internal.Log;
import org.jboss.forge.shell.integration.BufferManager;
import org.jboss.forge.shell.integration.KeyListener;

public class ConsoleReader {
    public static final String JLINE_NOBELL = "jline.nobell";
    public static final char BACKSPACE = '\b';
    public static final char RESET_LINE = '\r';
    public static final char KEYBOARD_BELL = '\u0007';
    public static final char NULL_MASK = '\u0000';
    public static final int TAB_WIDTH = 4;
    private static final ResourceBundle resources = ResourceBundle.getBundle(CandidateListCompletionHandler.class.getName());
    private final Terminal terminal;
    private InputStream in;
    private final Shell shell;
    private final CursorBuffer buf = new CursorBuffer();
    private String prompt;
    private boolean bellEnabled = true;
    private Character mask;
    private char echoCharacter;
    private StringBuffer searchTerm = null;
    private String previousSearchTerm = "";
    private int searchIndex = -1;
    private final List<KeyListener> keyListeners = new ArrayList<KeyListener>();
    public static final String JLINE_COMPLETION_THRESHOLD = "jline.completion.threshold";
    public static final String JLINE_KEYBINDINGS = "jline.keybindings";
    public static final String JLINEBINDINGS_PROPERTIES = ".jlinebindings.properties";
    private final short[] keyBindings;
    private final List<Completer> completers = new LinkedList<Completer>();
    private CompletionHandler completionHandler = new CandidateListCompletionHandler();
    private int autoprintThreshold = Integer.getInteger("jline.completion.threshold", 100);
    private boolean paginationEnabled;
    private History history = new MemoryHistory();
    private boolean historyEnabled = true;
    public static final String CR = System.getProperty("line.separator");
    private final Map<Character, ActionListener> triggeredActions = new HashMap<Character, ActionListener>();
    private Thread maskThread;
    private static final String ESCAPE_STR = new String(new char[]{'\u001b', '['});

    public ConsoleReader(InputStream in, Shell shell, InputStream bindings, Terminal term) throws IOException {
        this.in = in;
        this.shell = shell;
        this.terminal = term;
        this.keyBindings = this.loadKeyBindings(bindings);
        this.setBellEnabled(Configuration.getBoolean(JLINE_NOBELL, false) == false);
    }

    public ConsoleReader(InputStream in, Shell shell, Terminal term) throws IOException {
        this(in, shell, null, term);
    }

    void setInput(InputStream in) {
        this.in = in;
    }

    public void registerKeyListener(KeyListener keyListener) {
        this.keyListeners.add(keyListener);
    }

    public InputStream getInput() {
        return this.in;
    }

    public Shell getShell() {
        return this.shell;
    }

    public Terminal getTerminal() {
        return this.terminal;
    }

    public CursorBuffer getCursorBuffer() {
        return this.buf;
    }

    public void setBellEnabled(boolean enabled) {
        this.bellEnabled = enabled;
    }

    public boolean isBellEnabled() {
        return this.bellEnabled;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public void setEchoCharacter(Character c) {
        this.echoCharacter = c.charValue();
    }

    public Character getEchoCharacter() {
        return Character.valueOf(this.echoCharacter);
    }

    final boolean resetLine() throws IOException {
        if (this.buf.cursor == 0) {
            return false;
        }
        this.backspaceAll();
        return true;
    }

    int getCursorPosition() {
        String prompt = this.getPrompt();
        return (prompt == null ? 0 : this.stripAnsi(this.lastLine(prompt)).length()) + this.buf.cursor;
    }

    private String lastLine(String str) {
        if (str == null) {
            return "";
        }
        int last = str.lastIndexOf("\n");
        if (last >= 0) {
            return str.substring(last + 1, str.length());
        }
        return str;
    }

    private String stripAnsi(String str) {
        if (str == null) {
            return "";
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            AnsiOutputStream aos = new AnsiOutputStream((OutputStream)baos);
            aos.write(str.getBytes());
            aos.flush();
            aos.close();
            return baos.toString();
        }
        catch (IOException e) {
            return str;
        }
    }

    public final boolean setCursorPosition(int position) throws IOException {
        return this.moveCursor(position - this.buf.cursor) != 0;
    }

    private void setBuffer(String buffer) throws IOException {
        if (buffer.equals(this.buf.buffer.toString())) {
            return;
        }
        int sameIndex = 0;
        int l1 = buffer.length();
        int l2 = this.buf.buffer.length();
        for (int i = 0; i < l1 && i < l2 && buffer.charAt(i) == this.buf.buffer.charAt(i); ++i) {
            ++sameIndex;
        }
        int diff = this.buf.cursor - sameIndex;
        if (diff < 0) {
            this.moveToEnd();
            diff = this.buf.buffer.length() - sameIndex;
        }
        this.backspace(diff);
        this.killLine();
        this.buf.buffer.setLength(sameIndex);
        this.putString(buffer.substring(sameIndex));
    }

    private void setBuffer(CharSequence buffer) throws IOException {
        this.setBuffer(String.valueOf(buffer));
    }

    public final void drawLine() throws IOException {
        String prompt = this.getPrompt();
        if (prompt != null) {
            this.print(prompt);
        }
        this.print(this.buf.buffer.toString());
        if (this.buf.length() != this.buf.cursor) {
            this.back(this.buf.length() - this.buf.cursor - 1);
        }
    }

    public final void redrawLine() throws IOException {
        this.print('\r');
        this.drawLine();
    }

    final String finishBuffer() throws IOException {
        String str = this.buf.buffer.toString();
        if ((str = this.expandEvents(str)).length() > 0) {
            if (this.mask == null && this.isHistoryEnabled()) {
                this.history.add(str);
            } else {
                this.mask = null;
            }
        }
        this.history.moveToEnd();
        this.buf.buffer.setLength(0);
        this.buf.cursor = 0;
        return str;
    }

    final String expandEvents(String str) throws IOException {
        StringBuilder sb = new StringBuilder();
        block14: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '!': {
                    if (i + 1 < str.length()) {
                        c = str.charAt(++i);
                        boolean neg = false;
                        String rep = null;
                        switch (c) {
                            case '!': {
                                if (this.history.size() == 0) {
                                    throw new IllegalArgumentException("!!: event not found");
                                }
                                rep = ((Object)this.history.get(this.history.index() - 1)).toString();
                                break;
                            }
                            case '#': {
                                sb.append(sb.toString());
                                break;
                            }
                            case '?': {
                                int i1 = str.indexOf(63, i + 1);
                                if (i1 < 0) {
                                    i1 = str.length();
                                }
                                String sc = str.substring(i + 1, i1);
                                i = i1;
                                int idx = this.searchBackwards(sc);
                                if (idx < 0) {
                                    throw new IllegalArgumentException("!?" + sc + ": event not found");
                                }
                                rep = ((Object)this.history.get(idx)).toString();
                                break;
                            }
                            case '\t': 
                            case ' ': {
                                sb.append('!');
                                sb.append(c);
                                break;
                            }
                            case '-': {
                                neg = true;
                            }
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                int i1 = ++i;
                                while (i < str.length() && (c = str.charAt(i)) >= '0' && c <= '9') {
                                    ++i;
                                }
                                int idx = 0;
                                try {
                                    idx = Integer.parseInt(str.substring(i1, i));
                                }
                                catch (NumberFormatException e) {
                                    throw new IllegalArgumentException((neg ? "!-" : "!") + str.substring(i1, i) + ": event not found");
                                }
                                if (neg) {
                                    if (idx < this.history.size()) {
                                        rep = ((Object)this.history.get(this.history.index() - idx)).toString();
                                        break;
                                    }
                                    throw new IllegalArgumentException((neg ? "!-" : "!") + str.substring(i1, i) + ": event not found");
                                }
                                if (idx >= this.history.index() - this.history.size() && idx < this.history.index()) {
                                    rep = ((Object)this.history.get(idx)).toString();
                                    break;
                                }
                                throw new IllegalArgumentException((neg ? "!-" : "!") + str.substring(i1, i) + ": event not found");
                            }
                            default: {
                                String ss = str.substring(i);
                                i = str.length();
                                int idx = this.searchBackwards(ss, this.history.index(), true);
                                if (idx < 0) {
                                    throw new IllegalArgumentException("!" + ss + ": event not found");
                                }
                                rep = ((Object)this.history.get(idx)).toString();
                            }
                        }
                        if (rep == null) continue block14;
                        sb.append(rep);
                        continue block14;
                    }
                    sb.append(c);
                    continue block14;
                }
                case '^': {
                    if (i == 0) {
                        int i1 = str.indexOf(94, i + 1);
                        int i2 = str.indexOf(94, i1 + 1);
                        if (i2 < 0) {
                            i2 = str.length();
                        }
                        if (i1 > 0 && i2 > 0) {
                            String s1 = str.substring(i + 1, i1);
                            String s2 = str.substring(i1 + 1, i2);
                            String s = ((Object)this.history.get(this.history.index() - 1)).toString().replace(s1, s2);
                            sb.append(s);
                            i = i2 + 1;
                            continue block14;
                        }
                    }
                    sb.append(c);
                    continue block14;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        String result = sb.toString();
        if (!str.equals(result)) {
            this.print(result);
            this.println();
            this.flush();
        }
        return result;
    }

    private final void newlineAtWrap() throws IOException {
        int width = this.getTerminal().getWidth();
        if (this.getCursorPosition() % width == 0 && this.getCurrentPosition() >= width) {
            this.println();
        }
    }

    public final void putString(CharSequence str) throws IOException {
        this.buf.write(str);
        this.print(str);
        this.drawBuffer();
        this.newlineAtWrap();
    }

    private void putChar(int c, boolean print) throws IOException {
        this.buf.write((char)c);
        if (print) {
            if (this.mask == null) {
                this.print(c);
            } else if (this.mask.charValue() != '\u0000') {
                this.print(this.mask.charValue());
            }
            this.drawBuffer();
            this.newlineAtWrap();
        }
    }

    private void drawBuffer(int clear) throws IOException {
        if (this.buf.cursor == this.buf.length() && clear == 0) {
            return;
        }
        byte[] chars = this.buf.buffer.substring(this.buf.cursor).getBytes();
        if (this.mask != null) {
            Arrays.fill(chars, (byte)this.mask.charValue());
        }
        this.print(chars);
        this.clearAhead(clear);
        if (this.terminal.isAnsiSupported()) {
            if (chars.length > 0) {
                this.back(Math.max(chars.length - 1, 1));
            }
        } else {
            this.back(chars.length);
        }
    }

    private void drawBuffer() throws IOException {
        this.drawBuffer(0);
    }

    private void clearAhead(int num) throws IOException {
        if (num == 0) {
            return;
        }
        if (this.terminal.isAnsiSupported()) {
            this.printAnsiSequence("K");
            return;
        }
        this.print((byte)32, num);
        this.back(num);
    }

    private void back(int num) throws IOException {
        if (num == 0) {
            return;
        }
        if (this.terminal.isAnsiSupported()) {
            int width = this.getTerminal().getWidth();
            int cursor = this.getCursorPosition();
            int currRow = (cursor + num) / width;
            int newRow = cursor / width;
            int newCol = cursor % width + 1;
            if (newRow < currRow) {
                this.printAnsiSequence(currRow - newRow + "A");
            }
            this.printAnsiSequence(newCol + "G");
            return;
        }
        this.print('\b', num);
    }

    public void flush() throws IOException {
        this.shell.flush();
    }

    private int backspaceAll() throws IOException {
        return this.backspace(Integer.MAX_VALUE);
    }

    private int backspace(int num) throws IOException {
        if (this.buf.cursor == 0) {
            return 0;
        }
        int count = 0;
        int termwidth = this.getTerminal().getWidth();
        int lines = this.getCursorPosition() / termwidth;
        count = this.moveCursor(-1 * num) * -1;
        this.buf.buffer.delete(this.buf.cursor, this.buf.cursor + count);
        if (this.getCursorPosition() / termwidth != lines && this.terminal.isAnsiSupported()) {
            this.printAnsiSequence("K");
        }
        this.drawBuffer(count);
        return count;
    }

    public boolean backspace() throws IOException {
        return this.backspace(1) == 1;
    }

    private boolean moveToEnd() throws IOException {
        return this.moveCursor(this.buf.length() - this.buf.cursor) > 0;
    }

    private boolean deleteCurrentCharacter() throws IOException {
        if (this.buf.length() == 0 || this.buf.cursor == this.buf.length()) {
            return false;
        }
        this.buf.buffer.deleteCharAt(this.buf.cursor);
        this.drawBuffer(1);
        return true;
    }

    private boolean previousWord() throws IOException {
        while (this.isDelimiter(this.buf.current()) && this.moveCursor(-1) != 0) {
        }
        while (!this.isDelimiter(this.buf.current()) && this.moveCursor(-1) != 0) {
        }
        return true;
    }

    private boolean nextWord() throws IOException {
        while (this.isDelimiter(this.buf.current()) && this.moveCursor(1) != 0) {
        }
        while (!this.isDelimiter(this.buf.current()) && this.moveCursor(1) != 0) {
        }
        return true;
    }

    private boolean deletePreviousWord() throws IOException {
        while (this.isDelimiter(this.buf.current()) && this.backspace()) {
        }
        while (!this.isDelimiter(this.buf.current()) && this.backspace()) {
        }
        return true;
    }

    public int moveCursor(int num) throws IOException {
        int where = num;
        if (this.buf.cursor == 0 && where <= 0) {
            return 0;
        }
        if (this.buf.cursor == this.buf.buffer.length() && where >= 0) {
            return 0;
        }
        if (this.buf.cursor + where < 0) {
            where = -this.buf.cursor;
        } else if (this.buf.cursor + where > this.buf.buffer.length()) {
            where = this.buf.buffer.length() - this.buf.cursor;
        }
        this.moveInternal(where);
        return where;
    }

    private void moveInternal(int where) throws IOException {
        this.buf.cursor += where;
        if (this.terminal.isAnsiSupported()) {
            if (where < 0) {
                this.back(Math.abs(where));
            } else {
                int oldLine;
                int width = this.getTerminal().getWidth();
                int cursor = this.getCursorPosition();
                int newLine = cursor / width;
                if (newLine > (oldLine = (cursor - where) / width)) {
                    this.printAnsiSequence(newLine - oldLine + "B");
                }
                this.printAnsiSequence(1 + cursor % width + "G");
            }
            return;
        }
        if (where < 0) {
            int len = 0;
            for (int i = this.buf.cursor; i < this.buf.cursor - where; ++i) {
                if (this.buf.buffer.charAt(i) == '\t') {
                    len += 4;
                    continue;
                }
                ++len;
            }
            char[] chars = new char[len];
            Arrays.fill(chars, '\b');
            this.shell.print(new String(chars));
            return;
        }
        if (this.buf.cursor == 0) {
            return;
        }
        if (this.mask == null) {
            this.print(this.buf.buffer.substring(this.buf.cursor - where, this.buf.cursor).getBytes());
            return;
        }
        char c = this.mask.charValue();
        if (this.mask.charValue() == '\u0000') {
            return;
        }
        this.print(c, Math.abs(where));
    }

    public final boolean replace(int num, String replacement) {
        this.buf.buffer.replace(this.buf.cursor - num, this.buf.cursor, replacement);
        try {
            this.moveCursor(-num);
            this.drawBuffer(Math.max(0, num - replacement.length()));
            this.moveCursor(replacement.length());
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public final int readVirtualKey() throws IOException {
        int c = this.terminal.readVirtualKey(this.in);
        Log.trace("Keystroke: ", c);
        this.clearEcho(c);
        return c;
    }

    private int clearEcho(int c) throws IOException {
        if (!this.terminal.isEchoEnabled()) {
            return 0;
        }
        int num = this.countEchoCharacters((char)c);
        this.back(num);
        this.drawBuffer(num);
        return num;
    }

    private int countEchoCharacters(char c) {
        if (c == '\t') {
            int tabStop = 8;
            int position = this.getCursorPosition();
            return tabStop - position % tabStop;
        }
        return this.getPrintableCharacters(c).length();
    }

    private StringBuilder getPrintableCharacters(char ch) {
        StringBuilder sbuff = new StringBuilder();
        if (ch >= ' ') {
            if (ch < '\u007f') {
                sbuff.append(ch);
            } else if (ch == '\u007f') {
                sbuff.append('^');
                sbuff.append('?');
            } else {
                sbuff.append('M');
                sbuff.append('-');
                if (ch >= '\u00a0') {
                    if (ch < '\u00ff') {
                        sbuff.append((char)(ch - 128));
                    } else {
                        sbuff.append('^');
                        sbuff.append('?');
                    }
                } else {
                    sbuff.append('^');
                    sbuff.append((char)(ch - 128 + 64));
                }
            }
        } else {
            sbuff.append('^');
            sbuff.append((char)(ch + 64));
        }
        return sbuff;
    }

    public final int readCharacter(char ... allowed) throws IOException {
        char c;
        Arrays.sort(allowed);
        while (Arrays.binarySearch(allowed, c = (char)this.readVirtualKey()) < 0) {
        }
        return c;
    }

    private short[] loadKeyBindings(InputStream input) throws IOException {
        if (input == null) {
            try {
                File file = new File(Configuration.getUserHome(), JLINEBINDINGS_PROPERTIES);
                String path = Configuration.getString(JLINE_KEYBINDINGS);
                if (path != null) {
                    file = new File(path);
                }
                if (file.isFile()) {
                    Log.debug("Loading user bindings from: ", file);
                    input = new FileInputStream(file);
                }
            }
            catch (Exception e) {
                Log.error("Failed to load user bindings", e);
            }
        }
        short[] keyBindings = new short[131070];
        Arrays.fill(keyBindings, Operation.UNKNOWN.code);
        if (input == null) {
            Log.debug("Using default bindings");
            ResourceBundle bundle = this.getTerminal().getDefaultBindings();
            if (bundle == null) {
                throw new RuntimeException("failed to load default keybidings");
            }
            this.loadMappingsFromBundle(keyBindings, bundle);
            return keyBindings;
        }
        input = new BufferedInputStream(input);
        Properties p = new Properties();
        p.load(input);
        input.close();
        for (Object key : p.keySet()) {
            String val = (String)key;
            try {
                short code = Short.parseShort(val);
                String name = p.getProperty(val);
                Operation op = Operation.valueOf(name);
                keyBindings[code] = op.code;
            }
            catch (NumberFormatException e) {
                Log.error("Failed to convert binding code: ", val, e);
            }
        }
        return keyBindings;
    }

    private void loadMappingsFromBundle(short[] keyBindings, ResourceBundle bundle) {
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            String val = keys.nextElement();
            try {
                short code = Short.parseShort(val);
                String name = bundle.getString(val);
                Operation op = Operation.valueOf(name);
                keyBindings[code] = op.code;
            }
            catch (NumberFormatException e) {
                Log.error("Failed to convert binding code: ", val, e);
            }
        }
    }

    int getKeyForAction(short logicalAction) {
        for (int i = 0; i < this.keyBindings.length; ++i) {
            if (this.keyBindings[i] != logicalAction) continue;
            return i;
        }
        return -1;
    }

    int getKeyForAction(Operation op) {
        assert (op != null);
        return this.getKeyForAction(op.code);
    }

    private int[] readBinding() throws IOException {
        int c = this.readVirtualKey();
        for (KeyListener listener : this.keyListeners) {
            if (!listener.keyPress(c)) continue;
            return null;
        }
        if (c == -1) {
            return null;
        }
        int code = this.keyBindings[c];
        Log.trace("Translated: ", c, " -> ", (short)code);
        return new int[]{c, code};
    }

    public String readLine() throws IOException {
        return this.readLine((String)null);
    }

    public String readLine(Character mask) throws IOException {
        return this.readLine(null, mask);
    }

    public String readLine(String prompt) throws IOException {
        return this.readLine(prompt, null);
    }

    public String readLine(String prompt, Character mask) throws IOException {
        this.mask = mask;
        if (prompt != null) {
            this.setPrompt(prompt);
        } else {
            prompt = this.getPrompt();
        }
        try {
            if (!this.terminal.isSupported()) {
                this.beforeReadLine(prompt, mask);
            }
            if (prompt != null && prompt.length() > 0) {
                this.shell.print(prompt);
                this.shell.flush();
            }
            if (!this.terminal.isSupported()) {
                String string = this.readLine(this.in);
                return string;
            }
            String originalPrompt = this.prompt;
            boolean NORMAL = true;
            int SEARCH = 2;
            int state = 1;
            boolean success = true;
            while (true) {
                int[] next;
                if ((next = this.readBinding()) == null) {
                    String string = null;
                    return string;
                }
                int c = next[0];
                Operation code = Operation.valueOf(next[1]);
                if (c == -1) {
                    String string = null;
                    return string;
                }
                if (state == 2) {
                    int cursorDest = -1;
                    switch (code) {
                        case ABORT: {
                            state = 1;
                            break;
                        }
                        case SEARCH_PREV: {
                            if (this.searchTerm.length() == 0) {
                                this.searchTerm.append(this.previousSearchTerm);
                            }
                            if (this.searchIndex == -1) {
                                this.searchIndex = this.searchBackwards(this.searchTerm.toString());
                                break;
                            }
                            this.searchIndex = this.searchBackwards(this.searchTerm.toString(), this.searchIndex);
                            break;
                        }
                        case DELETE_PREV_CHAR: {
                            if (this.searchTerm.length() <= 0) break;
                            this.searchTerm.deleteCharAt(this.searchTerm.length() - 1);
                            this.searchIndex = this.searchBackwards(this.searchTerm.toString());
                            break;
                        }
                        case UNKNOWN: {
                            this.searchTerm.appendCodePoint(c);
                            this.searchIndex = this.searchBackwards(this.searchTerm.toString());
                            break;
                        }
                        default: {
                            if (this.searchIndex != -1) {
                                this.history.moveTo(this.searchIndex);
                                cursorDest = ((Object)this.history.current()).toString().indexOf(this.searchTerm.toString());
                            }
                            state = 1;
                        }
                    }
                    if (state == 2) {
                        if (this.searchTerm.length() == 0) {
                            this.printSearchStatus("", "");
                            this.searchIndex = -1;
                        } else if (this.searchIndex == -1) {
                            this.beep();
                        } else {
                            this.printSearchStatus(this.searchTerm.toString(), ((Object)this.history.get(this.searchIndex)).toString());
                        }
                    } else {
                        this.restoreLine(originalPrompt, cursorDest);
                    }
                }
                if (state != 1) continue;
                switch (code) {
                    case EXIT: {
                        if (this.buf.buffer.length() == 0) {
                            String cursorDest = null;
                            return cursorDest;
                        }
                        this.deleteCurrentCharacter();
                        break;
                    }
                    case COMPLETE: {
                        success = this.complete();
                        break;
                    }
                    case MOVE_TO_BEG: {
                        success = this.setCursorPosition(0);
                        break;
                    }
                    case KILL_LINE: {
                        success = this.killLine();
                        break;
                    }
                    case CLEAR_SCREEN: {
                        success = this.clearScreen();
                        break;
                    }
                    case KILL_LINE_PREV: {
                        success = this.resetLine();
                        break;
                    }
                    case NEWLINE: {
                        this.moveToEnd();
                        String cursorDest = this.finishBuffer();
                        return cursorDest;
                    }
                    case DELETE_PREV_CHAR: {
                        success = this.backspace();
                        break;
                    }
                    case DELETE_NEXT_CHAR: {
                        success = this.deleteCurrentCharacter();
                        break;
                    }
                    case MOVE_TO_END: {
                        success = this.moveToEnd();
                        break;
                    }
                    case PREV_CHAR: {
                        success = this.moveCursor(-1) != 0;
                        break;
                    }
                    case NEXT_CHAR: {
                        success = this.moveCursor(1) != 0;
                        break;
                    }
                    case NEXT_HISTORY: {
                        success = this.moveHistory(true);
                        break;
                    }
                    case PREV_HISTORY: {
                        success = this.moveHistory(false);
                        break;
                    }
                    case ABORT: 
                    case REDISPLAY: {
                        break;
                    }
                    case PASTE: {
                        success = this.paste();
                        break;
                    }
                    case DELETE_PREV_WORD: {
                        success = this.deletePreviousWord();
                        break;
                    }
                    case PREV_WORD: {
                        success = this.previousWord();
                        break;
                    }
                    case NEXT_WORD: {
                        success = this.nextWord();
                        break;
                    }
                    case START_OF_HISTORY: {
                        success = this.history.moveToFirst();
                        if (!success) break;
                        this.setBuffer(this.history.current());
                        break;
                    }
                    case END_OF_HISTORY: {
                        success = this.history.moveToLast();
                        if (!success) break;
                        this.setBuffer(this.history.current());
                        break;
                    }
                    case CLEAR_LINE: {
                        this.moveInternal(-this.buf.buffer.length());
                        this.killLine();
                        break;
                    }
                    case INSERT: {
                        this.buf.setOverTyping(!this.buf.isOverTyping());
                        break;
                    }
                    case SEARCH_PREV: {
                        if (this.searchTerm != null) {
                            this.previousSearchTerm = this.searchTerm.toString();
                        }
                        this.searchTerm = new StringBuffer(this.buf.buffer);
                        state = 2;
                        if (this.searchTerm.length() > 0) {
                            this.searchIndex = this.searchBackwards(this.searchTerm.toString());
                            if (this.searchIndex == -1) {
                                this.beep();
                            }
                            this.printSearchStatus(this.searchTerm.toString(), this.searchIndex > -1 ? ((Object)this.history.get(this.searchIndex)).toString() : "");
                            break;
                        }
                        this.searchIndex = -1;
                        this.printSearchStatus("", "");
                        break;
                    }
                    default: {
                        if (c != 0) {
                            ActionListener action = this.triggeredActions.get(Character.valueOf((char)c));
                            if (action != null) {
                                action.actionPerformed(null);
                                break;
                            }
                            this.putChar(c, true);
                            break;
                        }
                        success = false;
                    }
                }
                if (!success) {
                    this.beep();
                }
                this.flush();
            }
        }
        finally {
            if (!this.terminal.isSupported()) {
                this.afterReadLine();
            }
        }
    }

    private String readLine(InputStream in) throws IOException {
        StringBuilder buff = new StringBuilder();
        int i;
        while ((i = in.read()) != -1 && i != 10 && i != 13) {
            buff.append((char)i);
        }
        return buff.toString();
    }

    public boolean addCompleter(Completer completer) {
        return this.completers.add(completer);
    }

    public boolean removeCompleter(Completer completer) {
        return this.completers.remove(completer);
    }

    public Collection<Completer> getCompleters() {
        return Collections.unmodifiableList(this.completers);
    }

    public void setCompletionHandler(CompletionHandler handler) {
        assert (handler != null);
        this.completionHandler = handler;
    }

    public CompletionHandler getCompletionHandler() {
        return this.completionHandler;
    }

    private boolean complete() throws IOException {
        Completer comp;
        if (this.completers.size() == 0) {
            return false;
        }
        LinkedList<CharSequence> candidates = new LinkedList<CharSequence>();
        String bufstr = this.buf.buffer.toString();
        int cursor = this.buf.cursor;
        int position = -1;
        Iterator<Completer> i$ = this.completers.iterator();
        while (i$.hasNext() && (position = (comp = i$.next()).complete(bufstr, cursor, candidates)) == -1) {
        }
        return candidates.size() != 0 && this.getCompletionHandler().complete(this, candidates, position);
    }

    public void setAutoprintThreshold(int threshold) {
        this.autoprintThreshold = threshold;
    }

    public int getAutoprintThreshold() {
        return this.autoprintThreshold;
    }

    public void setPaginationEnabled(boolean enabled) {
        this.paginationEnabled = enabled;
    }

    public boolean isPaginationEnabled() {
        return this.paginationEnabled;
    }

    public void setHistory(History history) {
        this.history = history;
    }

    public History getHistory() {
        return this.history;
    }

    public void setHistoryEnabled(boolean enabled) {
        this.historyEnabled = enabled;
    }

    public boolean isHistoryEnabled() {
        return this.historyEnabled;
    }

    private boolean moveHistory(boolean next) throws IOException {
        if (next && !this.history.next()) {
            return false;
        }
        if (!next && !this.history.previous()) {
            return false;
        }
        this.setBuffer(this.history.current());
        return true;
    }

    private void print(int c) throws IOException {
        if (c == 9) {
            byte[] chars = new byte[4];
            Arrays.fill(chars, (byte)32);
            this.shell.write(chars);
            return;
        }
        this.shell.write(c);
    }

    private void print(char c) throws IOException {
        this.print((int)c);
    }

    private void print(char c, int i) throws IOException {
        if (i == 1) {
            this.print(c);
        } else {
            byte[] chars = new byte[i];
            Arrays.fill(chars, (byte)c);
            this.print(chars);
        }
    }

    private void print(byte ... buff) throws IOException {
        byte[] chars;
        int len = 0;
        for (byte c : buff) {
            if (c == 9) {
                len += 4;
                continue;
            }
            ++len;
        }
        if (len == buff.length) {
            chars = buff;
        } else {
            chars = new byte[len];
            int pos = 0;
            for (byte c : buff) {
                if (c == 9) {
                    Arrays.fill(chars, pos, pos + 4, (byte)32);
                    pos += 4;
                    continue;
                }
                chars[pos] = c;
                ++pos;
            }
        }
        this.shell.write(chars);
    }

    private void print(byte c, int num) throws IOException {
        if (num == 1) {
            this.print((int)c);
        } else {
            byte[] chars = new byte[num];
            Arrays.fill(chars, c);
            this.print(chars);
        }
    }

    public final void print(CharSequence s) throws IOException {
        assert (s != null);
        this.print(((Object)s).toString().getBytes());
    }

    public final void println(CharSequence s) throws IOException {
        assert (s != null);
        this.print(((Object)s).toString().getBytes());
        this.println();
    }

    public final void println() throws IOException {
        this.print(CR);
    }

    public final boolean delete() throws IOException {
        return this.delete(1) == 1;
    }

    private int delete(int num) throws IOException {
        this.buf.buffer.delete(this.buf.cursor, this.buf.cursor + 1);
        this.drawBuffer(1);
        return 1;
    }

    public boolean killLine() throws IOException {
        int cp = this.buf.cursor;
        int len = this.buf.buffer.length();
        if (cp >= len) {
            return false;
        }
        int num = this.buf.buffer.length() - cp;
        this.clearAhead(num);
        for (int i = 0; i < num; ++i) {
            this.buf.buffer.deleteCharAt(len - i - 1);
        }
        return true;
    }

    public boolean clearScreen() throws IOException {
        if (!this.terminal.isAnsiSupported()) {
            return false;
        }
        this.printAnsiSequence("2J");
        this.printAnsiSequence("1;1H");
        this.redrawLine();
        return true;
    }

    public void beep() throws IOException {
        if (this.isBellEnabled()) {
            this.print('\u0007');
            this.flush();
        }
    }

    public boolean paste() throws IOException {
        Clipboard clipboard;
        try {
            clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        catch (Exception e) {
            return false;
        }
        if (clipboard == null) {
            return false;
        }
        Transferable transferable = clipboard.getContents(null);
        if (transferable == null) {
            return false;
        }
        try {
            String value;
            Object content = transferable.getTransferData(DataFlavor.plainTextFlavor);
            if (content == null) {
                try {
                    content = new DataFlavor().getReaderForText(transferable);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (content == null) {
                return false;
            }
            if (content instanceof Reader) {
                String line;
                value = "";
                BufferedReader read = new BufferedReader((Reader)content);
                while ((line = read.readLine()) != null) {
                    if (value.length() > 0) {
                        value = value + "\n";
                    }
                    value = value + line;
                }
            } else {
                value = content.toString();
            }
            if (value == null) {
                return true;
            }
            this.putString(value);
            return true;
        }
        catch (UnsupportedFlavorException e) {
            Log.error("Paste failed: ", e);
            return false;
        }
    }

    public void addTriggeredAction(char c, ActionListener listener) {
        this.triggeredActions.put(Character.valueOf(c), listener);
    }

    public void printColumns(Collection<? extends CharSequence> items) throws IOException {
        if (items == null || items.isEmpty()) {
            return;
        }
        int width = this.getTerminal().getWidth();
        int height = this.getTerminal().getHeight();
        int maxWidth = 0;
        for (CharSequence charSequence : items) {
            maxWidth = Math.max(maxWidth, charSequence.length());
        }
        Log.debug("Max width: ", maxWidth);
        int showLines = this.isPaginationEnabled() ? height - 1 : Integer.MAX_VALUE;
        StringBuilder stringBuilder = new StringBuilder();
        for (CharSequence charSequence : items) {
            if (stringBuilder.length() + maxWidth > width) {
                this.println(stringBuilder);
                stringBuilder.setLength(0);
                if (--showLines == 0) {
                    this.print(resources.getString("display-more"));
                    this.flush();
                    int c = this.readVirtualKey();
                    if (c == 13 || c == 10) {
                        showLines = 1;
                    } else if (c != 113) {
                        showLines = height - 1;
                    }
                    this.back(resources.getString("display-more").length());
                    if (c == 113) break;
                }
            }
            stringBuilder.append(((Object)charSequence).toString());
            for (int i = 0; i < maxWidth + 3 - charSequence.length(); ++i) {
                stringBuilder.append(' ');
            }
        }
        if (stringBuilder.length() > 0) {
            this.println(stringBuilder);
        }
    }

    private void beforeReadLine(String prompt, Character mask) {
        if (mask != null && this.maskThread == null) {
            final String fullPrompt = "\r" + prompt + "                 " + "                 " + "                 " + "\r" + prompt;
            this.maskThread = new Thread(){

                @Override
                public void run() {
                    while (!1.interrupted()) {
                        try {
                            BufferManager out = ConsoleReader.this.getShell().getBufferManager();
                            out.write(fullPrompt);
                            out.flushBuffer();
                            1.sleep(3L);
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                    }
                }
            };
            this.maskThread.setPriority(10);
            this.maskThread.setDaemon(true);
            this.maskThread.start();
        }
    }

    private void afterReadLine() {
        if (this.maskThread != null && this.maskThread.isAlive()) {
            this.maskThread.interrupt();
        }
        this.maskThread = null;
    }

    public void resetPromptLine(String prompt, String buffer, int cursorDest) throws IOException {
        this.moveToEnd();
        this.buf.buffer.append(this.prompt);
        this.buf.cursor += this.prompt.length();
        this.prompt = "";
        this.backspaceAll();
        this.prompt = prompt;
        this.redrawLine();
        this.setBuffer(buffer);
        if (cursorDest < 0) {
            cursorDest = buffer.length();
        }
        this.setCursorPosition(cursorDest);
        this.flush();
    }

    public void printSearchStatus(String searchTerm, String match) throws IOException {
        String prompt = "(reverse-i-search)`" + searchTerm + "': ";
        String buffer = match;
        int cursorDest = match.indexOf(searchTerm);
        this.resetPromptLine(prompt, buffer, cursorDest);
    }

    public void restoreLine(String originalPrompt, int cursorDest) throws IOException {
        String prompt = this.lastLine(originalPrompt);
        String buffer = this.buf.buffer.toString();
        this.resetPromptLine(prompt, buffer, cursorDest);
    }

    public int searchBackwards(String searchTerm, int startIndex) {
        return this.searchBackwards(searchTerm, startIndex, false);
    }

    public int searchBackwards(String searchTerm) {
        return this.searchBackwards(searchTerm, this.history.index());
    }

    public int searchBackwards(String searchTerm, int startIndex, boolean startsWith) {
        ListIterator<History.Entry> it = this.history.entries(startIndex);
        while (it.hasPrevious()) {
            History.Entry e = it.previous();
            if (!(startsWith ? ((Object)e.value()).toString().startsWith(searchTerm) : ((Object)e.value()).toString().contains(searchTerm))) continue;
            return e.index();
        }
        return -1;
    }

    private boolean isDelimiter(char c) {
        return !Character.isLetterOrDigit(c);
    }

    private void printAnsiSequence(String sequence) throws IOException {
        this.print(ESCAPE_STR + sequence);
    }

    private int getCurrentPosition() {
        if (this.terminal.isAnsiSupported() && !Boolean.getBoolean("forge.debug.no_auto_init_streams")) {
            try {
                int r;
                this.printAnsiSequence("6n");
                this.flush();
                StringBuffer b = new StringBuffer(8);
                while ((r = this.in.read()) > -1 && r != 82) {
                    if (r == 27 || r == 91) continue;
                    b.append((char)r);
                }
                String[] pos = b.toString().split(";");
                return Integer.parseInt(pos[1]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1;
    }
}

