/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.constraint;

import java.util.Collection;
import java.util.List;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.facets.PackagingFacet;
import org.jboss.forge.project.packaging.PackagingType;
import org.jboss.forge.shell.command.CommandMetadata;
import org.jboss.forge.shell.command.PluginMetadata;
import org.jboss.forge.shell.constraint.ConstraintException;
import org.jboss.forge.shell.constraint.NoProjectException;
import org.jboss.forge.shell.constraint.UnsatisfiedFacetDependencyException;
import org.jboss.forge.shell.constraint.UnsatisfiedPackagingTypeException;
import org.jboss.forge.shell.util.ConstraintInspector;

public class ConstraintEnforcer {
    public void verifyAvailable(Project currentProject, CommandMetadata command) throws NoProjectException, UnsatisfiedPackagingTypeException, UnsatisfiedFacetDependencyException {
        Class type = command.getParent().getType();
        if (ConstraintInspector.requiresProject((Class)type) && currentProject == null) {
            throw new NoProjectException("Oops! That command needs an active project, but you don't seem to be working on one. Perhaps you should open a project or create a new one?");
        }
        if (currentProject != null) {
            List compatiblePackagingTypes = ConstraintInspector.getCompatiblePackagingTypes((Class)type);
            PackagingType currentPackagingType = ((PackagingFacet)currentProject.getFacet(PackagingFacet.class)).getPackagingType();
            if (!compatiblePackagingTypes.isEmpty() && !compatiblePackagingTypes.contains(currentPackagingType)) {
                throw new UnsatisfiedPackagingTypeException("Oops! The command [" + command.getName() + "] requires one of the following packaging types " + compatiblePackagingTypes + ", but the current packaging type is [" + currentPackagingType + "]");
            }
            Collection currentFacets = currentProject.getFacets();
            List facetDependencies = ConstraintInspector.getFacetDependencies((Class)type);
            if (!currentProject.hasAllFacets((Collection)facetDependencies)) {
                facetDependencies.removeAll(currentFacets);
                throw new UnsatisfiedFacetDependencyException("Oops! The command [" + command.getName() + "] depends on one or more Facet that is not installed " + facetDependencies + "");
            }
        }
    }

    public void verifyAvailable(Project currentProject, PluginMetadata plugin) throws NoProjectException, UnsatisfiedPackagingTypeException, UnsatisfiedFacetDependencyException {
        Class type = plugin.getType();
        if (ConstraintInspector.requiresProject((Class)type) && currentProject == null) {
            throw new NoProjectException("Oops! The [" + plugin.getName() + "] plugin needs an active project, but you don't seem to be working on one. " + "Perhaps you should open a project or create a new one?");
        }
        if (currentProject != null) {
            PackagingType currentPackagingType;
            List compatiblePackagingTypes = ConstraintInspector.getCompatiblePackagingTypes((Class)type);
            if (!compatiblePackagingTypes.isEmpty() && !compatiblePackagingTypes.contains(currentPackagingType = ((PackagingFacet)currentProject.getFacet(PackagingFacet.class)).getPackagingType())) {
                throw new UnsatisfiedPackagingTypeException("Oops! The [" + plugin.getName() + "] plugin requires one of the following packaging types " + compatiblePackagingTypes + ", but the current packaging type is [" + currentPackagingType + "]");
            }
            Collection currentFacets = currentProject.getFacets();
            List facetDependencies = ConstraintInspector.getFacetDependencies((Class)type);
            if (!currentProject.hasAllFacets((Collection)facetDependencies)) {
                facetDependencies.removeAll(currentFacets);
                throw new UnsatisfiedFacetDependencyException("Oops! The [" + plugin.getName() + "] plugin depends on one or more Facet that is not installed " + facetDependencies + "");
            }
            for (Class facet : facetDependencies) {
                if (currentProject.getFacet(facet).isInstalled()) continue;
                throw new UnsatisfiedFacetDependencyException("Oops! The [" + plugin.getName() + "] plugin depends on one or more Facet that is not registered but not correctly installed [" + ConstraintInspector.getName((Class)facet) + "]");
            }
        }
    }

    public boolean isAvailable(Project currentProject, PluginMetadata plugin) {
        try {
            this.verifyAvailable(currentProject, plugin);
        }
        catch (ConstraintException e) {
            return false;
        }
        return true;
    }

    public boolean isAvailable(Project currentProject, CommandMetadata commandMetadata) {
        try {
            this.verifyAvailable(currentProject, commandMetadata);
        }
        catch (ConstraintException e) {
            return false;
        }
        return true;
    }
}

