/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.env;

import java.lang.annotation.Annotation;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.jboss.forge.ForgeEnvironment;
import org.jboss.forge.env.ConfigurationException;
import org.jboss.forge.env.ConfigurationFactory;
import org.jboss.forge.env.ConfigurationScope;
import org.jboss.forge.project.Project;
import org.jboss.forge.resources.FileResource;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.env.ConfigurationAdapter;
import org.jboss.forge.shell.env.ScopedConfigurationAdapter;
import org.jboss.forge.shell.squelch.ConfigAdapterQualifierLiteral;
import org.jboss.forge.shell.util.BeanManagerUtils;

@ApplicationScoped
public class ConfigurationFactoryImpl
implements ConfigurationFactory {
    private ForgeEnvironment environment;
    private org.jboss.forge.env.Configuration userConfig;
    private BeanManager bm;

    public ConfigurationFactoryImpl() {
    }

    @Inject
    public ConfigurationFactoryImpl(Shell shell, BeanManager bm) {
        this.bm = bm;
        this.environment = shell.getEnvironment();
    }

    public org.jboss.forge.env.Configuration getProjectConfig(Project project) {
        XMLConfiguration projectLocalConfig;
        ScopedConfigurationAdapter projectConfig = new ScopedConfigurationAdapter();
        try {
            projectLocalConfig = new XMLConfiguration(this.getProjectSettings(project).getUnderlyingResourceObject());
            projectLocalConfig.setEncoding("UTF-8");
        }
        catch (org.apache.commons.configuration.ConfigurationException e) {
            throw new ConfigurationException((Throwable)e);
        }
        projectLocalConfig.setReloadingStrategy((ReloadingStrategy)new FileChangedReloadingStrategy());
        projectLocalConfig.setAutoSave(true);
        ConfigurationAdapter adapter = (ConfigurationAdapter)BeanManagerUtils.getContextualInstance((BeanManager)this.bm, ConfigurationAdapter.class, (Annotation[])new Annotation[]{new ConfigAdapterQualifierLiteral()});
        adapter.setParent(projectConfig);
        adapter.setDelegate((Configuration)projectLocalConfig);
        adapter.setBeanManager(this.bm);
        projectConfig.setScopedConfiguration(ConfigurationScope.PROJECT, adapter);
        projectConfig.setScopedConfiguration(ConfigurationScope.USER, this.getUserConfig());
        return projectConfig;
    }

    public org.jboss.forge.env.Configuration getUserConfig() throws ConfigurationException {
        if (this.userConfig == null) {
            XMLConfiguration globalXml;
            try {
                globalXml = new XMLConfiguration(this.environment.getUserConfiguration().getUnderlyingResourceObject());
                globalXml.setEncoding("UTF-8");
            }
            catch (org.apache.commons.configuration.ConfigurationException e) {
                throw new ConfigurationException((Throwable)e);
            }
            globalXml.setReloadingStrategy((ReloadingStrategy)new FileChangedReloadingStrategy());
            globalXml.setAutoSave(true);
            ConfigurationAdapter adapter = (ConfigurationAdapter)BeanManagerUtils.getContextualInstance((BeanManager)this.bm, ConfigurationAdapter.class, (Annotation[])new Annotation[]{new ConfigAdapterQualifierLiteral()});
            adapter.setDelegate((Configuration)globalXml);
            adapter.setBeanManager(this.bm);
            this.userConfig = new ScopedConfigurationAdapter(ConfigurationScope.USER, adapter);
        }
        return this.userConfig;
    }

    private FileResource<?> getProjectSettings(Project project) {
        FileResource settingsFile = (FileResource)project.getProjectRoot().getChild(".forge_settings").reify(FileResource.class);
        return settingsFile;
    }
}

