/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.plugins.builtin;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import javax.inject.Inject;
import org.jboss.forge.resources.DirectoryResource;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.resources.ResourceFlag;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.ShellColor;
import org.jboss.forge.shell.ShellPrintWriter;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.DefaultCommand;
import org.jboss.forge.shell.plugins.Help;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.PipeOut;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.RequiresResource;
import org.jboss.forge.shell.plugins.Topic;
import org.jboss.forge.shell.util.FormatCallback;
import org.jboss.forge.shell.util.GeneralUtils;

@Alias(value="ls")
@Topic(value="File & Resources")
@RequiresResource(value={DirectoryResource.class})
@Help(value="Prints the contents current directory.")
public class LsPlugin
implements Plugin {
    private final Shell shell;
    private static final long yearMarker;
    private static final SimpleDateFormat dateFormatOld;
    private static final SimpleDateFormat dateFormatRecent;

    @Inject
    public LsPlugin(Shell shell) {
        this.shell = shell;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DefaultCommand
    public void run(@Option(description="path", defaultValue=".") Resource<?>[] paths, @Option(flagOnly=true, name="all", shortName="a", required=false) boolean showAll, @Option(flagOnly=true, name="list", shortName="l", required=false) boolean list, final PipeOut out) {
        FormatCallback formatCallback;
        TreeMap sortMap = new TreeMap();
        LinkedList<String> listBuild = new LinkedList<String>();
        for (Resource<?> resource : paths) {
            String el;
            List childResources;
            if (!resource.isFlagSet(ResourceFlag.AmbiguouslyQualified) && resource.isFlagSet(ResourceFlag.Node)) {
                childResources = resource.listResources();
            } else if (resource.exists()) {
                childResources = Collections.singletonList(resource);
            } else {
                return;
            }
            if (list) {
                int fileCount = 0;
                for (Resource r : childResources) {
                    el = r.getName();
                    ArrayList<String> subList = new ArrayList<String>();
                    sortMap.put(el, subList);
                    File file = (File)r.getUnderlyingResourceObject();
                    boolean dir = r instanceof DirectoryResource;
                    if (dir) {
                        el = el + "/";
                    }
                    if (!showAll && el.startsWith(".")) continue;
                    StringBuilder permissions = new StringBuilder(dir ? "d" : "-").append(file.canRead() ? (char)'r' : '-').append(file.canWrite() ? (char)'w' : '-').append(file.canExecute() ? (char)'x' : '-').append("------");
                    subList.add(permissions.toString());
                    subList.add("owner");
                    subList.add(" users ");
                    subList.add(String.valueOf(file.length()));
                    subList.addAll(Arrays.asList(LsPlugin.getDateString(file.lastModified())));
                    subList.add(el);
                    if (dir) continue;
                    ++fileCount;
                }
                for (List sublist : sortMap.values()) {
                    listBuild.addAll(sublist);
                }
                out.println("total " + fileCount);
                continue;
            }
            for (Resource r : childResources) {
                el = r.getName();
                if (r instanceof DirectoryResource) {
                    el = el + "/";
                }
                if (!showAll && el.startsWith(".")) continue;
                listBuild.add(el);
            }
        }
        if (list) {
            formatCallback = new FormatCallback(){

                @Override
                public String format(int column, String value) {
                    if (column == 7 && value.endsWith("/")) {
                        return LsPlugin.this.shell.renderColor(ShellColor.BLUE, value);
                    }
                    return value;
                }
            };
            try {
                this.shell.bufferingMode();
                GeneralUtils.printOutTables(listBuild, new boolean[]{false, false, false, true, false, false, true, false}, (ShellPrintWriter)out, formatCallback);
            }
            finally {
                this.shell.directWriteMode();
            }
        }
        formatCallback = new FormatCallback(){

            @Override
            public String format(int column, String value) {
                if (value.endsWith("/")) {
                    return out.renderColor(ShellColor.BLUE, value);
                }
                return value;
            }
        };
        try {
            this.shell.bufferingMode();
            if (out.isPiped()) {
                GeneralUtils.OutputAttributes attr = new GeneralUtils.OutputAttributes(120, 1);
                GeneralUtils.printOutColumns(listBuild, ShellColor.NONE, (ShellPrintWriter)out, attr, null, false);
            } else {
                GeneralUtils.printOutColumns(listBuild, (ShellPrintWriter)out, this.shell, formatCallback, false);
            }
        }
        finally {
            this.shell.directWriteMode();
        }
    }

    private static String[] getDateString(long time) {
        if (time < yearMarker) {
            return dateFormatOld.format(new Date(time)).split(" ");
        }
        return dateFormatRecent.format(new Date(time)).split(" ");
    }

    static {
        dateFormatOld = new SimpleDateFormat("MMM d yyyy");
        dateFormatRecent = new SimpleDateFormat("MMM d HH:mm");
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(System.currentTimeMillis());
        c.set(2, 0);
        c.set(5, 0);
        c.set(10, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        yearMarker = c.getTimeInMillis();
    }
}

