/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.plugins.builtin;

import java.util.List;
import javax.inject.Inject;
import org.jboss.forge.resources.DeletionAware;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.ShellMessages;
import org.jboss.forge.shell.ShellPrintWriter;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.DefaultCommand;
import org.jboss.forge.shell.plugins.Help;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.Topic;

@Alias(value="rm")
@Topic(value="File & Resources")
@Help(value="Removes a resource")
public class RmPlugin
implements Plugin {
    private final Shell shell;

    @Inject
    public RmPlugin(Shell shell) {
        this.shell = shell;
    }

    @DefaultCommand
    public void rm(@Option(name="recursive", shortName="r", help="recursively delete resources", flagOnly=true) boolean recursive, @Option(name="force", shortName="f", help="do not prompt to confirm operations", flagOnly=true) boolean force, @Option(description="path", required=true) Resource<?>[] paths) {
        for (Resource<?> resource : paths) {
            this.deleteResource(recursive, force, resource);
        }
    }

    private void deleteResource(boolean recursive, boolean force, Resource<?> resource) {
        if (!resource.exists()) {
            ShellMessages.error((ShellPrintWriter)this.shell, (String)("rm: cannot remove '" + resource.getFullyQualifiedName() + "': No such resource exists"));
            return;
        }
        if (force || this.shell.promptBoolean("delete: " + resource.getName() + ": are you sure?", true)) {
            if (!resource.delete(recursive)) {
                throw new RuntimeException("error deleting " + resource);
            }
            if (resource instanceof DeletionAware) {
                List toDeleteResources = ((DeletionAware)resource).getResources();
                List toDeleteOptionalResources = ((DeletionAware)resource).getOptionalResources();
                if (toDeleteResources != null) {
                    for (Resource deletionResource : toDeleteResources) {
                        this.deleteResource(recursive, true, deletionResource);
                    }
                }
                if (toDeleteOptionalResources != null) {
                    for (Resource deletionResource : toDeleteOptionalResources) {
                        this.deleteResource(recursive, force, deletionResource);
                    }
                }
            }
        }
    }
}

