/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.observers;

import javax.enterprise.event.Observes;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.facets.MetadataFacet;
import org.jboss.forge.project.facets.PackagingFacet;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.ShellColor;
import org.jboss.forge.shell.ShellMessages;
import org.jboss.forge.shell.ShellPrintWriter;
import org.jboss.forge.shell.events.ProjectChanged;

public class ProjectInfoObserver {
    public void observeProjectChanged(@Observes ProjectChanged projectChanged, Shell shell) {
        Project newProject = projectChanged.getNewProject();
        if (newProject != null && shell.isVerbose()) {
            MetadataFacet metadata = (MetadataFacet)newProject.getFacet(MetadataFacet.class);
            PackagingFacet packaging = (PackagingFacet)newProject.getFacet(PackagingFacet.class);
            ShellMessages.info((ShellPrintWriter)shell, (String)"Project found");
            ShellMessages.info((ShellPrintWriter)shell, (String)("Name: \t" + shell.renderColor(ShellColor.BOLD, metadata.getProjectName())));
            ShellMessages.info((ShellPrintWriter)shell, (String)("Version: \t" + shell.renderColor(ShellColor.BOLD, metadata.getProjectVersion())));
            ShellMessages.info((ShellPrintWriter)shell, (String)("Type: \t" + shell.renderColor(ShellColor.BOLD, packaging.getPackagingType().getDescription())));
            shell.println();
        }
    }
}

