/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.plugins.builtin;

import java.io.IOException;
import javax.inject.Inject;
import org.jboss.forge.resources.FileResource;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.DefaultCommand;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.Topic;

@Alias(value="run")
@Topic(value="Shell Environment")
public class RunPlugin
implements Plugin {
    private final Shell shell;

    @Inject
    public RunPlugin(Shell shell) {
        this.shell = shell;
    }

    @DefaultCommand
    public void run(@Option(description="file...", required=true) Resource<?> r, String ... args) throws Exception {
        if (r instanceof FileResource) {
            try {
                this.shell.execute(((FileResource)r).getUnderlyingResourceObject(), args);
            }
            catch (IOException e) {
                throw new RuntimeException("error executing script from file: " + r.getName());
            }
        } else {
            throw new RuntimeException("resource type not an executable script: " + r.getClass().getName());
        }
    }
}

