/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.tracking;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LinuxSystem {
    public static final LinuxSystem INSTANCE = new LinuxSystem();
    public final LinuxDistro CENTOS = new ReleaseFileContentCheckedDistro("CentOS", "/etc/redhat-release");
    public final LinuxDistro DEBIAN = new LinuxDistro("Debian", "/etc/debian_version");
    public final LinuxDistro FEDORA = new LinuxDistro("Fedora", "/etc/fedora-release");
    public final LinuxDistro GENTOO = new LinuxDistro("Gentoo", "/etc/gentoo-release");
    public final LinuxDistro YELLOWDOG = new LinuxDistro("YellowDog", "/etc/yellowdog-release");
    public final LinuxDistro KNOPPIX = new LinuxDistro("Knoppix", "knoppix_version");
    public final LinuxDistro MANDRAKE = new LinuxDistro("Mandrake", "/etc/mandrake-release");
    public final LinuxDistro MANDRIVA = new LinuxDistro("Mandriva", "/etc/mandriva-release");
    public final LinuxDistro MINT = new ReleaseFileContentCheckedDistro("LinuxMint", "/etc/lsb-release");
    public final LinuxDistro PLD = new LinuxDistro("PLD", "/etc/pld-release");
    public final LinuxDistro REDHAT = new ReleaseFileContentCheckedDistro("Red Hat", "/etc/redhat-release");
    public final LinuxDistro SLACKWARE = new LinuxDistro("Slackware", "/etc/slackware-version");
    public final LinuxDistro SUSE = new LinuxDistro("SUSE", "/etc/SuSE-release");
    public final LinuxDistro UBUNTU = new ReleaseFileContentCheckedDistro("Ubuntu", "/etc/lsb-release");
    private final LinuxDistro[] ALL = new LinuxDistro[]{this.CENTOS, this.MINT, this.UBUNTU, this.DEBIAN, this.FEDORA, this.GENTOO, this.KNOPPIX, this.MANDRAKE, this.MANDRIVA, this.PLD, this.REDHAT, this.SLACKWARE, this.SUSE, this.YELLOWDOG};

    public LinuxDistro getDistro() {
        for (LinuxDistro distro : this.ALL) {
            if (!distro.isDistro()) continue;
            return distro;
        }
        return null;
    }

    public String getDistroNameAndVersion() {
        LinuxDistro distro = this.getDistro();
        if (distro != null) {
            return distro.getNameAndVersion();
        }
        return "Unknown";
    }

    protected boolean exists(String releaseFilePath) {
        return releaseFilePath != null && releaseFilePath.length() > 0 && new File(releaseFilePath).exists();
    }

    protected String getDistroFileContent(String filePath) throws IOException {
        int charachtersToRead = 1024;
        StringBuilder builder = new StringBuilder(charachtersToRead);
        BufferedReader reader = new BufferedReader(new FileReader(filePath));
        char[] buf = new char[charachtersToRead];
        int charRead = 0;
        while ((charRead = reader.read(buf)) != -1 && builder.length() < charachtersToRead) {
            String readData = String.valueOf(buf, 0, charRead);
            builder.append(readData);
        }
        reader.close();
        return builder.toString();
    }

    public class ReleaseFileContentCheckedDistro
    extends LinuxDistro {
        public ReleaseFileContentCheckedDistro(String name, String releaseFilePath) {
            super(name, releaseFilePath);
        }

        @Override
        protected boolean isDistro() {
            return this.distroFileContains(this.getName());
        }
    }

    public class LinuxDistro {
        private final Pattern VERSION_REGEX = Pattern.compile("([0-9.]+)");
        protected final String releaseFilePath;
        private String name;

        protected LinuxDistro(String name, String releaseFilePath) {
            this.name = name;
            this.releaseFilePath = releaseFilePath;
        }

        protected boolean isDistro() {
            return LinuxSystem.this.exists(this.getReleaseFilePath());
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            try {
                String distroString = LinuxSystem.this.getDistroFileContent(this.getReleaseFilePath());
                Matcher matcher = this.VERSION_REGEX.matcher(distroString);
                if (matcher.find()) {
                    return matcher.group(1);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return "";
        }

        public String getNameAndVersion() {
            return this.getName() + " " + this.getVersion();
        }

        public String getReleaseFilePath() {
            return this.releaseFilePath;
        }

        protected boolean distroFileContains(String value) {
            try {
                boolean fileExists = LinuxSystem.this.exists(this.getReleaseFilePath());
                if (fileExists) {
                    String content = LinuxSystem.this.getDistroFileContent(this.getReleaseFilePath());
                    return content != null && content.indexOf(value) >= 0;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }

        public String toString() {
            return this.name;
        }
    }
}

