/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.manager.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.manager.AddonManager;
import org.jboss.forge.furnace.manager.impl.ShallowAddonInfo;
import org.jboss.forge.furnace.manager.impl.request.AddonActionRequestFactory;
import org.jboss.forge.furnace.manager.request.AddonActionRequest;
import org.jboss.forge.furnace.manager.request.DeployRequest;
import org.jboss.forge.furnace.manager.request.DisableRequest;
import org.jboss.forge.furnace.manager.request.EnableRequest;
import org.jboss.forge.furnace.manager.request.InstallRequest;
import org.jboss.forge.furnace.manager.request.RemoveRequest;
import org.jboss.forge.furnace.manager.spi.AddonDependencyResolver;
import org.jboss.forge.furnace.manager.spi.AddonInfo;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.repositories.MutableAddonRepository;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.forge.furnace.versions.Version;
import org.jboss.forge.furnace.versions.Versions;

public class AddonManagerImpl
implements AddonManager {
    private final Furnace furnace;
    private final AddonDependencyResolver resolver;

    public AddonManagerImpl(Furnace forge, AddonDependencyResolver resolver) {
        this.furnace = forge;
        this.resolver = resolver;
    }

    public AddonInfo info(AddonId addonId) {
        return this.resolver.resolveAddonDependencyHierarchy(addonId);
    }

    public InstallRequest install(AddonId addonId) {
        return this.install(addonId, (AddonRepository)this.getDefaultRepository());
    }

    public InstallRequest install(AddonId addonId, AddonRepository repository) {
        MutableAddonRepository mutableRepo = this.assertMutableRepository(repository);
        AddonInfo addonInfo = this.info(addonId);
        LinkedList<AddonInfo> allAddons = new LinkedList<AddonInfo>();
        this.collectRequiredAddons(addonInfo, allAddons);
        Map<AddonId, AddonRepository> installedAddonIds = this.getInstalledAddons();
        ArrayList<AddonActionRequest> actions = new ArrayList<AddonActionRequest>();
        for (AddonInfo newAddonInfo : allAddons) {
            AddonActionRequest request = this.createRequest(addonInfo, newAddonInfo, mutableRepo, installedAddonIds);
            if (request == null) continue;
            actions.add(request);
        }
        return AddonActionRequestFactory.createInstallRequest(addonInfo, actions);
    }

    public DeployRequest deploy(AddonId id) {
        return this.deploy(id, (AddonRepository)this.getDefaultRepository());
    }

    public DeployRequest deploy(AddonId id, AddonRepository repository) {
        MutableAddonRepository mutableRepo = this.assertMutableRepository(repository);
        return AddonActionRequestFactory.createDeployRequest(this.info(id), mutableRepo, this.furnace);
    }

    public RemoveRequest remove(AddonId id) {
        return this.remove(id, (AddonRepository)this.getDefaultRepository());
    }

    public RemoveRequest remove(AddonId id, AddonRepository repository) {
        ShallowAddonInfo info = new ShallowAddonInfo(id);
        return AddonActionRequestFactory.createRemoveRequest(info, this.assertMutableRepository(repository), this.furnace);
    }

    public DisableRequest disable(AddonId id) {
        return this.disable(id, (AddonRepository)this.getDefaultRepository());
    }

    public DisableRequest disable(AddonId id, AddonRepository repository) {
        ShallowAddonInfo info = new ShallowAddonInfo(id);
        return AddonActionRequestFactory.createDisableRequest(info, this.assertMutableRepository(repository), this.furnace);
    }

    public EnableRequest enable(AddonId id) {
        return this.enable(id, (AddonRepository)this.getDefaultRepository());
    }

    public EnableRequest enable(AddonId id, AddonRepository repository) {
        ShallowAddonInfo info = new ShallowAddonInfo(id);
        return AddonActionRequestFactory.createEnableRequest(info, this.assertMutableRepository(repository), this.furnace);
    }

    private AddonActionRequest createRequest(AddonInfo requestedAddonInfo, AddonInfo addonInfo, MutableAddonRepository repository, Map<AddonId, AddonRepository> installedAddons) {
        Object request;
        AddonId addon = addonInfo.getAddon();
        if (installedAddons.containsKey(addon)) {
            AddonRepository addonRepository;
            request = Versions.isSnapshot((Version)addonInfo.getAddon().getVersion()) && addonInfo.equals(requestedAddonInfo) ? (repository.equals(addonRepository = installedAddons.get(addon)) ? AddonActionRequestFactory.createUpdateRequest(addonInfo, addonInfo, repository, this.furnace) : AddonActionRequestFactory.createDeployRequest(addonInfo, repository, this.furnace)) : null;
        } else {
            Map.Entry<AddonId, AddonRepository> differentVersionEntry = null;
            for (Map.Entry<AddonId, AddonRepository> addonEntry : installedAddons.entrySet()) {
                AddonId addonId = addonEntry.getKey();
                if (!addonId.getName().equals(addon.getName())) continue;
                differentVersionEntry = addonEntry;
                break;
            }
            request = differentVersionEntry != null ? (((AddonId)differentVersionEntry.getKey()).getVersion().compareTo((Object)addon.getVersion()) < 0 ? (repository.equals(differentVersionEntry.getValue()) ? AddonActionRequestFactory.createUpdateRequest(this.info(differentVersionEntry.getKey()), addonInfo, repository, this.furnace) : AddonActionRequestFactory.createDeployRequest(addonInfo, repository, this.furnace)) : null) : AddonActionRequestFactory.createDeployRequest(addonInfo, repository, this.furnace);
        }
        return request;
    }

    private void collectRequiredAddons(AddonInfo addonInfo, List<AddonInfo> addons) {
        addons.add(0, addonInfo);
        for (AddonInfo id : addonInfo.getRequiredAddons()) {
            if (addons.contains(id)) continue;
            this.collectRequiredAddons(id, addons);
        }
    }

    private MutableAddonRepository getDefaultRepository() {
        for (AddonRepository repo : this.furnace.getRepositories()) {
            if (!(repo instanceof MutableAddonRepository)) continue;
            return (MutableAddonRepository)repo;
        }
        throw new IllegalStateException("No default mutable repository found in Furnace instance. Have you added one using furnace.addRepository(AddonRepositoryMode.MUTABLE, repository) ?");
    }

    private MutableAddonRepository assertMutableRepository(AddonRepository repository) {
        Assert.isTrue((boolean)(repository instanceof MutableAddonRepository), (String)("Addon repository [" + repository.getRootDirectory().getAbsolutePath() + "] is not writable."));
        return (MutableAddonRepository)repository;
    }

    private Map<AddonId, AddonRepository> getInstalledAddons() {
        HashMap<AddonId, AddonRepository> addons = new HashMap<AddonId, AddonRepository>();
        for (AddonRepository repository : this.furnace.getRepositories()) {
            List listEnabled = repository.listAll();
            for (AddonId addonId : listEnabled) {
                addons.put(addonId, repository);
            }
        }
        return addons;
    }
}

