/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Settings;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.impl.FurnaceImpl;
import org.jboss.forge.furnace.manager.impl.AddonManagerImpl;
import org.jboss.forge.furnace.manager.maven.addon.MavenAddonDependencyResolver;
import org.jboss.forge.furnace.manager.request.InstallRequest;
import org.jboss.forge.furnace.manager.spi.AddonDependencyResolver;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.repositories.AddonRepositoryMode;

@Mojo(name="addon-install", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, threadSafe=true)
public class AddonInstallMojo
extends AbstractMojo {
    @Parameter(property="forge.repository", required=true)
    private File addonRepository;
    @Parameter(property="forge.addonIds", required=true)
    private String[] addonIds;
    @Parameter(defaultValue="forge-addon")
    private String classifier;
    @Parameter(defaultValue="${settings}", required=true, readonly=true)
    private Settings settings;
    @Parameter(property="furnace.addon.api.resolution.skip")
    private boolean skipAddonAPIVersionResolution;
    @Parameter(property="furnace.addon.overwrite", defaultValue="true")
    private boolean overwrite = true;
    @Parameter(property="furnace.addon.skip")
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Execution skipped.");
            return;
        }
        FurnaceImpl forge = new FurnaceImpl();
        if (!this.addonRepository.exists()) {
            this.addonRepository.mkdirs();
        } else if (this.overwrite) {
            try {
                this.deleteDirectory(this.addonRepository);
                this.addonRepository.mkdirs();
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not delete " + this.addonRepository, (Exception)e);
            }
        }
        AddonRepository repository = forge.addRepository(AddonRepositoryMode.MUTABLE, this.addonRepository);
        MavenAddonDependencyResolver addonResolver = new MavenAddonDependencyResolver(this.classifier);
        addonResolver.setSettings(this.settings);
        addonResolver.setResolveAddonAPIVersions(!this.skipAddonAPIVersionResolution);
        AddonManagerImpl addonManager = new AddonManagerImpl((Furnace)forge, (AddonDependencyResolver)addonResolver);
        for (String addonId : this.addonIds) {
            AddonId id = AddonId.fromCoordinates((String)addonId);
            InstallRequest install = addonManager.install(id, repository);
            if (install.getActions().isEmpty()) continue;
            this.getLog().info((CharSequence)("" + install));
            install.perform();
        }
    }

    private void deleteDirectory(File addonRepository) throws IOException {
        Files.walkFileTree(addonRepository.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

