/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.maven.plugin;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.settings.Settings;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.impl.graph.AddonDependencyEdge;
import org.jboss.forge.furnace.impl.graph.AddonDependencyEdgeNameProvider;
import org.jboss.forge.furnace.impl.graph.AddonVertex;
import org.jboss.forge.furnace.impl.graph.AddonVertexNameProvider;
import org.jboss.forge.furnace.manager.maven.addon.MavenAddonDependencyResolver;
import org.jboss.forge.furnace.manager.spi.AddonDependencyResolver;
import org.jboss.forge.furnace.manager.spi.AddonInfo;
import org.jboss.forge.furnace.repositories.AddonDependencyEntry;
import org.jgrapht.DirectedGraph;
import org.jgrapht.ext.DOTExporter;
import org.jgrapht.ext.EdgeNameProvider;
import org.jgrapht.ext.IntegerNameProvider;
import org.jgrapht.ext.VertexNameProvider;
import org.jgrapht.graph.DefaultDirectedGraph;

@Mojo(defaultPhase=LifecyclePhase.PREPARE_PACKAGE, name="generate-dot", threadSafe=true)
public class GenerateDOTMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.outputDirectory}/META-INF/resources")
    private String outputDirectory;
    @Parameter
    private String outputFileName;
    @Parameter(property="furnace.dot.transitive", defaultValue="true")
    private boolean includeTransitiveAddons;
    @Parameter
    private String[] addonIds;
    @Parameter
    private boolean attach;
    @Parameter
    private boolean failOnError;
    @Parameter(property="furnace.dot.skip")
    private boolean skip;
    @Parameter(defaultValue="forge-addon")
    private String classifier;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject mavenProject;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(defaultValue="${settings}", required=true, readonly=true)
    private Settings settings;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Execution skipped.");
            return;
        }
        try {
            MavenAddonDependencyResolver addonResolver = new MavenAddonDependencyResolver(this.classifier);
            addonResolver.setSettings(this.settings);
            if (this.addonIds == null || this.addonIds.length == 0) {
                AddonId id = AddonId.from((String)(this.mavenProject.getGroupId() + ":" + this.mavenProject.getArtifactId()), (String)this.mavenProject.getVersion());
                String fileName = this.outputFileName == null ? id.getName().substring(id.getName().indexOf(58) + 1) + "-" + id.getVersion() + ".dot" : this.outputFileName;
                File file = this.generateDOTFile((AddonDependencyResolver)addonResolver, id, fileName);
                if (this.attach && file.isFile()) {
                    this.projectHelper.attachArtifact(this.mavenProject, "dot", file);
                }
            } else {
                for (String addonId : this.addonIds) {
                    AddonId id = AddonId.fromCoordinates((String)addonId);
                    String fileName = id.getName().substring(id.getName().indexOf(58) + 1) + "-" + id.getVersion() + ".dot";
                    this.generateDOTFile((AddonDependencyResolver)addonResolver, id, fileName);
                }
            }
        }
        catch (Exception e) {
            if (this.failOnError) {
                throw e;
            }
            this.getLog().warn((CharSequence)"Error while running generate-dot goal", (Throwable)e);
        }
    }

    private File generateDOTFile(AddonDependencyResolver addonResolver, AddonId id, String fileName) {
        File parent = new File(this.outputDirectory);
        parent.mkdirs();
        File file = new File(parent, fileName);
        this.getLog().info((CharSequence)("Generating " + file));
        AddonInfo addonInfo = addonResolver.resolveAddonDependencyHierarchy(id);
        this.toDOT(file, this.toGraph(addonInfo));
        return file;
    }

    DirectedGraph<AddonVertex, AddonDependencyEdge> toGraph(AddonInfo info) {
        DefaultDirectedGraph graph = new DefaultDirectedGraph(AddonDependencyEdge.class);
        this.populateGraph(info, (DirectedGraph<AddonVertex, AddonDependencyEdge>)graph);
        return graph;
    }

    private void populateGraph(AddonInfo info, DirectedGraph<AddonVertex, AddonDependencyEdge> graph) {
        this.addGraphDependencies(info, graph);
        if (this.includeTransitiveAddons) {
            for (AddonInfo requiredAddon : info.getRequiredAddons()) {
                this.populateGraph(requiredAddon, graph);
            }
            for (AddonInfo optionalAddon : info.getOptionalAddons()) {
                this.populateGraph(optionalAddon, graph);
            }
        }
    }

    private void addGraphDependencies(AddonInfo info, DirectedGraph<AddonVertex, AddonDependencyEdge> graph) {
        AddonId addon = info.getAddon();
        AddonVertex rootVertex = new AddonVertex(addon.getName(), addon.getVersion());
        graph.addVertex((Object)rootVertex);
        for (AddonDependencyEntry entry : info.getDependencyEntries()) {
            AddonVertex depVertex = new AddonVertex(entry.getName(), entry.getVersionRange().getMax());
            graph.addVertex((Object)depVertex);
            graph.addEdge((Object)rootVertex, (Object)depVertex, (Object)new AddonDependencyEdge(entry.getVersionRange(), entry.isExported(), entry.isOptional()));
        }
    }

    void toDOT(File file, DirectedGraph<AddonVertex, AddonDependencyEdge> graph) {
        DOTExporter exporter = new DOTExporter((VertexNameProvider)new IntegerNameProvider(), (VertexNameProvider)new AddonVertexNameProvider(), (EdgeNameProvider)new AddonDependencyEdgeNameProvider());
        try (FileWriter fw = new FileWriter(file);){
            exporter.export((Writer)fw, graph);
            fw.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

