/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.nd;

import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.nd.ITypeFactory;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.nd.Nd;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.nd.db.IndexException;

public class NdNodeTypeRegistry<R> {
    private final Map<Short, ITypeFactory<? extends R>> types = new HashMap<Short, ITypeFactory<? extends R>>();
    private final BitSet reserved = new BitSet();
    private final Map<Class<?>, Short> registeredClasses = new HashMap();

    public <T extends R> void register(int typeId, ITypeFactory<T> toRegister) {
        if ((typeId & 0xFFFF0000) != 0) {
            throw new IllegalArgumentException("The typeId " + typeId + " does not fit within a short int");
        }
        short shortTypeId = (short)typeId;
        String fullyQualifiedClassName = toRegister.getElementClass().getName();
        if (this.types.containsKey(shortTypeId) || this.reserved.get(typeId)) {
            throw new IllegalArgumentException("The type id " + typeId + " for class " + fullyQualifiedClassName + " is already in use.");
        }
        this.types.put(shortTypeId, toRegister);
        this.registeredClasses.put(toRegister.getElementClass(), shortTypeId);
    }

    public void reserve(short typeId) {
        if (this.types.containsKey(typeId) || this.reserved.get(typeId)) {
            throw new IllegalArgumentException("The type ID " + typeId + " is already in use");
        }
        this.reserved.set(typeId);
    }

    public ITypeFactory<? extends R> getClassForType(short type) {
        return this.types.get(type);
    }

    public R createNode(Nd nd, long address, short nodeType) throws IndexException {
        ITypeFactory<R> typeFactory = this.types.get(nodeType);
        if (typeFactory == null) {
            throw new IndexException("Index corruption detected. Unknown node type: " + nodeType + " at address " + address);
        }
        return typeFactory.create(nd, address);
    }

    public boolean isRegisteredClass(Class<?> toQuery) {
        return this.registeredClasses.containsKey(toQuery);
    }

    public short getTypeForClass(Class<?> toQuery) {
        Short classId = this.registeredClasses.get(toQuery);
        if (classId == null) {
            throw new IllegalArgumentException(String.valueOf(toQuery.getName()) + " was not registered as a node type");
        }
        return classId;
    }

    public <T extends R> ITypeFactory<T> getTypeFactory(short nodeType) {
        ITypeFactory<? extends R> result = this.types.get(nodeType);
        if (result == null) {
            throw new IllegalArgumentException("The node type " + nodeType + " is not registered with this database");
        }
        return result;
    }
}

