/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.weaving;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.RandomAccess;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.weaving.WovenClassImpl;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.util.ManifestElement;
import org.jboss.forge.roaster._shade.org.osgi.framework.PackagePermission;

public class DynamicImportList
extends AbstractList<String>
implements RandomAccess {
    private final List<String> imports = new ArrayList<String>(0);
    private final WovenClassImpl wovenClass;

    public DynamicImportList(WovenClassImpl wovenClass) {
        this.wovenClass = wovenClass;
    }

    @Override
    public String get(int index) {
        return this.imports.get(index);
    }

    @Override
    public int size() {
        return this.imports.size();
    }

    @Override
    public String set(int index, String element) {
        this.wovenClass.checkPermission();
        this.validateSyntaxAndCheckPackagePermission(element);
        return this.imports.set(index, element);
    }

    @Override
    public void add(int index, String element) {
        this.wovenClass.checkPermission();
        this.validateSyntaxAndCheckPackagePermission(element);
        this.imports.add(index, element);
    }

    @Override
    public String remove(int index) {
        this.wovenClass.checkPermission();
        return this.imports.remove(index);
    }

    private void validateSyntaxAndCheckPackagePermission(String dynamicImportPackageDescription) {
        ManifestElement[] clauses;
        try {
            clauses = ManifestElement.parseHeader("Import-Package", dynamicImportPackageDescription);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return;
        }
        ManifestElement[] manifestElementArray = clauses;
        int n = clauses.length;
        int n2 = 0;
        while (n2 < n) {
            ManifestElement clause = manifestElementArray[n2];
            String[] stringArray = clause.getValueComponents();
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String pkg = stringArray[n4];
                sm.checkPermission(new PackagePermission(pkg, "import"));
                ++n4;
            }
            ++n2;
        }
    }
}

