/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster._shade.org.eclipse.core.internal.jobs;

import org.jboss.forge.roaster._shade.org.eclipse.core.internal.jobs.JobChangeEvent;
import org.jboss.forge.roaster._shade.org.eclipse.core.internal.jobs.JobMessages;
import org.jboss.forge.roaster._shade.org.eclipse.core.internal.jobs.JobOSGiUtils;
import org.jboss.forge.roaster._shade.org.eclipse.core.internal.runtime.RuntimeLog;
import org.jboss.forge.roaster._shade.org.eclipse.core.runtime.IStatus;
import org.jboss.forge.roaster._shade.org.eclipse.core.runtime.ListenerList;
import org.jboss.forge.roaster._shade.org.eclipse.core.runtime.OperationCanceledException;
import org.jboss.forge.roaster._shade.org.eclipse.core.runtime.Status;
import org.jboss.forge.roaster._shade.org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.jboss.forge.roaster._shade.org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.jboss.forge.roaster._shade.org.eclipse.core.runtime.jobs.Job;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.util.NLS;

class JobListeners {
    private final IListenerDoit aboutToRun = IJobChangeListener::aboutToRun;
    private final IListenerDoit awake = IJobChangeListener::awake;
    private final IListenerDoit done = IJobChangeListener::done;
    private final IListenerDoit running = IJobChangeListener::running;
    private final IListenerDoit scheduled = IJobChangeListener::scheduled;
    private final IListenerDoit sleeping = IJobChangeListener::sleeping;
    protected final ListenerList<IJobChangeListener> global = new ListenerList(1);

    JobListeners() {
    }

    static JobChangeEvent newEvent(Job job) {
        JobChangeEvent instance = new JobChangeEvent();
        instance.job = job;
        return instance;
    }

    static JobChangeEvent newEvent(Job job, IStatus result) {
        JobChangeEvent instance = new JobChangeEvent();
        instance.job = job;
        instance.result = result;
        return instance;
    }

    static JobChangeEvent newEvent(Job job, long delay) {
        JobChangeEvent instance = new JobChangeEvent();
        instance.job = job;
        instance.delay = delay;
        return instance;
    }

    private void doNotify(IListenerDoit doit, IJobChangeEvent event) {
        for (IJobChangeListener listener : this.global) {
            try {
                doit.notify(listener, event);
            }
            catch (Throwable e) {
                this.handleException(listener, e);
            }
        }
        for (IJobChangeListener listener : event.getJob().getListeners()) {
            try {
                doit.notify(listener, event);
            }
            catch (Throwable e) {
                this.handleException(listener, e);
            }
        }
    }

    private void handleException(IJobChangeListener listener, Throwable e) {
        if (e instanceof OperationCanceledException) {
            return;
        }
        String pluginId = JobOSGiUtils.getDefault().getBundleId(listener);
        if (pluginId == null) {
            pluginId = "org.jboss.forge.roaster._shade.org.eclipse.core.jobs";
        }
        String message = NLS.bind(JobMessages.meta_pluginProblems, pluginId);
        RuntimeLog.log(new Status(4, pluginId, 2, message, e));
    }

    public void add(IJobChangeListener listener) {
        this.global.add(listener);
    }

    public void remove(IJobChangeListener listener) {
        this.global.remove(listener);
    }

    public void aboutToRun(Job job) {
        this.doNotify(this.aboutToRun, JobListeners.newEvent(job));
    }

    public void awake(Job job) {
        this.doNotify(this.awake, JobListeners.newEvent(job));
    }

    public void done(Job job, IStatus result, boolean reschedule) {
        JobChangeEvent event = JobListeners.newEvent(job, result);
        event.reschedule = reschedule;
        this.doNotify(this.done, event);
    }

    public void running(Job job) {
        this.doNotify(this.running, JobListeners.newEvent(job));
    }

    public void scheduled(Job job, long delay, boolean reschedule) {
        JobChangeEvent event = JobListeners.newEvent(job, delay);
        event.reschedule = reschedule;
        this.doNotify(this.scheduled, event);
    }

    public void sleeping(Job job) {
        this.doNotify(this.sleeping, JobListeners.newEvent(job));
    }

    static interface IListenerDoit {
        public void notify(IJobChangeListener var1, IJobChangeEvent var2);
    }
}

