/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.cds;

import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.cds.CDSHookImpls;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.framework.EquinoxContainer;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.hookregistry.HookConfigurator;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.hookregistry.HookRegistry;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.log.EquinoxLogServices;

public class CDSHookConfigurator
implements HookConfigurator {
    private static final String REPORT_ERRORS = "j9.cds.reporterrors";
    private static final String DISABLE_CDS = "j9.cds.disable";
    private static final String OLD_CDS_CONFIGURATOR = "com.ibm.cds.CDSHookConfigurator";
    private static final String J9_SHARED_CLASS_HELPER_CLASS = "com.ibm.oti.shared.SharedClassHelperFactory";

    @Override
    public void addHooks(HookRegistry hookRegistry) {
        boolean disableCDS = Boolean.valueOf(hookRegistry.getConfiguration().getProperty(DISABLE_CDS));
        if (disableCDS) {
            return;
        }
        try {
            Class.forName(OLD_CDS_CONFIGURATOR);
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                Class.forName(J9_SHARED_CLASS_HELPER_CLASS);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                boolean reportErrors = Boolean.valueOf(hookRegistry.getConfiguration().getProperty(REPORT_ERRORS));
                if (reportErrors) {
                    EquinoxContainer container = hookRegistry.getContainer();
                    EquinoxLogServices logServices = container.getLogServices();
                    logServices.log("org.jboss.forge.roaster._shade.org.eclipse.osgi", 2, "The J9 Class Sharing Adaptor will not work in this configuration. You are not running on a J9 Java VM.", null);
                }
                return;
            }
            new CDSHookImpls().registerHooks(hookRegistry);
            return;
        }
    }
}

