/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.loader.classpath;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.container.Module;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.framework.util.KeyedElement;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.loader.classpath.ManifestPackageAttributes;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.storage.BundleInfo;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.storage.Storage;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.storage.bundlefile.BundleEntry;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.storage.bundlefile.BundleFile;

public class ClasspathEntry {
    private final BundleFile bundlefile;
    private final ProtectionDomain domain;
    private final ManifestPackageAttributes mainManifestPackageAttributes;
    private final Map<String, ManifestPackageAttributes> perPackageManifestAttributes;
    private final List<BundleFile> mrBundleFiles;
    private HashMap<Object, KeyedElement> userObjects = null;
    private final PDEData data;

    public ClasspathEntry(BundleFile bundlefile, ProtectionDomain domain, BundleInfo.Generation generation) {
        this.bundlefile = bundlefile;
        this.domain = domain;
        this.data = new PDEData(generation.getBundleFile().getBaseFile(), generation.getRevision().getSymbolicName());
        Manifest manifest = ClasspathEntry.loadManifest(bundlefile, generation);
        if (manifest != null && generation.getBundleInfo().getStorage().getConfiguration().DEFINE_PACKAGE_ATTRIBUTES) {
            this.mainManifestPackageAttributes = ClasspathEntry.manifestPackageAttributesFor(manifest.getMainAttributes(), null);
            this.perPackageManifestAttributes = ClasspathEntry.manifestPackageAttributesMapFor(manifest.getEntries().entrySet(), this.mainManifestPackageAttributes);
        } else {
            this.mainManifestPackageAttributes = ManifestPackageAttributes.NONE;
            this.perPackageManifestAttributes = null;
        }
        boolean isMRJar = bundlefile == generation.getBundleFile() ? generation.isMRJar() : (manifest != null ? Boolean.parseBoolean(manifest.getMainAttributes().getValue("Multi-Release")) : false);
        this.mrBundleFiles = isMRJar ? ClasspathEntry.getMRBundleFiles(bundlefile, generation) : Collections.emptyList();
    }

    private static List<BundleFile> getMRBundleFiles(BundleFile bundlefile, BundleInfo.Generation generation) {
        Storage storage = generation.getBundleInfo().getStorage();
        if (storage.getRuntimeVersion().getMajor() < 9) {
            return Collections.emptyList();
        }
        ArrayList<BundleFile> mrBundleFiles = new ArrayList<BundleFile>();
        int i = storage.getRuntimeVersion().getMajor();
        while (i > 8) {
            String versionPath = "META-INF/versions/" + i + '/';
            BundleEntry versionEntry = bundlefile.getEntry(versionPath);
            if (versionEntry != null) {
                mrBundleFiles.add(storage.createNestedBundleFile(versionPath, bundlefile, generation, BundleInfo.MULTI_RELEASE_FILTER_PREFIXES));
            }
            --i;
        }
        return Collections.unmodifiableList(mrBundleFiles);
    }

    private static ManifestPackageAttributes manifestPackageAttributesFor(Attributes attributes, ManifestPackageAttributes defaultAttributes) {
        return ManifestPackageAttributes.of(attributes.getValue(Attributes.Name.SPECIFICATION_TITLE), attributes.getValue(Attributes.Name.SPECIFICATION_VERSION), attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR), attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE), attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION), attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR), defaultAttributes);
    }

    private static Map<String, ManifestPackageAttributes> manifestPackageAttributesMapFor(Set<Map.Entry<String, Attributes>> entries, ManifestPackageAttributes defaultAttributes) {
        HashMap<String, ManifestPackageAttributes> result = null;
        for (Map.Entry<String, Attributes> entry : entries) {
            String name = entry.getKey();
            Attributes attributes = entry.getValue();
            if (name == null || !name.endsWith("/")) continue;
            String packageName = name.substring(0, name.length() - 1).replace('/', '.');
            if (result == null) {
                result = new HashMap<String, ManifestPackageAttributes>(4);
            }
            result.put(packageName, ClasspathEntry.manifestPackageAttributesFor(attributes, defaultAttributes));
        }
        return result;
    }

    public BundleFile getBundleFile() {
        return this.bundlefile;
    }

    public ProtectionDomain getDomain() {
        return this.domain;
    }

    public synchronized Object getUserObject(Object key) {
        if (this.userObjects == null) {
            return null;
        }
        return this.userObjects.get(key);
    }

    public synchronized void addUserObject(KeyedElement userObject) {
        if (this.userObjects == null) {
            this.userObjects = new HashMap(5);
        }
        if (!this.userObjects.containsKey(userObject.getKey())) {
            this.userObjects.put(userObject.getKey(), userObject);
        }
    }

    public BundleEntry findEntry(String path) {
        for (BundleFile mrFile : this.mrBundleFiles) {
            BundleEntry mrEntry = mrFile.getEntry(path);
            if (mrEntry == null) continue;
            return mrEntry;
        }
        return this.bundlefile.getEntry(path);
    }

    public URL findResource(String name, Module m, int index) {
        for (BundleFile mrFile : this.mrBundleFiles) {
            URL mrURL = mrFile.getResourceURL(name, m, index);
            if (mrURL == null) continue;
            return mrURL;
        }
        return this.bundlefile.getResourceURL(name, m, index);
    }

    public void addBundleFiles(List<BundleFile> bundlefiles) {
        bundlefiles.addAll(this.mrBundleFiles);
        bundlefiles.add(this.bundlefile);
    }

    private static Manifest loadManifest(BundleFile cpBundleFile, BundleInfo.Generation generation) {
        if (!generation.hasPackageInfo() && generation.getBundleFile() == cpBundleFile) {
            return null;
        }
        BundleEntry mfEntry = cpBundleFile.getEntry("META-INF/MANIFEST.MF");
        if (mfEntry != null) {
            Manifest manifest;
            block8: {
                InputStream manIn = null;
                try {
                    manIn = mfEntry.getInputStream();
                    manifest = new Manifest(manIn);
                    if (manIn == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (manIn != null) {
                            manIn.close();
                        }
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                }
                manIn.close();
            }
            return manifest;
        }
        return null;
    }

    ManifestPackageAttributes manifestPackageAttributesFor(String packageName) {
        ManifestPackageAttributes perPackage;
        ManifestPackageAttributes manifestPackageAttributes = perPackage = this.perPackageManifestAttributes == null ? null : this.perPackageManifestAttributes.get(packageName);
        if (perPackage != null) {
            return perPackage;
        }
        return this.mainManifestPackageAttributes;
    }

    public void close() throws IOException {
        this.bundlefile.close();
        for (BundleFile bf : this.mrBundleFiles) {
            bf.close();
        }
    }

    static final class PDEData {
        final String fileName;
        final String symbolicName;

        PDEData(File baseFile, String symbolicName) {
            this.fileName = baseFile == null ? null : baseFile.getAbsolutePath();
            this.symbolicName = symbolicName;
        }
    }
}

