/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster._shade.org.eclipse.osgi.storage.bundlefile;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.storage.bundlefile.BundleEntry;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.storage.bundlefile.BundleFile;

public class NestedDirBundleFile
extends BundleFile {
    private final BundleFile baseBundleFile;
    private final String nestedDirName;
    private final Collection<String> filterPrefixes;

    public NestedDirBundleFile(BundleFile baseBundlefile, String nestedDirName) {
        this(baseBundlefile, nestedDirName, Collections.emptyList());
    }

    public NestedDirBundleFile(BundleFile baseBundlefile, String nestedDirName, Collection<String> filterPrefixes) {
        super(baseBundlefile.getBaseFile());
        this.baseBundleFile = baseBundlefile;
        if (nestedDirName.charAt(nestedDirName.length() - 1) != '/') {
            nestedDirName = String.valueOf(nestedDirName) + '/';
        }
        this.nestedDirName = nestedDirName;
        this.filterPrefixes = filterPrefixes;
    }

    @Override
    public void close() {
    }

    private boolean filterPath(String path) {
        if (path.length() > 0 && path.charAt(0) == '/') {
            path = path.substring(1);
        }
        for (String prefix : this.filterPrefixes) {
            if (!path.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    private boolean filterDir(String path) {
        if (this.filterPrefixes.isEmpty()) {
            return false;
        }
        if (path.length() > 0 && path.charAt(path.length() - 1) != '/') {
            path = String.valueOf(path) + '/';
        }
        return this.filterPath(path);
    }

    @Override
    public BundleEntry getEntry(String path) {
        if (this.filterPath(path)) {
            return null;
        }
        return this.baseBundleFile.getEntry(this.prependNestedDir(path));
    }

    @Override
    public boolean containsDir(String dir) {
        if (dir == null) {
            return false;
        }
        if (this.filterPath(dir)) {
            return false;
        }
        return this.baseBundleFile.containsDir(this.prependNestedDir(dir));
    }

    private String prependNestedDir(String path) {
        if (path.length() > 0 && path.charAt(0) == '/') {
            path = path.substring(1);
        }
        return this.nestedDirName + path;
    }

    @Override
    public Enumeration<String> getEntryPaths(String path, boolean recurse) {
        if (this.filterDir(path)) {
            return null;
        }
        final Enumeration<String> basePaths = this.baseBundleFile.getEntryPaths(this.prependNestedDir(path), recurse);
        final int cpLength = this.nestedDirName.length();
        if (basePaths == null) {
            return null;
        }
        return new Enumeration<String>(){

            @Override
            public boolean hasMoreElements() {
                return basePaths.hasMoreElements();
            }

            @Override
            public String nextElement() {
                String next = (String)basePaths.nextElement();
                return next.substring(cpLength);
            }
        };
    }

    @Override
    public File getFile(String entry, boolean nativeCode) {
        return null;
    }

    @Override
    public void open() throws IOException {
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + '[' + this.nestedDirName + ']';
    }
}

