/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.api.config;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jboss.galleon.BaseErrors;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.api.config.GalleonConfigurationWithLayers;
import org.jboss.galleon.api.config.GalleonConfigurationWithLayersBuilderItf;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.StringUtils;

public class GalleonConfigurationWithLayersBuilder
implements GalleonConfigurationWithLayersBuilderItf {
    private String model;
    private String name;
    private Map<String, String> props = Collections.emptyMap();
    private Map<String, ConfigId> configDeps = Collections.emptyMap();
    private boolean inheritLayers = true;
    private Set<String> includedLayers = Collections.emptySet();
    private Set<String> excludedLayers = Collections.emptySet();

    protected GalleonConfigurationWithLayersBuilder() {
    }

    protected GalleonConfigurationWithLayersBuilder(String model, String name) {
        this.name = name;
        this.model = model;
    }

    protected GalleonConfigurationWithLayersBuilder(GalleonConfigurationWithLayers config) {
        this.model = config.getModel();
        this.props = CollectionUtils.clone(config.getProperties());
        this.configDeps = CollectionUtils.clone(config.getConfigDeps());
        this.inheritLayers = config.isInheritLayers();
        this.includedLayers = CollectionUtils.clone(config.getIncludedLayers());
        this.excludedLayers = CollectionUtils.clone(config.getExcludedLayers());
    }

    public String getName() {
        return this.name;
    }

    @Override
    public GalleonConfigurationWithLayersBuilder setModel(String model) {
        this.model = model;
        return this;
    }

    @Override
    public GalleonConfigurationWithLayersBuilder setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public GalleonConfigurationWithLayersBuilder setProperty(String name, String value) {
        this.props = CollectionUtils.put(this.props, name, value);
        return this;
    }

    @Override
    public GalleonConfigurationWithLayersBuilder setConfigDep(String depName, ConfigId configId) {
        this.configDeps = CollectionUtils.putLinked(this.configDeps, depName, configId);
        return this;
    }

    @Override
    public GalleonConfigurationWithLayersBuilder setInheritLayers(boolean inheritLayers) {
        this.inheritLayers = inheritLayers;
        return this;
    }

    @Override
    public GalleonConfigurationWithLayersBuilder includeLayer(String layerName) throws ProvisioningDescriptionException {
        if (this.excludedLayers.contains(layerName)) {
            throw new ProvisioningDescriptionException(BaseErrors.configLayerCanEitherBeIncludedOrExcluded(this.model, this.getName(), layerName));
        }
        this.includedLayers = CollectionUtils.addLinked(this.includedLayers, layerName);
        return this;
    }

    @Override
    public GalleonConfigurationWithLayersBuilder removeIncludedLayer(String layer) {
        this.includedLayers = CollectionUtils.remove(this.includedLayers, layer);
        return this;
    }

    @Override
    public GalleonConfigurationWithLayersBuilder removeExcludedLayer(String layer) {
        this.excludedLayers = CollectionUtils.remove(this.excludedLayers, layer);
        return this;
    }

    @Override
    public GalleonConfigurationWithLayersBuilder excludeLayer(String layerName) throws ProvisioningDescriptionException {
        if (this.includedLayers.contains(layerName)) {
            throw new ProvisioningDescriptionException(BaseErrors.configLayerCanEitherBeIncludedOrExcluded(this.model, this.getName(), layerName));
        }
        this.excludedLayers = CollectionUtils.addLinked(this.excludedLayers, layerName);
        return this;
    }

    @Override
    public GalleonConfigurationWithLayers build() throws ProvisioningDescriptionException {
        return new GalleonConfigurationImpl(this);
    }

    public static GalleonConfigurationWithLayersBuilder builder() {
        return new GalleonConfigurationWithLayersBuilder();
    }

    public static GalleonConfigurationWithLayersBuilder builder(String model, String name) {
        return new GalleonConfigurationWithLayersBuilder(model, name);
    }

    public static GalleonConfigurationWithLayersBuilder builder(GalleonConfigurationWithLayers config) {
        return new GalleonConfigurationWithLayersBuilder(config);
    }

    static class GalleonConfigurationImpl
    implements GalleonConfigurationWithLayers {
        final ConfigId id;
        final Map<String, String> props;
        final Map<String, ConfigId> configDeps;
        final boolean inheritLayers;
        final Set<String> includedLayers;
        final Set<String> excludedLayers;

        protected GalleonConfigurationImpl(GalleonConfigurationWithLayersBuilder builder) throws ProvisioningDescriptionException {
            this.id = new ConfigId(builder.model, builder.name);
            this.props = CollectionUtils.unmodifiable(builder.props);
            this.configDeps = CollectionUtils.unmodifiable(builder.configDeps);
            this.inheritLayers = builder.inheritLayers;
            this.includedLayers = CollectionUtils.unmodifiable(builder.includedLayers);
            this.excludedLayers = CollectionUtils.unmodifiable(builder.excludedLayers);
        }

        @Override
        public ConfigId getId() {
            return this.id;
        }

        @Override
        public String getModel() {
            return this.id.getModel();
        }

        @Override
        public String getName() {
            return this.id.getName();
        }

        @Override
        public boolean hasProperties() {
            return !this.props.isEmpty();
        }

        @Override
        public Map<String, String> getProperties() {
            return this.props;
        }

        @Override
        public boolean hasConfigDeps() {
            return !this.configDeps.isEmpty();
        }

        @Override
        public Map<String, ConfigId> getConfigDeps() {
            return this.configDeps;
        }

        @Override
        public boolean isInheritLayers() {
            return this.inheritLayers;
        }

        @Override
        public boolean hasIncludedLayers() {
            return !this.includedLayers.isEmpty();
        }

        @Override
        public Set<String> getIncludedLayers() {
            return this.includedLayers;
        }

        @Override
        public boolean isLayerIncluded(String layerName) {
            return this.includedLayers.contains(layerName);
        }

        @Override
        public boolean hasExcludedLayers() {
            return !this.excludedLayers.isEmpty();
        }

        @Override
        public Set<String> getExcludedLayers() {
            return this.excludedLayers;
        }

        @Override
        public boolean isLayerExcluded(String layerName) {
            return this.excludedLayers.contains(layerName);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.configDeps == null ? 0 : this.configDeps.hashCode());
            result = 31 * result + (this.excludedLayers == null ? 0 : this.excludedLayers.hashCode());
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            result = 31 * result + (this.includedLayers == null ? 0 : this.includedLayers.hashCode());
            result = 31 * result + (this.inheritLayers ? 1231 : 1237);
            result = 31 * result + (this.props == null ? 0 : this.props.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GalleonConfigurationImpl other = (GalleonConfigurationImpl)obj;
            if (this.configDeps == null ? other.configDeps != null : !this.configDeps.equals(other.configDeps)) {
                return false;
            }
            if (this.excludedLayers == null ? other.excludedLayers != null : !this.excludedLayers.equals(other.excludedLayers)) {
                return false;
            }
            if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
                return false;
            }
            if (this.includedLayers == null ? other.includedLayers != null : !this.includedLayers.equals(other.includedLayers)) {
                return false;
            }
            if (this.inheritLayers != other.inheritLayers) {
                return false;
            }
            return !(this.props == null ? other.props != null : !this.props.equals(other.props));
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("[model=").append(this.id.getModel()).append(" name=").append(this.id.getName());
            if (!this.props.isEmpty()) {
                buf.append(" props=");
                StringUtils.append(buf, this.props.entrySet());
            }
            if (!this.configDeps.isEmpty()) {
                buf.append(" config-deps=");
                StringUtils.append(buf, this.configDeps.entrySet());
            }
            if (!this.inheritLayers) {
                buf.append(" inherit-layers=false");
            }
            if (!this.includedLayers.isEmpty()) {
                buf.append(" included-layers=");
                StringUtils.append(buf, this.includedLayers);
            }
            if (!this.excludedLayers.isEmpty()) {
                buf.append(" excluded-layers=");
                StringUtils.append(buf, this.excludedLayers);
            }
            return buf.append(']').toString();
        }
    }
}

